<?php
$assets = base_url() . 'assets/';

// Get the form template structure to make PDF dynamic
$formTemplateJson = dailyReportJson();
$formTemplate = json_decode($formTemplateJson, true);

// Extract sections from template
$ensureWorkingTemplate = $formTemplate['ensure_working'] ?? [];
$dailyWorkTemplate = $formTemplate['daily_work'] ?? [];
$periodicalWorksTemplate = $formTemplate['periodical_works'] ?? [];
$serviceProvidersTemplate = $formTemplate['service_providers'] ?? [];
$collectionDescriptionTemplate = $formTemplate['collection_description'] ?? [];
$cashWithManagerTemplate = $formTemplate['cash_with_manager'] ?? [];

// Helper function to format field names for display
if (!function_exists('pdfFormatFieldName')) {
    function pdfFormatFieldName($fieldName) {
        return ucwords(str_replace('_', ' ', $fieldName));
    }
}

// Helper function to check if service provider has complex structure (M/S/G/P)
if (!function_exists('pdfHasComplexStructure')) {
    function pdfHasComplexStructure($providerData) {
        return isset($providerData['required']) && is_array($providerData['required']);
    }
}

// Helper function to get service provider columns
if (!function_exists('pdfGetServiceProviderColumns')) {
    function pdfGetServiceProviderColumns($providerData) {
        $columns = [];
        if (isset($providerData['required']) && is_array($providerData['required'])) {
            $columns = array_keys($providerData['required']);
        }
        return $columns;
    }
}

// Helper function to check if daily work item has time fields
if (!function_exists('pdfHasTimeFields')) {
    function pdfHasTimeFields($workKey) {
        $timeBasedItems = ['society_rounds', 'generator_usage'];
        return in_array($workKey, $timeBasedItems);
    }
}

// Helper function to safely get string value (handles arrays)
if (!function_exists('pdfGetStringValue')) {
    function pdfGetStringValue($value) {
        if (is_array($value)) {
            // If it's an array, join non-empty values with comma
            $stringValues = array_filter($value, function($v) {
                return !is_array($v) && $v !== '' && $v !== null;
            });
            return implode(', ', $stringValues);
        }
        return ($value !== null && $value !== '') ? $value : ' ';
    }
}
?>



<!DOCTYPE html>
<html lang="en">
    <style>
    
        td {
            height: 10px
        }
    </style>
<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $name; ?></title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
          type="text/css">

    <link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
    <link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">

</head>

<body style='font-family:chelvetica;font-size: 9px'>
    <table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">

        <!-- Header Row with Report Date -->
        <tr>
            <td colspan="10"><center><strong><?= lang('DailyReport.daily_report_details')?></strong></center></td>
            <td colspan="2"><center><strong><?= lang('DailyReport.report_date')?></strong></center></td>
            <td colspan="2"><center>
                <?= isset($daily_report_data['report_date']) ? siteDateFormat($daily_report_data['report_date']) : ' ' ?></center>
            </td>
        </tr>

        <?php
        // =====================================================
        // DYNAMIC PDF GENERATION
        // =====================================================

        // Prepare arrays for each section (excluding 'others' fields which will be shown separately)
        $ensureWorkingItems = [];
        $dailyWorkItems = [];
        $periodicalWorksItems = [];
        $serviceProviderItems = [];

        // Process ensure_working (exclude 'others')
        foreach ($ensureWorkingTemplate as $key => $value) {
            if ($key !== 'others') {
                $ensureWorkingItems[$key] = $value;
            }
        }

        // Process daily_work (exclude 'others' and time-based items which are shown separately)
        foreach ($dailyWorkTemplate as $key => $value) {
            if ($key !== 'others' && !pdfHasTimeFields($key)) {
                $dailyWorkItems[$key] = $value;
            }
        }

        // Process periodical_works (exclude 'others')
        foreach ($periodicalWorksTemplate as $key => $value) {
            if ($key !== 'others') {
                $periodicalWorksItems[$key] = $value;
            }
        }

        // Process service_providers (exclude 'others')
        foreach ($serviceProvidersTemplate as $key => $value) {
            if ($key !== 'others') {
                $serviceProviderItems[$key] = $value;
            }
        }

        // Convert to indexed arrays for easier iteration
        $ensureWorkingKeys = array_keys($ensureWorkingItems);
        $dailyWorkKeys = array_keys($dailyWorkItems);
        $periodicalWorksKeys = array_keys($periodicalWorksItems);
        $serviceProviderKeys = array_keys($serviceProviderItems);

        // Calculate max rows needed for the first combined section (ensure_working + daily_work)
        $maxRows1 = max(count($ensureWorkingKeys), count($dailyWorkKeys));

        // Calculate max rows needed for the second combined section (service_providers + periodical_works)
        $maxRows2 = max(count($serviceProviderKeys), count($periodicalWorksKeys));
        ?>

        <!-- Section Headers: Ensure Working + Daily Work -->
        <tr>
            <td colspan="3" style="background-color: gray;"><center><strong><?= lang('DailyReport.ensure_working')?></strong></center></td>
            <td colspan="4" style="background-color: gray;"><center><strong><?= lang('DailyReport.status')?></strong></center></td>
            <td colspan="3" style="background-color: gray;"><center><strong><?= lang('DailyReport.daily_work')?></strong></center></td>
            <td colspan="4" style="background-color: gray;"><center><strong><?= lang('DailyReport.status')?></strong></center></td>
        </tr>

        <?php
        // Generate rows for Ensure Working + Daily Work
        for ($i = 0; $i < $maxRows1; $i++):
            // Get ensure_working item
            $ewKey = isset($ensureWorkingKeys[$i]) ? $ensureWorkingKeys[$i] : null;
            $ewValue = '';
            if ($ewKey) {
                $ewValue = isset($report_json_data['ensure_working'][$ewKey]) ? $report_json_data['ensure_working'][$ewKey] : '';
            }

            // Get daily_work item
            $dwKey = isset($dailyWorkKeys[$i]) ? $dailyWorkKeys[$i] : null;
            $dwData = isset($dailyWorkTemplate[$dwKey]) ? $dailyWorkTemplate[$dwKey] : null;
        ?>
        <tr>
            <!-- Ensure Working Column -->
            <?php if ($ewKey): ?>
                <td colspan="3"><center><strong><?= lang('DailyReport.' . $ewKey) ?: pdfFormatFieldName($ewKey) ?></strong></center></td>
                <td colspan="4"><center><?= $ewValue ?: ' ' ?></center></td>
            <?php else: ?>
                <td colspan="3"><center> </center></td>
                <td colspan="4"><center> </center></td>
            <?php endif; ?>

            <!-- Daily Work Column -->
            <?php if ($dwKey && is_array($dwData)): ?>
                <?php
                $subKeys = array_keys($dwData);
                $subCount = count($subKeys);
                ?>
                <td colspan="3"><center><strong><?= lang('DailyReport.' . $dwKey) ?: pdfFormatFieldName($dwKey) ?></strong></center></td>
                <?php if ($subCount >= 2): ?>
                    <td colspan="2"><center><?= isset($report_json_data['daily_work'][$dwKey][$subKeys[0]]) ? $report_json_data['daily_work'][$dwKey][$subKeys[0]] : ' ' ?></center></td>
                    <td colspan="2"><center><?= isset($report_json_data['daily_work'][$dwKey][$subKeys[1]]) ? $report_json_data['daily_work'][$dwKey][$subKeys[1]] : ' ' ?></center></td>
                <?php else: ?>
                    <td colspan="4"><center><?= isset($report_json_data['daily_work'][$dwKey][$subKeys[0]]) ? $report_json_data['daily_work'][$dwKey][$subKeys[0]] : ' ' ?></center></td>
                <?php endif; ?>
            <?php elseif ($dwKey): ?>
                <td colspan="3"><center><strong><?= lang('DailyReport.' . $dwKey) ?: pdfFormatFieldName($dwKey) ?></strong></center></td>
                <td colspan="4"><center><?= isset($report_json_data['daily_work'][$dwKey]) ? $report_json_data['daily_work'][$dwKey] : ' ' ?></center></td>
            <?php else: ?>
                <td colspan="3"><center> </center></td>
                <td colspan="4"><center> </center></td>
            <?php endif; ?>
        </tr>
        <?php endfor; ?>

        <!-- Ensure Working Others Field -->
        <?php if (isset($ensureWorkingTemplate['others'])): ?>
        <tr>
            <td colspan="3"><center><strong><?= lang('DailyReport.others') ?> (Ensure Working)</strong></center></td>
            <td colspan="4"><center><?= pdfGetStringValue($report_json_data['ensure_working']['others'] ?? '') ?></center></td>
            <td colspan="3"><center><strong><?= lang('DailyReport.others') ?> (Daily Work)</strong></center></td>
            <td colspan="4"><center><?= pdfGetStringValue($report_json_data['daily_work']['others'] ?? '') ?></center></td>
        </tr>
        <?php endif; ?>

        <!-- Section Headers: Service Providers + Periodical Works -->
        <tr>
            <td colspan="3" style="background-color: gray;"><center><strong><?= lang('DailyReport.service_providers')?></strong></center></td>
            <td colspan="2" style="background-color: gray;"><center><strong><?= lang('DailyReport.req')?></strong></center></td>
            <td colspan="2" style="background-color: gray;"><center><strong><?= lang('DailyReport.avl')?></strong></center></td>
            <td colspan="3" style="background-color: gray;"><center><strong><?= lang('DailyReport.periodical_working')?></strong></center></td>
            <td colspan="2" style="background-color: gray;"><center><strong><?= lang('DailyReport.scheduled')?></strong></center></td>
            <td colspan="2" style="background-color: gray;"><center><strong><?= lang('DailyReport.details')?></strong></center></td>
        </tr>

        <?php
        // Generate rows for Service Providers + Periodical Works
        for ($i = 0; $i < $maxRows2; $i++):
            // Get service_provider item
            $spKey = isset($serviceProviderKeys[$i]) ? $serviceProviderKeys[$i] : null;
            $spData = isset($serviceProvidersTemplate[$spKey]) ? $serviceProvidersTemplate[$spKey] : null;

            // Get periodical_works item
            $pwKey = isset($periodicalWorksKeys[$i]) ? $periodicalWorksKeys[$i] : null;
        ?>
        <tr>
            <!-- Service Providers Column -->
            <?php if ($spKey && pdfHasComplexStructure($spData)): ?>
                <?php $columns = pdfGetServiceProviderColumns($spData); ?>
                <td colspan="3"><center><strong><?= lang('DailyReport.' . $spKey) ?: pdfFormatFieldName($spKey) ?></strong></center></td>
                <?php if (count($columns) >= 2): ?>
                    <td colspan="1"><center><?= isset($report_json_data['service_providers'][$spKey]['required'][$columns[0]]) ? $report_json_data['service_providers'][$spKey]['required'][$columns[0]] : ' ' ?></center></td>
                    <td colspan="1"><center><?= isset($report_json_data['service_providers'][$spKey]['required'][$columns[1]]) ? $report_json_data['service_providers'][$spKey]['required'][$columns[1]] : ' ' ?></center></td>
                    <td colspan="1"><center><?= isset($report_json_data['service_providers'][$spKey]['available'][$columns[0]]) ? $report_json_data['service_providers'][$spKey]['available'][$columns[0]] : ' ' ?></center></td>
                    <td colspan="1"><center><?= isset($report_json_data['service_providers'][$spKey]['available'][$columns[1]]) ? $report_json_data['service_providers'][$spKey]['available'][$columns[1]] : ' ' ?></center></td>
                <?php else: ?>
                    <td colspan="2"><center><?= isset($report_json_data['service_providers'][$spKey]['required'][$columns[0]]) ? $report_json_data['service_providers'][$spKey]['required'][$columns[0]] : ' ' ?></center></td>
                    <td colspan="2"><center><?= isset($report_json_data['service_providers'][$spKey]['available'][$columns[0]]) ? $report_json_data['service_providers'][$spKey]['available'][$columns[0]] : ' ' ?></center></td>
                <?php endif; ?>
            <?php elseif ($spKey): ?>
                <td colspan="3"><center><strong><?= lang('DailyReport.' . $spKey) ?: pdfFormatFieldName($spKey) ?></strong></center></td>
                <td colspan="2"><center><?= isset($report_json_data['service_providers'][$spKey]['required']) ? $report_json_data['service_providers'][$spKey]['required'] : ' ' ?></center></td>
                <td colspan="2"><center><?= isset($report_json_data['service_providers'][$spKey]['available']) ? $report_json_data['service_providers'][$spKey]['available'] : ' ' ?></center></td>
            <?php else: ?>
                <td colspan="3"><center> </center></td>
                <td colspan="2"><center> </center></td>
                <td colspan="2"><center> </center></td>
            <?php endif; ?>

            <!-- Periodical Works Column -->
            <?php if ($pwKey): ?>
                <td colspan="3"><center><strong><?= lang('DailyReport.' . $pwKey) ?: pdfFormatFieldName($pwKey) ?></strong></center></td>
                <td colspan="2"><center><?= isset($report_json_data['periodical_works'][$pwKey]['scheduled']) ? $report_json_data['periodical_works'][$pwKey]['scheduled'] : ' ' ?></center></td>
                <td colspan="2"><center><?= isset($report_json_data['periodical_works'][$pwKey]['details']) ? $report_json_data['periodical_works'][$pwKey]['details'] : ' ' ?></center></td>
            <?php else: ?>
                <td colspan="3"><center> </center></td>
                <td colspan="2"><center> </center></td>
                <td colspan="2"><center> </center></td>
            <?php endif; ?>
        </tr>
        <?php endfor; ?>

        <!-- Service Providers Others + Periodical Works Others -->
        <tr>
            <td colspan="3"><center><strong><?= lang('DailyReport.others') ?> (Service Providers)</strong></center></td>
            <td colspan="4"><center><?= pdfGetStringValue($report_json_data['service_providers']['others'] ?? '') ?></center></td>
            <td colspan="3"><center><strong><?= lang('DailyReport.others') ?> (Periodical Works)</strong></center></td>
            <td colspan="4"><center><?= pdfGetStringValue($report_json_data['periodical_works']['others'] ?? '') ?></center></td>
        </tr>

        <!-- Collection Description Section -->
        <tr>
            <td colspan="7" style="background-color: gray;"><center><strong><?= lang('DailyReport.collection_description')?></strong></center></td>
            <td colspan="7" style="background-color: gray;"><center><strong><?= lang('DailyReport.amount')?></strong></center></td>
        </tr>
        <tr>
            <!-- Labels (under Collection Description header) - 7 cols total -->
            <td colspan="2"><center><strong><?= lang('DailyReport.maintenance') ?></strong></center></td>
            <td colspan="2"><center><strong><?= lang('DailyReport.bookings') ?></strong></center></td>
            <td colspan="2"><center><strong><?= lang('DailyReport.penalties') ?></strong></center></td>
            <td colspan="1"><center><strong><?= lang('DailyReport.others') ?></strong></center></td>
            <!-- Values (under Amount header) - 7 cols total -->
            <td colspan="2"><center><?= pdfGetStringValue($report_json_data['collection_description']['maintenance'] ?? '') ?></center></td>
            <td colspan="2"><center><?= pdfGetStringValue($report_json_data['collection_description']['bookings'] ?? '') ?></center></td>
            <td colspan="2"><center><?= pdfGetStringValue($report_json_data['collection_description']['penalties'] ?? '') ?></center></td>
            <td colspan="1"><center><?= pdfGetStringValue($report_json_data['collection_description']['others'] ?? '') ?></center></td>
        </tr>

        <!-- Cash with Manager Section - Fixed layout with 5 fields -->
        <tr>
            <td colspan="14" style="background-color: gray;"><center><strong><?= lang('DailyReport.cash_with_manager')?></strong></center></td>
        </tr>
        <tr>
            <!-- Labels row - 5 fields, each gets ~2-3 cols (total 14) -->
            <td colspan="3"><center><strong><?= lang('DailyReport.opening') ?></strong></center></td>
            <td colspan="3"><center><strong><?= lang('DailyReport.receipt') ?></strong></center></td>
            <td colspan="3"><center><strong><?= lang('DailyReport.payment') ?></strong></center></td>
            <td colspan="3"><center><strong><?= lang('DailyReport.balance') ?></strong></center></td>
            <td colspan="2"><center><strong><?= lang('DailyReport.others') ?></strong></center></td>
        </tr>
        <tr>
            <!-- Values row -->
            <td colspan="3"><center><?= pdfGetStringValue($report_json_data['cash_with_manager']['opening'] ?? '') ?></center></td>
            <td colspan="3"><center><?= pdfGetStringValue($report_json_data['cash_with_manager']['receipt'] ?? '') ?></center></td>
            <td colspan="3"><center><?= pdfGetStringValue($report_json_data['cash_with_manager']['payment'] ?? '') ?></center></td>
            <td colspan="3"><center><?= pdfGetStringValue($report_json_data['cash_with_manager']['balance'] ?? '') ?></center></td>
            <td colspan="2"><center><?= pdfGetStringValue($report_json_data['cash_with_manager']['others'] ?? '') ?></center></td>
        </tr>

        <!-- Water Meter Reading Section -->
        <tr>
            <td colspan="14" style="background-color: gray;"><center><strong><?= lang('DailyReport.water_meter_reading') ?></strong></center></td>
        </tr>

        <?php
        // Dynamic Water Meter Reading with Labels
        $meterData = [];
        if (!empty($report_json_data['water_meter_reading']) && is_array($report_json_data['water_meter_reading'])) {
            $meterData = $report_json_data['water_meter_reading'];
        }

        $perRow = 14;
        if (empty($meterData)) {
            echo '<tr>';
            for ($i = 0; $i < $perRow; $i++) {
                echo '<td colspan="1"><center> </center></td>';
            }
            echo '</tr>';
        } else {
            $meterKeys = array_keys($meterData);
            $meterChunks = array_chunk($meterKeys, $perRow);

            foreach ($meterChunks as $chunk) {
                // Labels row
                echo '<tr>';
                foreach ($chunk as $meterKey) {
                    $label = pdfFormatFieldName(str_replace('meter_', 'M', $meterKey));
                    echo '<td colspan="1" style="background-color: #f0f0f0;"><center><strong>' . htmlspecialchars($label) . '</strong></center></td>';
                }
                $missing = $perRow - count($chunk);
                for ($i = 0; $i < $missing; $i++) {
                    echo '<td colspan="1"><center> </center></td>';
                }
                echo '</tr>';

                // Values row
                echo '<tr>';
                foreach ($chunk as $meterKey) {
                    $val = isset($meterData[$meterKey]) ? $meterData[$meterKey] : '';
                    $show = ($val !== null && $val !== '') ? $val : ' ';
                    echo '<td colspan="1"><center>' . htmlspecialchars($show) . '</center></td>';
                }
                for ($i = 0; $i < $missing; $i++) {
                    echo '<td colspan="1"><center> </center></td>';
                }
                echo '</tr>';
            }
        }
        ?>

        <!-- Society Rounds Section -->
        <tr>
            <td colspan="14" style="background-color: gray;"><center><strong><?= lang('DailyReport.society_rounds') ?></strong></center></td>
        </tr>

        <?php
        // Dynamic Society Rounds with Labels
        $roundsData = [];
        if (!empty($report_json_data['daily_work']['society_rounds']) && is_array($report_json_data['daily_work']['society_rounds'])) {
            $roundsData = $report_json_data['daily_work']['society_rounds'];
        }

        $perRow = 14;
        if (empty($roundsData)) {
            echo '<tr>';
            for ($i = 0; $i < $perRow; $i++) {
                echo '<td colspan="1"><center> </center></td>';
            }
            echo '</tr>';
        } else {
            $roundsKeys = array_keys($roundsData);
            $roundsChunks = array_chunk($roundsKeys, $perRow);

            foreach ($roundsChunks as $chunk) {
                // Labels row
                echo '<tr>';
                foreach ($chunk as $roundKey) {
                    $label = pdfFormatFieldName(str_replace('time', 'Time ', $roundKey));
                    echo '<td colspan="1" style="background-color: #f0f0f0;"><center><strong>' . htmlspecialchars($label) . '</strong></center></td>';
                }
                $missing = $perRow - count($chunk);
                for ($i = 0; $i < $missing; $i++) {
                    echo '<td colspan="1"><center> </center></td>';
                }
                echo '</tr>';

                // Values row
                echo '<tr>';
                foreach ($chunk as $roundKey) {
                    $val = isset($roundsData[$roundKey]) ? $roundsData[$roundKey] : '';
                    $show = ($val !== null && $val !== '') ? $val : ' ';
                    echo '<td colspan="1"><center>' . htmlspecialchars($show) . '</center></td>';
                }
                for ($i = 0; $i < $missing; $i++) {
                    echo '<td colspan="1"><center> </center></td>';
                }
                echo '</tr>';
            }
        }
        ?>

        <!-- Generator Usage Section -->
        <tr>
            <td colspan="14" style="background-color: gray;"><center><strong><?= lang('DailyReport.generator_usage') ?></strong></center></td>
        </tr>

        <?php
        // Dynamic Generator Usage with Labels
        $generatorData = [];
        if (!empty($report_json_data['daily_work']['generator_usage']) && is_array($report_json_data['daily_work']['generator_usage'])) {
            $generatorData = $report_json_data['daily_work']['generator_usage'];
        }

        $perRow = 14;
        if (empty($generatorData)) {
            echo '<tr>';
            for ($i = 0; $i < $perRow; $i++) {
                echo '<td colspan="1"><center> </center></td>';
            }
            echo '</tr>';
        } else {
            $genKeys = array_keys($generatorData);
            $genChunks = array_chunk($genKeys, $perRow);

            foreach ($genChunks as $chunk) {
                // Labels row
                echo '<tr>';
                foreach ($chunk as $genKey) {
                    $label = pdfFormatFieldName(str_replace('time', 'Time ', $genKey));
                    echo '<td colspan="1" style="background-color: #f0f0f0;"><center><strong>' . htmlspecialchars($label) . '</strong></center></td>';
                }
                $missing = $perRow - count($chunk);
                for ($i = 0; $i < $missing; $i++) {
                    echo '<td colspan="1"><center> </center></td>';
                }
                echo '</tr>';

                // Values row
                echo '<tr>';
                foreach ($chunk as $genKey) {
                    $val = isset($generatorData[$genKey]) ? $generatorData[$genKey] : '';
                    $show = ($val !== null && $val !== '') ? $val : ' ';
                    echo '<td colspan="1"><center>' . htmlspecialchars($show) . '</center></td>';
                }
                for ($i = 0; $i < $missing; $i++) {
                    echo '<td colspan="1"><center> </center></td>';
                }
                echo '</tr>';
            }
        }
        ?>
        
    </table>
</body>
</html>