<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$formTemplateJson = dailyReportJson();
$formTemplate = json_decode($formTemplateJson,true);
$ionAuth    = new \App\Libraries\IonAuth();

if ($ionAuth->isAdmin()) {
    $isAdmin =  true;
} else {
    $isAdmin = false;
}

// printArray($isAdmin,1);
// Handle existing water meter data
if (isset($existing_data)) {
    // printArray($existing_data,1);
    $maxMeterNumber = 1;
    
    // Find the highest meter number in existing data
    foreach ($existing_data as $key => $value) {
        if (strpos($key, 'water_meter_reading_meter_') === 0) { 
            $meterNum = (int)str_replace('water_meter_reading_meter_', '', $key);
            if ($meterNum > $maxMeterNumber) {
                $maxMeterNumber = $meterNum;
            }
        }
    }
    
    // Ensure we have at least 1 meter
    if ($maxMeterNumber < 1) {
        $maxMeterNumber = 1;
    }
    
    // Add meters to form template based on existing data
    $formTemplate['water_meter_reading'] = [];
    for ($i = 1; $i <= $maxMeterNumber; $i++) {
        $formTemplate['water_meter_reading']["meter_$i"] = "";
    }
}

// Function to recursively extract all input fields from the data structure
function extractInputFields($data, $currentPath = '', $parentTitles = [], $currentSection = '') {
    $fields = [];
    
    foreach ($data as $key => $value) {
        $newPath = $currentPath ? $currentPath . '_' . $key : $key;
        
        if ($currentPath === '') {
            $currentSection = formatFieldName($key);
        }
        
        $newTitles = $parentTitles;
        
        if (is_array($value)) {
            if (!isset($value['M']) && !isset($value['S'])) {
                $newTitles[] = formatFieldName($key);
            }
            $nestedFields = extractInputFields($value, $newPath, $newTitles, $currentSection);
            $fields = array_merge($fields, $nestedFields);
        } 
        else if ($value === '') {
            $fieldName = $newPath;
            
            // Create clean label without section name repetition
            if (count($parentTitles) > 1) {
                // For deeply nested fields like M/S under required/available
                $subParent = end($parentTitles);
                $fieldLabel = $subParent . ' (' . $key . ')';
            } else if (count($parentTitles) === 1) {
                // For fields with one level of nesting - use only the immediate parent
                $fieldLabel = formatFieldName($key);
            } else {
                // For top-level fields
                $fieldLabel = formatFieldName($key);
            }
            
            $fields[] = [
                'name' => $fieldName,
                'label' => $fieldLabel,
                'placeholder' => 'Enter ' . ($key === 'M' || $key === 'S' ? $key : formatFieldName($key)),
                'section' => $currentSection
            ];
        }
    }
    
    return $fields;
}

function formatFieldName($fieldName) {
    return ucwords(str_replace('_', ' ', $fieldName));
}

function groupFieldsBySection($fields) {
    $grouped = [];
    foreach ($fields as $field) {
        $section = $field['section'];
        if (!isset($grouped[$section])) {
            $grouped[$section] = [];
        }
        $grouped[$section][] = $field;
    }
    return $grouped;
}

// Function to extract time fields from daily work data
function getTimeFields($workKey, $existingData) {
    $timeFields = [];
    
    // Extract all time fields for this work item
    foreach ($existingData as $key => $value) {
        if (strpos($key, "daily_work_{$workKey}_time") === 0) {
            // Extract time number from field name
            preg_match('/time(\d+)/', $key, $matches);
            if (isset($matches[1])) {
                $timeFields[$matches[1]] = $value;
            }
        }
    }
    
    // If no existing data, use default from JSON structure
    if (empty($timeFields)) {
        if ($workKey === 'society_rounds' || $workKey === 'generator_usage') {
            $timeFields = ['1' => '', '2' => '', '3' => '', '4' => ''];
        }
    }
    
    // Sort by time number
    ksort($timeFields, SORT_NUMERIC);
    
    return $timeFields;
}

// Function to check if a work item has time fields
function hasTimeFields($workKey, $workItem) {
    // These are the work items that should have dynamic time fields
    $timeBasedItems = ['society_rounds', 'generator_usage'];
    return in_array($workKey, $timeBasedItems);
}

// Function to detect column labels from service provider data
function getServiceProviderColumns($providerData) {
    $columns = [];
    
    if (isset($providerData['required']) && is_array($providerData['required'])) {
        $columns = array_keys($providerData['required']);
    }
    
    return $columns;
}

// Function to check if service provider has complex structure
function hasComplexStructure($providerData) {
    return isset($providerData['required']) && is_array($providerData['required']);
}

$allFields = extractInputFields($formTemplate);
$groupedFields = groupFieldsBySection($allFields);
$existingData = isset($existing_data) ? $existing_data : [];

// Count initial water meters for JavaScript
$initialMeterCount = isset($formTemplate['water_meter_reading']) ? count($formTemplate['water_meter_reading']) : 1;

// Generate table data from JSON structure
// Service Providers from JSON
$serviceProvidersData = $formTemplate['service_providers'];

// Daily Work from JSON  
$dailyWorkData = $formTemplate['daily_work'];

// Periodical Works from JSON
$periodicalWorksData = $formTemplate['periodical_works'];
?>

<style>
    .tab-content {
        padding: 0.1rem;
    }
</style>

<style>
    .bottom-line-input {
        border: none !important;
        border-bottom: 1px solid #ddd !important;
        border-radius: 0 !important;
        padding-left: 0 !important;
        padding-right: 0 !important;
        background: transparent !important;
        box-shadow: none !important;
        font-size: 0.8rem !important;
        height: 24px !important;
    }

    .bottom-line-input:focus {
        border-bottom-color: #7367f0 !important;
        box-shadow: none !important;
        background: transparent !important;
    }

    .bottom-line-input.error {
        border-bottom-color: #ea5455 !important;
    }

    /* For date input */
    input[type="date"].bottom-line-input {
        padding-right: 0.5rem !important;
    }

    /* Smaller card styling */
    .card-xs {
        min-height: 60px;
    }

    .card-xs .card-body {
        min-height: inherit;
    }

    /* Text truncation */
    .text-truncate {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        max-width: 100%;
    }

    /* Smaller grid gutters */
    .g-1 {
        --bs-gutter-x: 0.25rem;
        --bs-gutter-y: 0.25rem;
    }

    /* Remove button positioning */
    .remove-meter {
        z-index: 1;
    }

    /* Minimum meter warning */
    .min-meter-warning {
        border: 1px solid #ffa500 !important;
        background-color: #fffaf0 !important;
    }

    /* Table styling */
    .table-sm th, .table-sm td {
        padding: 0.25rem;
        font-size: 0.8rem;
    }

    .table-hover tbody tr:hover {
        background-color: rgba(115, 103, 240, 0.04);
    }

    .table th {
        font-weight: 600;
        background-color: #f8f9fa;
    }

    /* Center align table headers and content */
    .table th.text-center, .table td.text-center {
        text-align: center;
        vertical-align: middle;
    }

    /* Table input styling */
    .table .form-control-sm {
        font-size: 0.75rem;
        height: 24px;
        text-align: center;
    }

    /* Service providers table specific */
    #tab-service-providers .table,
    #tab-daily-work .table,
    #tab-periodical-works .table {
        margin-bottom: 0;
    }

    #tab-service-providers .table td:first-child,
    #tab-daily-work .table td:first-child,
    #tab-periodical-works .table td:first-child {
        font-weight: 600;
        background-color: #f8f9fa;
    }

    /* Daily work inner grid */
    .daily-work-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 0.25rem;
    }

    .x-small {
        font-size: 0.7rem !important;
    }

    /* Column width adjustments */
    #tab-daily-work .table td:first-child {
        width: 25%;
    }

    #tab-periodical-works .table td:first-child {
        width: 40%;
    }

    #tab-periodical-works .table td:nth-child(2),
    #tab-periodical-works .table td:nth-child(3) {
        width: 30%;
    }

    /* Time field styling */
    .time-field-group {
        margin-bottom: 0.5rem;
    }

    .time-field-group .d-flex {
        min-height: 50px;
    }

    .time-field-group .form-control {
        margin-bottom: 0;
    }

    /* Remove button styling */
    .remove-time {
        flex-shrink: 0;
        margin-top: 1.2rem;
    }

    /* Ensure proper spacing in time fields container */
    #tab-daily-work .row.g-1.m-0 {
        align-items: flex-start;
    }

    /* Card header styling for report date */
    .card-header .form-control-sm {
        height: 28px;
        font-size: 0.8rem;
    }
</style>

<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between py-2">
                <?php
                // printArray($daily_report_data,1);
                $form_id = array('id' => 'form_daily_report');
                echo form_open_multipart('', $form_id);
                
                $reportId = (isset($daily_report_data['id']) && ($daily_report_data['id'] != '')) ? $daily_report_data['id'] : '';
                ?>
                <h5 class="mb-0"><?= lang('DailyReport.daily_report') ?></h5>
                <div class="d-flex align-items-center">
                    <label class="form-label small fw-bold mb-0 me-2" for="report_date"><?= lang('DailyReport.report_date') ?><span class="text-danger"> *</span></label>
                    <input type="text" class="form-control form-control-sm bottom-line-input" name="report_date" id="report_date" 
                            style="width: 120px;"
                            value="<?= (isset($daily_report_data['report_date']) && isValidDate($daily_report_data['report_date'])) ? siteDateFormat($daily_report_data['report_date']) : date('d-m-Y'); ?>" />
                </div>
            </div>
            <div class="card-body p-4 pt-1">
                
                <input type="hidden" id="id" name="id" value="<?= $reportId ?>">
                
                <!-- Tabular Structure with Tabs -->
                <div class="row">
                    <div class="col-12">
                        <!-- Section Tabs -->
                        <ul class="nav nav-tabs mb-2" role="tablist">
                            <?php $first = true; ?>
                            <?php foreach ($groupedFields as $sectionName => $sectionFields): ?>
                                <?php if (!in_array($sectionName, ['Service Providers', 'Daily Work', 'Periodical Works'])): ?>
                                <li class="nav-item">
                                    <a class="nav-link <?= $first ? 'active' : '' ?> py-1 px-2" 
                                       data-bs-toggle="tab" 
                                       href="#tab-<?= str_replace(' ', '-', strtolower($sectionName)) ?>">
                                        <?= $sectionName ?>
                                    </a>
                                </li>
                                <?php $first = false; ?>
                                <?php endif; ?>
                            <?php endforeach; ?>
                            <!-- Custom Tabs -->
                            <li class="nav-item">
                                <a class="nav-link py-1 px-2" data-bs-toggle="tab" href="#tab-daily-work">
                                    Daily Work
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link py-1 px-2" data-bs-toggle="tab" href="#tab-periodical-works">
                                    Periodical Works
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link py-1 px-2" data-bs-toggle="tab" href="#tab-service-providers">
                                    Service Providers
                                </a>
                            </li>
                        </ul>

                        <!-- Tab Content -->
                        <div class="tab-content">
                            <?php $first = true; ?>
                            <?php foreach ($groupedFields as $sectionName => $sectionFields): ?>
                                <?php if (!in_array($sectionName, ['Service Providers', 'Daily Work', 'Periodical Works'])): ?>
                                <div class="tab-pane <?= $first ? 'show active' : '' ?>" 
                                     id="tab-<?= str_replace(' ', '-', strtolower($sectionName)) ?>">
                                    
                                    <!-- Small Cards Layout -->
                                    <div class="row g-1" <?= $sectionName == 'Water Meter Reading' ? 'id="water-meter-fields"' : '' ?>>
                                        <?php foreach ($sectionFields as $field): ?>
                                            <?php $fieldValue = isset($existingData[$field['name']]) ? $existingData[$field['name']] : ''; ?>
                                            <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 <?= $sectionName == 'Water Meter Reading' ? 'water-meter-field' : '' ?>">
                                                <div class="card card-xs h-100 mb-0 border card-border-shadow-primary">
                                                    <div class="card-body p-1 <?= $sectionName == 'Water Meter Reading' ? 'position-relative' : '' ?>">
                                                        <?php if ($sectionName == 'Water Meter Reading'): ?>
                                                            <button type="button" class="btn btn-xs btn-danger remove-meter position-absolute top-0 end-0 p-0" 
                                                                    style="width: 16px; height: 16px; font-size: 10px; line-height: 1;">
                                                                ×
                                                            </button>
                                                        <?php endif; ?>
                                                        <label class="form-label small fw-bold mb-0 d-block text-truncate" 
                                                               for="<?= $field['name'] ?>"
                                                               data-bs-toggle="tooltip" 
                                                               data-bs-placement="top"
                                                               title="<?= htmlspecialchars($field['label']) ?>">
                                                            <?= $field['label'] ?>
                                                        </label>
                                                        <input type="text" 
                                                               class="form-control bottom-line-input" 
                                                               name="<?= $field['name'] ?>" 
                                                               id="<?= $field['name'] ?>" 
                                                               placeholder="<?= $field['placeholder'] ?>" 
                                                               value="<?= $fieldValue ?>" />
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                    
                                    <!-- Add More Button (only for water meter reading section) -->
                                    <?php if ($sectionName == 'Water Meter Reading'): ?>
                                    <div class="row mt-2">
                                        <div class="col-12">
                                            <button type="button" id="add-more-meter" class="btn btn-sm btn-primary">
                                                <i class="fas fa-plus me-1"></i> Add More Meters
                                            </button>
                                            <small class="text-muted ms-2">Minimum 1 meter required</small>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <?php $first = false; ?>
                                <?php endif; ?>
                            <?php endforeach; ?>
                            
                            <!-- Daily Work Tab -->
                            <div class="tab-pane" id="tab-daily-work">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-sm table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th class="text-center">DAILY WORK</th>
                                                <th class="text-center" colspan="4">STATUS</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($dailyWorkData as $workKey => $workItem): ?>
                                                <?php 
                                                $hasTime = hasTimeFields($workKey, $workItem);
                                                $timeFields = $hasTime ? getTimeFields($workKey, $existingData) : [];
                                                ?>
                                                <tr>
                                                    <td class="fw-bold small" style="width: 25%;"><?= formatFieldName($workKey) ?></td>
                                                    <td class="p-1" colspan="4">
                                                        <?php if ($hasTime && count($timeFields) > 0): ?>
                                                            <!-- Dynamic Time Fields with Add More -->
                                                            <div class="row g-1 m-0" id="time-fields-<?= $workKey ?>">
                                                                <?php foreach ($timeFields as $timeNumber => $timeValue): ?>
                                                                    <div class="col time-field-group">
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="flex-grow-1">
                                                                                <label class="form-label x-small fw-bold mb-0 text-center d-block">Time <?= $timeNumber ?></label>
                                                                                <input type="text" 
                                                                                       class="form-control form-control-sm text-center bottom-line-input" 
                                                                                       name="daily_work_<?= $workKey ?>_time<?= $timeNumber ?>" 
                                                                                       value="<?= $timeValue ?>" 
                                                                                       placeholder="Time <?= $timeNumber ?>" />
                                                                            </div>
                                                                            <?php if ($timeNumber > 1): ?>
                                                                                <button type="button" 
                                                                                        class="btn btn-xs btn-danger remove-time ms-1" 
                                                                                        data-work-key="<?= $workKey ?>"
                                                                                        style="width: 20px; height: 20px; font-size: 10px; line-height: 1;">
                                                                                    ×
                                                                                </button>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                <?php endforeach; ?>
                                                            </div>
                                                            <div class="mt-1">
                                                                <button type="button" 
                                                                        class="btn btn-sm btn-primary add-time" 
                                                                        data-work-key="<?= $workKey ?>">
                                                                    <i class="fas fa-plus me-1"></i> Add Time
                                                                </button>
                                                            </div>
                                                        <?php elseif (is_array($workItem)): ?>
                                                            <!-- Fixed Fields (non-time based) -->
                                                            <div class="row g-1 m-0">
                                                                <?php foreach ($workItem as $columnKey => $columnValue): ?>
                                                                    <?php
                                                                    $fieldName = "daily_work_{$workKey}_{$columnKey}";
                                                                    $fieldValue = isset($existingData[$fieldName]) ? $existingData[$fieldName] : '';
                                                                    $columnLabel = formatFieldName($columnKey);
                                                                    ?>
                                                                    <div class="col">
                                                                        <label class="form-label x-small fw-bold mb-0 text-center d-block"><?= $columnLabel ?></label>
                                                                        <input type="text"
                                                                               class="form-control form-control-sm text-center bottom-line-input"
                                                                               name="<?= $fieldName ?>"
                                                                               value="<?= $fieldValue ?>"
                                                                               placeholder="<?= $columnLabel ?>" />
                                                                    </div>
                                                                <?php endforeach; ?>
                                                            </div>
                                                        <?php else: ?>
                                                            <!-- Simple single field (like "others") -->
                                                            <?php
                                                            $fieldName = "daily_work_{$workKey}";
                                                            $fieldValue = isset($existingData[$fieldName]) ? $existingData[$fieldName] : '';
                                                            ?>
                                                            <div class="row g-1 m-0">
                                                                <div class="col">
                                                                    <input type="text"
                                                                           class="form-control form-control-sm bottom-line-input"
                                                                           name="<?= $fieldName ?>"
                                                                           value="<?= $fieldValue ?>"
                                                                           placeholder="Enter <?= formatFieldName($workKey) ?>" />
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            
                            <!-- Periodical Works Tab -->
                            <div class="tab-pane" id="tab-periodical-works">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-sm table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th class="text-center">PERIODICAL WORKS</th>
                                                <th class="text-center">SCHEDULED</th>
                                                <th class="text-center">DETAILS</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($periodicalWorksData as $workKey => $workItem): ?>
                                                <?php 
                                                $scheduledField = "periodical_works_{$workKey}_scheduled";
                                                $detailsField = "periodical_works_{$workKey}_details";
                                                $scheduledValue = isset($existingData[$scheduledField]) ? $existingData[$scheduledField] : '';
                                                $detailsValue = isset($existingData[$detailsField]) ? $existingData[$detailsField] : '';
                                                ?>
                                                <tr>
                                                    <td class="fw-bold small" style="width: 40%;"><?= formatFieldName($workKey) ?></td>
                                                    <td class="p-1" style="width: 30%;">
                                                        <input type="text" 
                                                               class="form-control form-control-sm text-center bottom-line-input" 
                                                               name="<?= $scheduledField ?>" 
                                                               value="<?= $scheduledValue ?>" 
                                                               placeholder="Scheduled" />
                                                    </td>
                                                    <td class="p-1" style="width: 30%;">
                                                        <input type="text" 
                                                               class="form-control form-control-sm text-center bottom-line-input" 
                                                               name="<?= $detailsField ?>" 
                                                               value="<?= $detailsValue ?>" 
                                                               placeholder="Details" />
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            
                            <!-- Service Providers Tab -->
                            <div class="tab-pane" id="tab-service-providers">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-sm table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th class="text-center">SERVICE PROVIDERS</th>
                                                <th class="text-center" colspan="2">REQUIRED</th>
                                                <th class="text-center" colspan="2">AVAILABLE</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($serviceProvidersData as $providerKey => $providerData): ?>
                                                <?php 
                                                $hasComplex = hasComplexStructure($providerData);
                                                $columns = $hasComplex ? getServiceProviderColumns($providerData) : [];
                                                ?>
                                                <tr>
                                                    <td class="fw-bold small"><?= formatFieldName($providerKey) ?></td>
                                                    
                                                    <?php if ($hasComplex && count($columns) > 0): ?>
                                                        <!-- Complex Structure with individual column headers -->
                                                        <?php foreach ($columns as $column): ?>
                                                            <td class="p-1">
                                                                <div class="text-center x-small fw-bold mb-1"><?= serviceProviderArr()[$column] ?></div>
                                                                <input type="text" 
                                                                       class="form-control form-control-sm text-center bottom-line-input" 
                                                                       name="service_providers_<?= $providerKey ?>_required_<?= $column ?>" 
                                                                       value="<?= isset($existingData["service_providers_{$providerKey}_required_{$column}"]) ? $existingData["service_providers_{$providerKey}_required_{$column}"] : '' ?>" 
                                                                       placeholder="<?= $column ?>" />
                                                            </td>
                                                        <?php endforeach; ?>
                                                        <?php foreach ($columns as $column): ?>
                                                            <td class="p-1">
                                                                <div class="text-center x-small fw-bold mb-1"><?= serviceProviderArr()[$column] ?></div>
                                                                <input type="text" 
                                                                       class="form-control form-control-sm text-center bottom-line-input" 
                                                                       name="service_providers_<?= $providerKey ?>_available_<?= $column ?>" 
                                                                       value="<?= isset($existingData["service_providers_{$providerKey}_available_{$column}"]) ? $existingData["service_providers_{$providerKey}_available_{$column}"] : '' ?>" 
                                                                       placeholder="<?= $column ?>" />
                                                            </td>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <!-- Simple Structure -->
                                                        <td class="p-1" colspan="2">
                                                            <div class="text-center x-small fw-bold mb-1">REQUIRED</div>
                                                            <input type="text" 
                                                                   class="form-control form-control-sm text-center bottom-line-input" 
                                                                   name="service_providers_<?= $providerKey ?>_required" 
                                                                   value="<?= isset($existingData["service_providers_{$providerKey}_required"]) ? $existingData["service_providers_{$providerKey}_required"] : '' ?>" 
                                                                   placeholder="Required" />
                                                        </td>
                                                        <td class="p-1" colspan="2">
                                                            <div class="text-center x-small fw-bold mb-1">AVAILABLE</div>
                                                            <input type="text" 
                                                                   class="form-control form-control-sm text-center bottom-line-input" 
                                                                   name="service_providers_<?= $providerKey ?>_available" 
                                                                   value="<?= isset($existingData["service_providers_{$providerKey}_available"]) ? $existingData["service_providers_{$providerKey}_available"] : '' ?>" 
                                                                   placeholder="Available" />
                                                        </td>
                                                    <?php endif; ?>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Compact Buttons -->
                <div class="pt-3 mt-2 border-top">
                    <button type="submit" id="submitBtn" class="btn btn-primary btn-sm me-2 submit">Submit</button>
                    <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('DailyReport'); ?>'" class="btn btn-label-secondary btn-sm">Cancel</button>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    let meterCounter = <?= $initialMeterCount ?>;
    
    // Update meter counter based on existing fields
    function updateMeterCounter() {
        const currentMeters = $('.water-meter-field').length;
        // Find the highest meter number
        let maxMeter = 0;
        $('.water-meter-field').each(function() {
            const fieldName = $(this).find('input').attr('name');
            const meterNum = parseInt(fieldName.split('_').pop());
            if (meterNum > maxMeter) {
                maxMeter = meterNum;
            }
        });
        meterCounter = maxMeter;
    }
    
    // Check and update minimum meter requirement
    function checkMinimumMeters() {
        const meterCount = $('.water-meter-field').length;
        if (meterCount <= 1) {
            $('#water-meter-fields').addClass('min-meter-warning');
            $('.remove-meter').prop('disabled', true).addClass('disabled');
        } else {
            $('#water-meter-fields').removeClass('min-meter-warning');
            $('.remove-meter').prop('disabled', false).removeClass('disabled');
        }
        return meterCount;
    }
    
    // Add more meter functionality
    $('#add-more-meter').click(function() {
        meterCounter++;
        
        const newFieldHtml = `
            <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 water-meter-field">
                <div class="card card-xs h-100 mb-0 border card-border-shadow-primary">
                    <div class="card-body p-1 position-relative">
                        <button type="button" class="btn btn-xs btn-danger remove-meter position-absolute top-0 end-0 p-0" 
                                style="width: 16px; height: 16px; font-size: 10px; line-height: 1;">
                            ×
                        </button>
                        <label class="form-label small fw-bold mb-0 d-block text-truncate" 
                               for="water_meter_reading_meter_${meterCounter}"
                               data-bs-toggle="tooltip" 
                               data-bs-placement="top"
                               title="Meter ${meterCounter}">
                            Meter ${meterCounter}
                        </label>
                        <input type="text" 
                               class="form-control bottom-line-input" 
                               name="water_meter_reading_meter_${meterCounter}" 
                               id="water_meter_reading_meter_${meterCounter}" 
                               placeholder="Enter Meter ${meterCounter}" 
                               value="" />
                    </div>
                </div>
            </div>
        `;
        
        $('#water-meter-fields').append(newFieldHtml);
        
        // Initialize tooltip for the new field
        const newTooltip = new bootstrap.Tooltip(document.querySelector(`[for="water_meter_reading_meter_${meterCounter}"]`));
        
        // Update meter states
        checkMinimumMeters();
    });
    
    // Remove meter functionality (using event delegation for dynamically added elements)
    $(document).on('click', '.remove-meter', function() {
        const meterCount = $('.water-meter-field').length;
        
        // Prevent removing if only one meter remains
        if (meterCount <= 1) {
            toastr.warning('At least one water meter is required', 'Warning', {
                closeButton: true,
                positionClass: 'toast-top-right',
            });
            return;
        }
        
        const field = $(this).closest('.water-meter-field');
        field.remove();
        
        // Update meter counter and check minimum requirement
        updateMeterCounter();
        checkMinimumMeters();
    });

    // Add time field functionality
    $(document).on('click', '.add-time', function() {
        const workKey = $(this).data('work-key');
        const container = $('#time-fields-' + workKey);
        
        // Find the highest time number
        let maxTime = 1;
        container.find('.time-field-group').each(function() {
            const input = $(this).find('input');
            const name = input.attr('name');
            const timeMatch = name.match(/time(\d+)/);
            if (timeMatch && parseInt(timeMatch[1]) > maxTime) {
                maxTime = parseInt(timeMatch[1]);
            }
        });
        
        const nextTime = maxTime + 1;
        
        const newTimeField = `
            <div class="col time-field-group">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <label class="form-label x-small fw-bold mb-0 text-center d-block">Time ${nextTime}</label>
                        <input type="text" 
                               class="form-control form-control-sm text-center bottom-line-input" 
                               name="daily_work_${workKey}_time${nextTime}" 
                               value="" 
                               placeholder="Time ${nextTime}" />
                    </div>
                    <button type="button" 
                            class="btn btn-xs btn-danger remove-time ms-1" 
                            data-work-key="${workKey}"
                            style="width: 20px; height: 20px; font-size: 10px; line-height: 1;">
                        ×
                    </button>
                </div>
            </div>
        `;
        
        container.append(newTimeField);
    });
    
    // Remove time field functionality
    $(document).on('click', '.remove-time', function() {
        const workKey = $(this).data('work-key');
        const container = $('#time-fields-' + workKey);
        const timeFieldCount = container.find('.time-field-group').length;
        
        // Don't allow removing if only one time field remains
        if (timeFieldCount <= 1) {
            toastr.warning('At least one time field is required', 'Warning', {
                closeButton: true,
                positionClass: 'toast-top-right',
            });
            return;
        }
        
        $(this).closest('.time-field-group').remove();
    });

    // Initialize minimum meter check on page load
    checkMinimumMeters();

    // Initialize tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });

    const isAdmin = <?= $isAdmin ? 'true' : 'false' ?>;


        $(function () {
            const reportDateEl = $("#report_date");
            const reportDateVal = $.trim(reportDateEl.val()); // existing value or empty
            const isEmpty = !reportDateVal; // true for add, false for edit

            // Build common options
            const options = {
                dateFormat: "d-m-Y",
                // if there's an existing value use it, otherwise default to today
                defaultDate: isEmpty ? new Date() : reportDateVal
            };

            if (isAdmin) {
                // Admin: full control (calendar opens and typing allowed)
                // nothing else needed — options already contains defaultDate
            } else {
                // Non-admin: cannot change the date
                options.clickOpens = false;   // prevent opening calendar
                options.allowInput = false;   // prevent typing
                // Make input readonly as an extra safeguard
                reportDateEl.prop("readonly", true);
            }

            // Initialize flatpickr (always initialize; behavior depends on options)
            reportDateEl.flatpickr(options);
        });



    // Initialize form validation
    var validator = $("#form_daily_report").validate({
        ignore: 'input[type=hidden], .select2-search__field',
        errorClass: 'validation-invalid-label',
        successClass: 'validation-valid-label',
        validClass: 'validation-valid-label',
        highlight: function(element, errorClass) {
            $(element).removeClass(errorClass);
            $(element).addClass('error');
            $(element).closest('.card').addClass('border-danger');
            $(element).closest('.card').removeClass('card-border-shadow-primary');
        },
        unhighlight: function(element, errorClass) {
            $(element).removeClass(errorClass);
            $(element).removeClass('error');
            $(element).closest('.card').removeClass('border-danger');
            $(element).closest('.card').addClass('card-border-shadow-primary');
        },
        success: function(label) {
            // label.addClass('validation-valid-label').text('Success.');
        },
        errorPlacement: function(error, element) {
            error.appendTo(element.closest('.card-body'));
        },
        rules: {
            report_date: {
                required: true,
            }
        },
        messages: {
            report_date: {
                required: 'Please select report date',
            }
        },
        submitHandler: function (form) {
            // Validate minimum water meters
            const meterCount = $('.water-meter-field').length;
            if (meterCount < 1) {
                toastr.error('At least one water meter reading is required', 'Error', {
                    closeButton: true,
                    positionClass: 'toast-top-right',
                });
                return false;
            }

            // Manually collect all form data including dynamic fields
            const formData = new FormData(form);
            
            // Add dynamic water meter fields
            $('.water-meter-field input').each(function() {
                const name = $(this).attr('name');
                const value = $(this).val();
                // console.log("water-meter-field");
                
                if (name && !formData.has(name)) {
                    formData.append(name, value);
                }
            });
            
            // Add dynamic time fields for society_rounds and generator_usage
            $('input[name^="daily_work_society_rounds_time"]').each(function() {
                const name = $(this).attr('name');
                const value = $(this).val();
                // console.log("daily_work_society_rounds_time");
                
                if (name && !formData.has(name)) {
                    formData.append(name, value);
                }
            });
            
            $('input[name^="daily_work_generator_usage_time"]').each(function() {
                const name = $(this).attr('name');
                const value = $(this).val();
                // console.log("daily_work_society_rounds_time");
                if (name && !formData.has(name)) {
                    formData.append(name, value);
                }
            });

            // Show loading state
            dtButtonHide('#submitBtn');
            dtButtonHide('#cancelBtn');

            // Use AJAX to submit the form
            $.ajax({
                url: '<?php echo admin_url("DailyReport/save");?>',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function (resObj, statusText) {
                    if (resObj.success) {
                        toastr.success(resObj.msg, 'Success', {
                            closeButton: true,
                            progressBar: true,
                            positionClass: 'toast-top-right',
                            timeOut: 1000,
                            onHidden: function () {
                                dtButtonShow('#submitBtn');
                                dtButtonShow('#cancelBtn');
                                window.location.href = '<?php echo admin_url('DailyReport');?>';
                            }
                        });
                    } else {
                        dtButtonShow('#submitBtn');
                        dtButtonShow('#cancelBtn');
                        toastr.error(resObj.msg, 'Error', {
                            closeButton: true,
                            positionClass: 'toast-top-right',
                        });
                    }
                },
                error: function(xhr, status, error) {
                    dtButtonShow('#submitBtn');
                    dtButtonShow('#cancelBtn');
                    toastr.error('An error occurred while submitting the form.', 'Error', {
                        closeButton: true,
                        positionClass: 'toast-top-right',
                    });
                }
            });
        }
    });

    // Add focus effect for active cards
    $(document).on('focus', '.bottom-line-input', function() {
        $(this).closest('.card').addClass('card-border-shadow-primary');
    });
    
    $(document).on('blur', '.bottom-line-input', function() {
        // Only remove if not in error state
        if (!$(this).hasClass('error')) {
            $(this).closest('.card').removeClass('card-border-shadow-primary');
        }
    });

    // Initialize switchery
    switcheryKeyGen("form-add-switchery");
});
</script>