<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#complain_detail" aria-controls="complain_detail" aria-selected="true">
			<?= lang('Complain.complain_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#complain_status_detail" aria-controls="complain_status_detail" aria-selected="true">
			<?= lang('Complain.complain_status_detail'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="complain_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="complain_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Complain.complain_number"); ?></td>
						<td><?php
							echo (isset($complain_data['complain_number']) && $complain_data['complain_number'] != "") ? ($complain_data['complain_number']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Complain.flat_id"); ?></td>
						<td><?php
							echo (isset($complain_data['tower_flat_name']) && $complain_data['tower_flat_name'] != "") ? $complain_data['tower_flat_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Complain.complain_title"); ?></td>
						<td><?php
							echo (isset($complain_data['complain_title']) && $complain_data['complain_title'] != "") ? underscoreToUcWord($complain_data['complain_title']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Complain.description"); ?></td>
						<td><?php
							echo (isset($complain_data['description']) && $complain_data['description'] != "") ? ($complain_data['description']) : '-';
							?></td>
					</tr>
					
					<tr>
						<td><?= lang("Complain.complain_image"); ?></td>
						<td>
							<?php 
		                    if(isset($image_data) && is_array($image_data) && !empty($image_data)){
		                        foreach($image_data as $image) { 
		                        	if(file_exists(COMPLAIN_IMAGE_PATH . $image['complain_image'])){
				                        $paths = site_url() . COMPLAIN_IMAGE_PATH . $image['complain_image']; ?> 
				                 		<span class="document-image-<?= $image['complain_image_id']; ?>">
				                 			<a href="<?= $paths; ?>" target="_blank"> <img src="<?= $paths; ?>" width="100" class="img-fluid" alt=""> </a>
				        				</span>
		            		<?php }} } ?>
						</td>
					</tr>
					
					
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($complain_data['created_at']) && isValidDate($complain_data['created_at'])) ? siteDateFormat($complain_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($complain_data['created_by']) && $complain_data['created_by'] != "") ? $complain_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($complain_data['updated_at']) && isValidDate($complain_data['updated_at'])) ? siteDateFormat($complain_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($complain_data['updated_by']) && $complain_data['updated_by'] != "") ? $complain_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	
	<div class="tab-pane fade" id="complain_status_detail" role="tabpanel">
	<?php if(!empty($complain_history_data) && array_filter($complain_history_data)) { ?>
					<div class="row mb-3">
						<table class="table table-bordered">
							<thead>
								<tr>
									<th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
									<th style="width: 10%"><?= lang("Complain.status"); ?></th>
									<th style="width: 10%"><?= lang("Complain.remarks"); ?></th>
									<th style="width: 10%"><?= lang("Complain.complain_image"); ?></th>
								</tr>
							</thead>
							<tbody class="">
			                	<?php 
			                    $sr = 1;
			                    foreach ($complain_history_data as $key => $value) { ?>
									<tr>
										<td class="text-center"><?= $sr; ?></td>
			                            <td colspan="1"><?= ($value['status_name']); ?> </td>
			                            <td colspan="1"><?= ($value['remarks']); ?> </td>
			                            <td colspan="1">
										<?php if (isset($value['image_data']) && $value['image_data'] != '' ) {?>
											<?php
											foreach($value['image_data'] as $document){
											$paths = site_url() . COMPLAIN_IMAGE_PATH . $document['complain_image'];
												if(file_exists( COMPLAIN_IMAGE_PATH .$document['complain_image'])){ ?>
												<a href="<?= $paths; ?>"  target="_blank">
													<img src="<?= $paths; ?>" width="100" height="100" class="img-fluid" alt="">
												</a>
												<?php }?>
											<?php }  ?>
										<?php } ?> 
										</td>
									</tr>
			                    <?php $sr++;} ?>
							</tbody>
						</table>
					</div>
				<?php } ?>
</div>
</div>