<?php
$complainView = isset($rentals_data['view']) ? $rentals_data['view'] : 0;
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$session = \Config\Services::session();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Complain.complain_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_complain',
				);
				echo form_open_multipart('',$form_id);
				$complainId = (isset($complain_data['complain_id']) && ($complain_data['complain_id'] != '')) ? $complain_data['complain_id'] : '';
				$series = (isset($complain_data['series']) && ($complain_data['series'] != '')) ? $complain_data['series'] : '';
				?>
				<input type="hidden" id="complain_id" name="complain_id" value="<?= $complainId ?>">
				<input type="hidden" id="series" name="series" class="series" value="<?= $series ?>">
				<input type="hidden" id="category_for" name="category_for" value="complain">


					<div class="row mb-3">
		               <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.complain_code'); ?><span class="text-danger"> *</span></label>
		                <div class="col-sm-10">
		                    <input type="text" name="complain_code" id="complain_code" class="form-control complain_code" value="<?= isset($complain_data['prefix']) ? $complain_data['prefix'].$complain_data['series'] : "";?>" placeholder="Enter <?= lang('Complain.complain_code'); ?>"  readonly>
		                </div>
		            </div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.complain_type');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<?php
								$complainTypes = complainType();
							?>
							<select data-placeholder="Select  <?= lang('Complain.complain_type'); ?>" name="complain_type"
								id="complain_type" class="select2 form-select dt-complain-type">
								<option value=""> </option>
								<?php
								$selectedComplainType = isset($complain_data['complain_type']) ? $complain_data['complain_type'] : "";
								foreach ($complainTypes as $complainKey => $complain) { ?>
									<option <?= ($selectedComplainType == $complainKey) ? "selected" : ""; ?>
										value="<?= $complainKey; ?>"> <?= $complain; ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.complainant');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<?php
								$complainantTypes = complainantType();
							?>
							<select data-placeholder="Select  <?= lang('Complain.complainant'); ?>" name="complainant"
								id="complainant" class="select2 form-select dt-complain-for">
								<option value=""> </option>
								<?php
								$selectedComplainantType = isset($complain_data['complainant']) ? $complain_data['complainant'] : "";
								foreach ($complainantTypes as $complainantKey => $complainant) { ?>
									<option <?= ($selectedComplainantType == $complainantKey) ? "selected" : ""; ?>
										value="<?= $complainantKey; ?>"> <?= $complainant; ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3 dt-manager">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.manager');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="user_id" name="user_id" class="select2 form-select form-select-lg userDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($complain_data['complainant_id']) && $complain_data['complainant_id'] != 0){ ?>
								<option value="<?= isset($complain_data['complainant_id']) ? $complain_data['complainant_id'] : 0 ?>" selected> <?= isset($complain_data['complainant_name']) ? $complain_data['complainant_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3 dt-owner-flat-member">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.owner_flat');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="owner_flat_id" name="owner_flat_id" class="select2 form-select form-select-lg flatMemberDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($complain_data['complainant_id']) && $complain_data['complainant_id'] != 0){ ?>
								<option value="<?= isset($complain_data['complainant_id']) ? $complain_data['complainant_id'] : 0 ?>" selected> <?= isset($complain_data['complainant_name']) ? $complain_data['complainant_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.category');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
						<select id="category_id" name="category_id" class="select2 form-select form-select-lg categoryDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($complain_data['category_id']) && $complain_data['category_id'] != 0){ ?>
								<option value="<?= isset($complain_data['category_id']) ? $complain_data['category_id'] : 0 ?>" selected> <?= isset($complain_data['category_name']) ? $complain_data['category_name'] : ''  ?> </option>
								<?php } ?>
						</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.complain_title');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="complain_title" id="complain_title" placeholder="Enter <?= lang('Complain.complain_title');?>" value="<?= (isset($complain_data['complain_title']) && ($complain_data['complain_title'] != '')) ? $complain_data['complain_title'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.due_date');?><span class="text-danger"> </span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="due_date" id="due_date" placeholder="Select <?= lang('Complain.due_date'); ?>" value="<?= (isset($complain_data['due_date']) && isValidDate($complain_data['due_date'])) ? siteDateFormat($complain_data['due_date'], true) : ''; ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.tower');?></label>
						<div class="col-sm-10">
							<select id="tower_id" name="tower_id" class="select2 form-select form-select-lg towerDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($complain_data['tower_id']) && $complain_data['tower_id'] != 0){ ?>
								<option value="<?= isset($complain_data['tower_id']) ? $complain_data['tower_id'] : 0 ?>" selected> <?= isset($complain_data['tower_name']) ? $complain_data['tower_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.flat');?></label>
						<div class="col-sm-10">
							<select id="flat_id" name="flat_id" class="select2 form-select form-select-lg flatDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($complain_data['flat_id']) && $complain_data['flat_id'] != 0){ ?>
								<option value="<?= isset($complain_data['flat_id']) ? $complain_data['flat_id'] : 0 ?>" selected> <?= isset($complain_data['tower_flat_name']) ? $complain_data['tower_flat_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>
					
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.description');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<textarea name="description"  id="description" placeholder="Enter <?= lang('Complain.description'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($complain_data['description']) && ($complain_data['description'] != '')) ? $complain_data['description'] : ''; ?></textarea>
						</div>
					</div>

					<?php /*?>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Complain.complain_image');?></label>
						<div class="col-sm-10">
							<input type="file" accept="image/*" class="form-control" name="complain_image[]" multiple="multiple">
							<?php 
		                    if(isset($image_data) && is_array($image_data) && !empty($image_data)){
		                        foreach($image_data as $image) { 
		                        	if(file_exists(COMPLAIN_IMAGE_PATH . $image['complain_image'])){
				                        $paths = site_url() . COMPLAIN_IMAGE_PATH . $image['complain_image']; ?>
				                 		<span class="document-image-<?= $image['complain_image_id']; ?>">
											 <a href="<?= $paths; ?>" target="_blank">
												 <img src="<?= $paths; ?>" width="100" class="img-fluid" alt="">
												 <?php if (!empty($complainId) && $dtCIAcl->checkAccess("Complain|complainImageDelete")) { ?>
												  <a href="javascript:void(0);"  id="<?php echo $image['complain_image_id']; ?>" class="btn btn-icon btn-outline-dribbble delete-image"> <i class="tf-icons ti ti-trash"></i></a>
												<?php } ?>
											</a>
										</span>
		            		<?php }} } ?>
						</div>
					</div>
					<?php */?>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang("Complain.this_is_urgent"); ?></label>
						<div class="col-sm-10">
							<input type="checkbox" class="form-check-input" id="is_urgent"
										name="is_urgent" <?= isset($complain_data['is_urgent']) && $complain_data['is_urgent'] == 1 ? "checked" : '' ?>
										value="1">			
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($complain_data['is_active']) || $complain_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>
					

					<hr class="my-4 mx-n4" />
					<h6><?= lang('Media.media_information'); ?></h6>
					<div class="row g-3">
						<?= isset($media_table) ? $media_table : ""; ?>
					</div>
					<?php if ($dtCIAcl->checkAccess('Notice|manage')) { ?>
						<button type="button" class="btn btn-sm btn-primary" onclick="addMediaItem()" data-bs-popup='tooltip' title="<?= lang('CommonMessage.common_add_media') ?>">
							<i class="ti ti-plus me-1"></i>
							<span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
						</button>
					<?php } ?>

					<?php if($complainView != 1) { ?>
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Complain'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
					<?php } ?>
				<?php echo form_close(); ?>
				<?php if(!empty($complain_history_data) && array_filter($complain_history_data)) { ?>
					<hr class="my-4 mx-n4" />
					<h6><?= lang('Complain.complain_history'); ?></h6>
					<div class="row mb-3">
						<table class="table table-bordered">
							<thead>
								<tr>
									<th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
									<th style="width: 10%"><?= lang("Complain.status"); ?></th>
									<th style="width: 10%"><?= lang("Complain.remarks"); ?></th>
									<th style="width: 10%"><?= lang("Complain.complain_image"); ?></th>
								</tr>
							</thead>
							<tbody class="">
			                	<?php 
			                    $sr = 1;
			                    foreach ($complain_history_data as $key => $value) { ?>
									<tr>
										<td class="text-center"><?= $sr; ?></td>
			                            <td colspan="1"><?= ($value['status_name']); ?> </td>
			                            <td colspan="1"><?= ($value['remarks']); ?> </td>
			                            <td colspan="1">
										<?php if (isset($value['complain_history_image_data']) && $value['complain_history_image_data'] != '' ) {?>
											<?php
											foreach($value['complain_history_image_data'] as $document){
											$paths = site_url() . MEDIA_IMAGE_PATH . $document['complain_image'];
												if(file_exists( MEDIA_IMAGE_PATH .$document['complain_image'])){ ?>
												<a href="<?= $paths; ?>"  target="_blank">
													<img src="<?= $paths; ?>" width="100" height="100" class="img-fluid" alt="">
												</a>
												<?php }?>
											<?php }  ?>
										<?php } ?> 
										</td>
									</tr>
			                    <?php $sr++;} ?>
							</tbody>
						</table>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
</div>

<script>
	var editable = <?= $complainView ?>;
    if(editable == 1)
    {
        $("#form_complain :input").prop("disabled", true);
        $(".module-delete-image").removeAttr("onclick");
        $(".module-delete-image").removeClass("DeleteItemRow");
        $(".module-delete-image").remove();
    }
    $(document).ready(function() {
    	<?php
        if($complainId == '') { ?>
            getComplainCode();
        <?php } ?>
    	numberInit();
    	flatDd();
		towerDd();
		flatMemberDd();
		userDd();
		$("#due_date").flatpickr({
			enableTime: true,
			dateFormat: "d-m-Y H:i",
		});
		switcheryKeyGen("datatable-list-switchery");
		$('.dt-complain-type').select2();
		$('.dt-complain-type').change();
		$('.dt-complain-for').select2();
		$('.dt-complain-for').change();
		categoryDd();
		addSerialNumber('media_table');
		$('.dt-media-type').select2();
        // Initialize
		var validator = $("#form_complain").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				complain_title: {
					required: true,
				},
				complain_type: {
					required: true,
				},
				complainant: {
					required: true,
				},
				complain_code: {
					required: true,
				},
				description : {
					required : true,
				},
				user_id : {
					required : "#user_id:visible",
				},
				owner_flat_id : {
					required : "#owner_flat_id:visible",
				},
				category_id : {
					required : true,
				},
            },
            messages: {
				complain_title: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Complain.complain_title"); ?>',
				},
				complain_type: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Complain.complain_type"); ?>',
				},
				complainant: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Complain.complainant"); ?>',
				},
				complain_code: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Complain.complain_code"); ?>',
				},
				description : {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Complain.description"); ?>',
				},
				user_id : {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Complain.manager"); ?>',
				},
				owner_flat_id : {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Complain.owner_flat"); ?>',
				},
				category_id : {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Complain.category"); ?>',
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Complain/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Complain');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Complain');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });

    // $(document).on('click', '.delete-image', function () {
    //     var deleteId = $(this).attr("id");
    //     var complainId = $("#complain_id").val();
    //     Swal.fire({
	// 		title: "<?= ucwords(lang('CommonMessage.common_delete')); ?>",
	// 		text: "<?= lang('CommonMessage.delete_warning'); ?>",
	// 		icon: 'warning',
	// 		showCancelButton: true,
	// 		confirmButtonText: 'OK',
	// 		customClass: {
	// 			confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
	// 			cancelButton: 'btn btn-label-secondary waves-effect waves-light'
	// 		},
	// 		buttonsStyling: false
	// 	}).then(function(result) {
	// 		if (result.value) {
	// 			$("span.document-image-"+deleteId).remove();
	// 	        $.ajax({
	// 	            type: "post",
	// 	            url: "<?= admin_url("Complain/deleteComplainImage")?>",
	// 	            dataType: "json",
	// 	            data: {complain_image_id: deleteId,complain_id:complainId},
	// 	            success: function (data) {
	// 	                if (data['success']) {
	// 	                    $(".delete-image").click(function() {
	// 	                        $(this).parent().remove();
	// 	                    }); 
	// 		                Swal.fire({
	// 							title: 'Success',
	// 							text: data['msg'],
	// 							icon: 'success',
	// 							customClass: {
	// 								confirmButton: 'btn btn-primary waves-effect waves-light'
	// 							},
	// 							buttonsStyling: false
	// 						}).then(function() {
	// 							dt_DataTable.ajax.reload();
	// 						});
	// 	                }
	// 	                else{
	// 	                    Swal.fire({
	// 							title: 'Error!',
	// 							text: data['msg'],
	// 							icon: 'error',
	// 							customClass: {
	// 								confirmButton: 'btn btn-primary waves-effect waves-light'
	// 							},
	// 							buttonsStyling: false
	// 						}).then(function() {
	// 							dt_DataTable.ajax.reload();
	// 						});
	// 	                }
	// 	            }
	// 	        });
	// 	    }
	// 	});
    // });

    function getComplainCode() {
    	var societyId = "<?= $session->get('society_id') ?>";
        $.ajax({
            type: "POST",
            url: "<?php echo admin_url('Complain/getComplainCode');?>",
            dataType: "json",
            data: {prefix:"<?= COMPLAIN_PREFIX ?>",society_id: societyId},
            success: function (data) {
                if(data.success){
                    $(".complain_code").val(data.data);
                    $(".series").val(data.series);
                }

            }
        });
    }

	$(document).on('change', '.dt-complain-for', function () {
		var complainType = $(this).val();
		if ((complainType) == 'manager') {
			$(".dt-manager").show();
			$(".dt-owner-flat-member").hide();
			$(".flatMemberDd").val('');
		} else if((complainType) == 'member') {
			$(".dt-owner-flat-member").show();
			$(".dt-manager").hide();
			$(".userDd").val('');
		} else {
			$(".dt-manager").hide();
			$(".dt-owner-flat-member").hide();
		}
	});
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>