<?php if (BULK_UPLOAD_SHOW): ?>
<link rel="stylesheet" href="<?= base_url('assets/vendor/libs/dropzone/dropzone.css'); ?>" />
<script src="<?= base_url('assets/vendor/libs/dropzone/dropzone.min.js'); ?>"></script>

<style>
/* ===== Bulk Upload Modal Styling ===== */
#bulkUploadModal .modal-content {
    border: none;
    border-radius: 1rem;
    background: #fff;
    box-shadow: 0 10px 40px rgba(115,103,240,0.2);
    /* overflow: hidden; */
}

/* Header */
#bulkUploadModal .modal-header {
    /* background: linear-gradient(135deg, #7367f0, #a18cff); */
    color: #fff;
    border-bottom: none;
    align-items: center;
    padding: 1rem 1.25rem;
}

/* Title + icon */
#bulkUploadModal .modal-title {
    font-weight: 600;
    display: flex;
    align-items: center;
    font-size: 1.1rem;
}
#bulkUploadModal .modal-title i {
    font-size: 1.5rem;
    margin-right: 8px;
}

/* Dropzone area */
.dropzone {
    background: rgba(115,103,240,0.05);
    border: 2px dashed #7367f0;
    border-radius: 0.75rem;
    transition: all 0.3s ease;
    text-align: center;
    position: relative;
    overflow: hidden;
}
.dropzone:hover {
    background: rgba(115,103,240,0.08);
    border-color: #5e54d4;
}

/* Dropzone message */
.dropzone .dz-message {
    color: #5e54d4;
    font-weight: 500;
    padding: 2rem 1rem;
}
.dropzone .dz-message i {
    font-size: 3rem;
    color: #7367f0;
    margin-bottom: 0.5rem;
    animation: pulse 2s infinite;
}

/* Pulsing upload icon */
@keyframes pulse {
    0%,100% { transform: scale(1); opacity: 1; }
    50% { transform: scale(1.1); opacity: 0.8; }
}

/* Error alert */
#uploadErrorAlertWrapper {
    border-left: 4px solid #dc3545;
    font-weight: 500;
}

/* Dropdown styling */
#bulkUploadModal .dropdown-toggle {
    background: #fff;
    color: #7367f0;
    border: 1px solid #7367f0;
    font-size: 0.8rem;
    padding: 4px 8px;
    border-radius: 0.4rem;
    transition: all 0.2s ease;
}
#bulkUploadModal .dropdown-toggle:hover {
    background: #7367f0;
    color: #fff;
}
#bulkUploadModal .dropdown-menu a {
    font-size: 0.85rem;
    padding: 6px 12px;
    color: #333;
}
#bulkUploadModal .dropdown-menu a:hover {
    background: rgba(115,103,240,0.1);
    color: #7367f0;
}
</style>

<!-- Modal -->
<div class="modal fade" id="bulkUploadModal" tabindex="-1" aria-labelledby="bulkUploadModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-md">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title" id="bulkUploadModalLabel">
          <i class="bi bi-cloud-upload"></i> Bulk Upload
        </h5>

        <?php if (isset($bulk_upload_sample_download)): ?>
        <div class="dropdown ms-auto me-2">
          <button class="btn btn-sm dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-download"></i> Samples
          </button>
          <ul class="dropdown-menu dropdown-menu-end shadow-sm">
            <?php foreach ($bulk_upload_sample_download as $key => $value): ?>
              <li>
                <a class="dropdown-item" href="<?= $value ?>" target="_blank">
                  <i class="bi bi-file-earmark-arrow-down me-1"></i> <?= esc($key) ?>
                </a>
              </li>
            <?php endforeach; ?>
          </ul>
        </div>
        <?php endif; ?>

        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <div class="modal-body">
        <div class="alert alert-danger d-none" id="uploadErrorAlertWrapper">
          <i class="bi bi-exclamation-triangle me-1"></i>
          <span id="uploadErrorAlert"></span>
        </div>

        <form id="upload-file-dropzone"
              class="dropzone"
              action="<?= esc($bulk_upload_url) ?>"
              enctype="multipart/form-data">
          <?php if (isset($bulk_upload_form_extra)) echo $bulk_upload_form_extra; ?>

          <div class="dz-message">
            <i class="bi bi-cloud-arrow-up-fill"></i>
            <p class="mb-0">Drag & drop your <strong>CSV</strong> file here</p>
            <small class="text-muted">or click to browse from your computer</small>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<script>
Dropzone.autoDiscover = false;

let upload_dropzone = new Dropzone('#upload-file-dropzone', {
  paramName: 'file',
  maxFiles: 1,
  timeout: 1800000,
  acceptedFiles: ".csv",
  previewTemplate: '<div style="display:none"></div>',
  init: function() {
    this.on("sending", function() {
      $('#uploadErrorAlertWrapper').addClass('d-none');
      $('#uploadErrorAlert').html("");
    });

    this.on("success", function(file, response) {
      try {
        if (typeof response === 'string') response = JSON.parse(response);
        if (response.result === 'error') {
          let msg = $(response.error_desc.error).text() || "Unknown error";
          file.previewElement.classList.add("dz-error");
          file.previewElement.querySelectorAll("[data-dz-errormessage]")
              .forEach(node => node.textContent = msg);

        } else if (response.result === 'data_error') {
          $('#uploadErrorAlertWrapper').removeClass('d-none');
          $('#uploadErrorAlert').html(response.errorMessage);
          $('#upload-file-dropzone').hide();
        } else {
          $('#bulkUploadModal').modal('hide');
          if (typeof dt_DataTable !== 'undefined') dt_DataTable.ajax.reload();
          Swal.fire({
            title: response.result ? "Success" : "Error",
            text: response.result ? "Data uploaded successfully!" : response.msg,
            icon: response.result ? "success" : "error",
            confirmButtonColor: "#7367f0"
          });
        }
      } catch (err) {
        console.error("Invalid JSON response", err);
      }
    });

    this.on("error", function(file, errorMessage) {
      Swal.fire({
        title: "Error",
        text: typeof errorMessage === 'string' ? errorMessage : 'File upload failed.',
        icon: "error",
        confirmButtonColor: "#7367f0"
      });
    });
  }
});

function openBulkUploadModal() {
  if (typeof upload_dropzone !== 'undefined') upload_dropzone.removeAllFiles(true);
  $('#uploadErrorAlertWrapper').addClass('d-none');
  $('#uploadErrorAlert').html("");
  $('#upload-file-dropzone').show();
  $('#bulkUploadModal').modal('show');
}
</script>
<?php endif; ?>
