<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
	<div class="card-datatable text-nowrap table-responsive">
		<table id="comment_table" class="table dt-datatable dt-scrollableTable">
			<thead class="border-top">
			<tr>
                <th class="font-weight-bold"><?= lang("Comment.comment"); ?></th>
				<th class="font-weight-bold"><?= lang("Comment.forum_title"); ?></th>
				<th class="font-weight-bold"><?= lang("Comment.member_name"); ?></th>
				<th class="font-weight-bold"><?= lang("Comment.message"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_created_at"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_created_by"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_updated_at"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_updated_by"); ?></th>
			</tr>
			</thead>
		</table>
	</div>
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {
		getFlatMemberDd();
		forumDd();
		dt_DataTable = $('#comment_table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
            scrollX: true,
			displayLength: 10,
			language: {
				sLengthMenu: 'Show _MENU_',
				search: '',
				searchPlaceholder: 'Search <?= lang('Comment.comment');?>',
				info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			},
			buttons: [
			],
			"ajax": {
				"url": "<?php echo admin_url('Comment/getCommentListing'); ?>",
				"type": "POST",
				"data": function(d) {
					var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
					var filterData = $("#advanceFilter").serializeArray();
					$.each(filterData, function(i, val) {
						var name = val.name;
						if (typeof params[name] == 'undefined') {
							params[name] = val.value;
						} else if ($.isArray(params[name])) {
							params[name].push(val.value);
						} else {
							params[name] = [params[name]];
							params[name].push(val.value);
						}
					});

					return $.extend({}, d, params);
				}
			},
			"stateSave": true,
			"order": [[0,"DESC"]],
			"columns": [
				{
					"data": "comment_id",
					"render": function (data, type, row) {
						// return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['comment_id'] + '" name="ids[]" value="' + row['comment_id'] + '"/>';
						return '<button class="btn btn-primary" style="padding: 5px 5px; font-size: 10px;"> <i class="ti ti-plus me-0 me-sm-1 ti-xs"></i> </button>';
					},
					"class": "dt-option-detail no_click_allowed",
					"sortable": false,
					"searchable": false
				},
				{"data": "type_name" },
				{"data": "member_name" },
				{"data": "message" },
				{"data": "created_at" },
				{"data": "created_by" },
				{"data": "updated_at" },
				{"data": "updated_by" },
			],
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
		$('#comment_table tbody').on('click', 'td.dt-option-detail', function () {
		    var tr = $(this).closest('tr'); 
		    var row = dt_DataTable.row(tr);

		    if (row.child.isShown()) {
		        // This row is already open - close it
		        row.child.hide();
		        tr.removeClass('shown');
		    } else {
		        // Open this row
		        hideViewDtData();
		        row.child(getOptionDetail(row.data())).show();
				tr.addClass('shown');
		    }
		});
	});
	function hideViewDtData() {
        $(".dt-option-detail").each(function () {
            var selfElem    = $(this);
            var tr          = $(this).closest('tr');
            var row         = dt_DataTable.row(tr);
            if (row.child.isShown()) {
                row.child.hide();
                selfElem.html('<button class="btn btn-primary" style="padding: 5px 5px; font-size: 10px;"> <i class="ti ti-plus me-0 me-sm-1 ti-xs"></i> </button>');
                selfElem.removeClass('btn-danger');
            }
        });
    }
	function getOptionDetail ( d ) {
		var div = $('<div/>')
				.addClass( 'loading' )
				.text( 'Loading...' );
		$.ajax({
			type: 'post',
			url: '<?php echo admin_url('Comment/getOptionData'); ?>',
			dataType: 'json',
			data: d,
			success: function (jsonObj) {
				var option_data = '';
				option_data +='<div class="table-responsive">';
				option_data +='<table class="table  table-hover table-bordered" id="list_table_json">';
				option_data +='<thead>';
				option_data +='<tr>';
				option_data +='<th class="font-weight-bold"><?= lang('Comment.member_name'); ?></th>';
				option_data +='<th class="font-weight-bold"><?= lang('Comment.message'); ?></th>';
				option_data +='</tr>';
				option_data +='</tr>';		                  
				option_data +='</thead>';
				option_data +='<tbody>';
			if(jsonObj.option_data.length > 0){
	            $.each(jsonObj.option_data, function(index, value){
	            	var adminUrl = '<?= admin_url('') ?>';
	            	var editTaskManagementLang = '<?= lang('Comment.view_comment_detail') ?>';
	                option_data += '<tr>';
					option_data += '<td>'+value.ownership_flat_member_name+'</td>';
					option_data += '<td>'+value.message+'</td>';
	                option_data += '</tr>';
	            });
	        }
	        else{
				option_data += '<tr><td colspan="2" class="text-center"> No Data Available </td></tr>';
	        }
			option_data +='</tbody>';
			option_data +='</table>';
			option_data +='</div>';
				div.html( option_data ).removeClass( 'loading' );
			}
		});
		return div;
	}

	$(document).on('click', '.filter_data', function() {
		dt_DataTable.draw();
	});


	$(document).on('click', '.clear_filter', function() {
		$('form#advanceFilter  #filter_forum_id').val('').trigger('change');
		$('form#advanceFilter  #filter_flat_member_id').val('').trigger('change');
		$("#filter_created_at").val('');
		$("#filter_updated_at").val('');
        dateRangePicker();
		dt_DataTable.draw();
	});

</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>