<?php
$assets = base_url() . 'assets/';
$budgetData = !empty($budget_data) && is_array($budget_data) ? $budget_data : array();
$flatSummary = !empty($flat_summary) && is_array($flat_summary) ? $flat_summary : array();
$totalSqrFt = !empty($flatSummary) && isset($flatSummary['total_sqr_ft']) ? $flatSummary['total_sqr_ft'] : 0;

$totalExpense = 0;
$totalExpensePsf = 0;
$totalIncome = 0;
$totalIncomePsf = 0;

// Pre-calculate totals
if (!empty($expense_data)) {
    foreach ($expense_data as $expenseElement) {
        if (isset($expenseElement['sub_account_data']) && !empty($expenseElement['sub_account_data'])) {
            foreach ($expenseElement['sub_account_data'] as $subAccountElement) {
                $expenseAmountValue = isset($subAccountElement['amount']) ? $subAccountElement['amount'] : 0;
                $totalExpense += $expenseAmountValue;
                $totalExpensePsf += $totalSqrFt != 0 ? round($expenseAmountValue / $totalSqrFt, 2) : 0;
            }
        }
    }
}

if (!empty($income_data)) {
    foreach ($income_data as $incomeElement) {
        if (isset($incomeElement['sub_account_data']) && !empty($incomeElement['sub_account_data'])) {
            foreach ($incomeElement['sub_account_data'] as $subAccountElement) {
                $incomeAmountValue = isset($subAccountElement['amount']) ? $subAccountElement['amount'] : 0;
                $totalIncome += $incomeAmountValue;
                $totalIncomePsf += $totalSqrFt != 0 ? round($incomeAmountValue / $totalSqrFt, 2) : 0;
            }
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $name; ?></title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
    <link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
    <link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">
    <style>
        .budget-table {
            width: 100%;
            border-collapse: collapse;
        }
        .budget-table th, .budget-table td {
            border: 1px solid #333;
            padding: 5px;
            vertical-align: top;
        }
        .budget-table th {
            /* background-color: #f5f5f5; */
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .account-name {
            font-weight: bold;
            /* background-color: #f9f9f9; */
            padding: 4px 5px;
        }
        .sub-account-row td {
            padding: 3px 5px;
            border-bottom: 1px solid #eee;
        }
        .sub-account-name {
            padding-left: 15px;
        }
        .inner-table {
            width: 100%;
            border-collapse: collapse;
        }
        .inner-table td {
            border: none;
            border-bottom: 1px solid #ddd;
            padding: 4px 5px;
        }
        .total-row {
            font-weight: bold;
            /* background-color: #f5f5f5; */
        }
    </style>
</head>

<body style='font-family: Helvetica, Arial, sans-serif; font-size: 9px;'>
<div class="row">
    <div class="col-xs-12">
        <h3 style="color: red; text-align: center; margin-bottom: 15px;"><?= lang('Budget.budget_details'); ?></h3>

        <table class="budget-table">
            <thead>
            <tr>
                <th colspan="3" rowspan="2" class="text-center" style="width: 50%;">
                    <strong><?= lang('Budget.budgeting'); ?></strong>
                </th>
                <th colspan="2" class="text-center"><strong><?= isset($budgetData["society_name"]) ? $budgetData["society_name"] : ""; ?></strong></th>
                <th class="text-center"><strong>Year</strong></th>
            </tr>
            <tr>
                <th class="text-center">
                    <strong>Total Sqr ft</strong>
                </th>
                <th class="text-center">
                    <strong><?= isset($totalSqrFt) ? $totalSqrFt : "-"; ?></strong>
                </th>
                <th class="text-center">
                    <strong><?= isset($budgetData["financial_year_prefix"]) ? $budgetData["financial_year_prefix"] : ""; ?></strong>
                </th>
            </tr>
            <tr>
                <th class="text-center" style="width: 25%;"><strong>Expenses</strong></th>
                <th class="text-center" style="width: 12%;"><strong>Amount</strong></th>
                <th class="text-center" style="width: 8%;"><strong>PSF</strong></th>
                <th class="text-center" style="width: 25%;"><strong>Incomes</strong></th>
                <th class="text-center" style="width: 12%;"><strong>Amount</strong></th>
                <th class="text-center" style="width: 8%;"><strong>PSF</strong></th>
            </tr>
            </thead>

            <tbody>
            <tr>
                <!-- Expenses Data -->
                <td colspan="3" style="padding: 0; vertical-align: top;">
                    <table class="inner-table">
                        <?php
                        if (!empty($expense_data)) {
                            foreach ($expense_data as $expenseElement) {
                                // Calculate account-wise total
                                $accountTotal = 0;
                                $accountTotalPsf = 0;
                                if (isset($expenseElement['sub_account_data']) && !empty($expenseElement['sub_account_data'])) {
                                    foreach ($expenseElement['sub_account_data'] as $subAccountElement) {
                                        $accountTotal += isset($subAccountElement['amount']) ? $subAccountElement['amount'] : 0;
                                    }
                                    $accountTotalPsf = $totalSqrFt != 0 ? round($accountTotal / $totalSqrFt / 12, 2) : 0;
                                }
                                ?>
                                <tr>
                                    <td class="account-name" style="width: 55%;"><?= trim($expenseElement['account_code_name']); ?></td>
                                    <td class="account-name text-right" style="width: 27%;"><?= number_format($accountTotal, 2); ?></td>
                                    <td class="account-name text-right" style="width: 18%;"><?= number_format($accountTotalPsf, 2); ?></td>
                                </tr>
                                <?php
                                if (isset($expenseElement['sub_account_data']) && !empty($expenseElement['sub_account_data'])) {
                                    foreach ($expenseElement['sub_account_data'] as $subAccountElement) {
                                        $expenseAmountValue = isset($subAccountElement['amount']) ? $subAccountElement['amount'] : 0;
                                        $expensePsf = $totalSqrFt != 0 ? round($expenseAmountValue / $totalSqrFt / 12, 2) : 0;
                                        ?>
                                        <tr class="sub-account-row">
                                            <td class="sub-account-name" style="width: 55%;"><?= $subAccountElement['sub_account_code_name']; ?></td>
                                            <td class="text-right" style="width: 27%;"><?= number_format($expenseAmountValue, 2); ?></td>
                                            <td class="text-right" style="width: 18%;"><?= number_format($expensePsf, 2); ?></td>
                                        </tr>
                                        <?php
                                    }
                                }
                            }
                        } else {
                            echo '<tr><td colspan="3" class="text-center">No expense data</td></tr>';
                        }
                        ?>
                    </table>
                </td>

                <!-- Incomes Data -->
                <td colspan="3" style="padding: 0; vertical-align: top;">
                    <table class="inner-table">
                        <?php
                        if (!empty($income_data)) {
                            foreach ($income_data as $incomeElement) {
                                // Calculate account-wise total
                                $accountTotal = 0;
                                $accountTotalPsf = 0;
                                if (isset($incomeElement['sub_account_data']) && !empty($incomeElement['sub_account_data'])) {
                                    foreach ($incomeElement['sub_account_data'] as $subAccountElement) {
                                        $accountTotal += isset($subAccountElement['amount']) ? $subAccountElement['amount'] : 0;
                                    }
                                    $accountTotalPsf = $totalSqrFt != 0 ? round($accountTotal / $totalSqrFt / 12, 2) : 0;
                                }
                                ?>
                                <tr>
                                    <td class="account-name" style="width: 55%;"><?= trim($incomeElement['account_code_name']); ?></td>
                                    <td class="account-name text-right" style="width: 27%;"><?= number_format($accountTotal, 2); ?></td>
                                    <td class="account-name text-right" style="width: 18%;"><?= number_format($accountTotalPsf, 2); ?></td>
                                </tr>
                                <?php
                                if (isset($incomeElement['sub_account_data']) && !empty($incomeElement['sub_account_data'])) {
                                    foreach ($incomeElement['sub_account_data'] as $subAccountElement) {
                                        $incomeAmountValue = isset($subAccountElement['amount']) ? $subAccountElement['amount'] : 0;
                                        $incomePsf = $totalSqrFt != 0 ? round($incomeAmountValue / $totalSqrFt / 12, 2) : 0;
                                        ?>
                                        <tr class="sub-account-row">
                                            <td class="sub-account-name" style="width: 55%;"><?= $subAccountElement['sub_account_code_name']; ?></td>
                                            <td class="text-right" style="width: 27%;"><?= number_format($incomeAmountValue, 2); ?></td>
                                            <td class="text-right" style="width: 18%;"><?= number_format($incomePsf, 2); ?></td>
                                        </tr>
                                        <?php
                                    }
                                }
                            }
                        } else {
                            echo '<tr><td colspan="3" class="text-center">No income data</td></tr>';
                        }
                        ?>
                    </table>
                </td>
            </tr>
            <tr class="total-row">
                <td class="text-center"><strong>Total Expense</strong></td>
                <td class="text-right"><strong><?= number_format($totalExpense, 2); ?></strong></td>
                <td class="text-right"><strong><?= number_format($totalExpensePsf, 2); ?></strong></td>
                <td class="text-center"><strong>Total Income</strong></td>
                <td class="text-right"><strong><?= number_format($totalIncome, 2); ?></strong></td>
                <td class="text-right"><strong><?= number_format($totalIncomePsf, 2); ?></strong></td>
            </tr>
            </tbody>
        </table>
    </div>
</div>
</body>
</html>
