<?php
$flatSummary = !empty($flat_summary) && is_array($flat_summary) ? $flat_summary : array();
$totalSqrFt = !empty($flatSummary) && isset($flatSummary['total_sqr_ft']) ? $flatSummary['total_sqr_ft'] : 0;
?>

<div class="container-fluid py-3" data-totalsqft="<?= $totalSqrFt; ?>">
    <div class="row">
        <!-- Expense Table -->
        <div class="col-md-6 mb-3">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="table-primary">
                        <tr>
                            <th class="text-bold">Expenses</th>
                            <th class="text-center">Amount</th>
                            <th class="text-center">PSF</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $expenseCountRow = 0;
                        $expenseAccountIndex = 0;
                        if (!empty($expense_data)) {
                            foreach ($expense_data as $expenseElement) {
                                $expenseAccountIndex++;
                                // Calculate account-wise total
                                $accountTotal = 0;
                                $accountTotalPsf = 0;
                                if (isset($expenseElement['sub_account_data']) && !empty($expenseElement['sub_account_data'])) {
                                    foreach ($expenseElement['sub_account_data'] as $subAccountElement) {
                                        $accountTotal += isset($subAccountElement['amount']) ? (float)$subAccountElement['amount'] : 0.0;
                                    }
                                    $accountTotalPsf = ($totalSqrFt > 0) ? ($accountTotal / $totalSqrFt / 12) : 0.0;
                                }
                                ?>
                                <tr class="table-secondary" data-account-index="expense-<?= $expenseAccountIndex; ?>">
                                    <td class="text-bold"><?= trim($expenseElement['account_code_name']); ?></td>
                                    <td class="text-end text-bold expense-account-total" data-account="expense-<?= $expenseAccountIndex; ?>"><?= number_format($accountTotal, 2); ?></td>
                                    <td class="text-center text-bold expense-account-psf" data-account="expense-<?= $expenseAccountIndex; ?>"><?= number_format($accountTotalPsf, 2); ?></td>
                                </tr>
                                <?php
                                if (isset($expenseElement['sub_account_data']) && !empty($expenseElement['sub_account_data'])) {
                                    foreach ($expenseElement['sub_account_data'] as $subAccountElement) {
                                        $expenseCountRow++;
                                        $expenseInputId = 'expense_amount_' . $expenseCountRow;
                                        $expenseInputName = 'expense_amount[' . $expenseCountRow . ']';
                                        $hiddenInputName = 'expense_sub_account_id[' . $expenseCountRow . ']';
                                        $hiddenInputAccount = 'expense_account_id[' . $expenseCountRow . ']';
                                        $expenseAmountValue = isset($subAccountElement['amount']) ? (float)$subAccountElement['amount'] : 0.0;

                                        // calculate PSF server-side (safe against divide by zero)
                                        $expensePsf = ($totalSqrFt > 0) ? ($expenseAmountValue / $totalSqrFt / 12) : 0.0;
                                        ?>
                                        <tr data-account-group="expense-<?= $expenseAccountIndex; ?>">
                                            <td class="text-primary text-bold ps-3">
                                                <?= htmlspecialchars($subAccountElement['sub_account_code_name']); ?>
                                            </td>
                                            <td class="text-end">
                                                <input type="text"
                                                       id="<?= $expenseInputId ?>"
                                                       name="<?= $expenseInputName ?>"
                                                       class="form-control form-control-sm amount expense-amount"
                                                       placeholder="Enter Amount"
                                                       value="<?= number_format($expenseAmountValue, 2, '.', ''); ?>"
                                                       data-row-type="expense"
                                                       data-row-index="<?= $expenseCountRow; ?>"
                                                       data-account-group="expense-<?= $expenseAccountIndex; ?>">
                                                <input type="hidden" name="<?= $hiddenInputName ?>" value="<?= $subAccountElement['sub_account_id']; ?>">
                                                <input type="hidden" name="<?= $hiddenInputAccount ?>" value="<?= $expenseElement['account_id']; ?>">
                                            </td>
                                            <td class="text-center psf-cell">
                                                <?= number_format($expensePsf, 2, '.', ''); ?>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                }
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Income Table -->
        <div class="col-md-6 mb-3">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="table-primary">
                        <tr>
                            <th class="text-bold">Incomes</th>
                            <th class="text-center">Amount</th>
                            <th class="text-center">PSF</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $incomeCountRow = 0;
                        $incomeAccountIndex = 0;
                        if (!empty($income_data)) {
                            foreach ($income_data as $incomeElement) {
                                $incomeAccountIndex++;
                                // Calculate account-wise total
                                $accountTotal = 0;
                                $accountTotalPsf = 0;
                                if (isset($incomeElement['sub_account_data']) && !empty($incomeElement['sub_account_data'])) {
                                    foreach ($incomeElement['sub_account_data'] as $subAccountElement) {
                                        $accountTotal += isset($subAccountElement['amount']) ? (float)$subAccountElement['amount'] : 0.0;
                                    }
                                    $accountTotalPsf = ($totalSqrFt > 0) ? ($accountTotal / $totalSqrFt / 12) : 0.0;
                                }
                                ?>
                                <tr class="table-secondary" data-account-index="income-<?= $incomeAccountIndex; ?>">
                                    <td class="text-bold"><?= trim($incomeElement['account_code_name']); ?></td>
                                    <td class="text-end text-bold income-account-total" data-account="income-<?= $incomeAccountIndex; ?>"><?= number_format($accountTotal, 2); ?></td>
                                    <td class="text-center text-bold income-account-psf" data-account="income-<?= $incomeAccountIndex; ?>"><?= number_format($accountTotalPsf, 2); ?></td>
                                </tr>
                                <?php
                                if (isset($incomeElement['sub_account_data']) && !empty($incomeElement['sub_account_data'])) {
                                    foreach ($incomeElement['sub_account_data'] as $subAccountElement) {
                                        $incomeCountRow++;
                                        $incomeInputId = 'income_amount_' . $incomeCountRow;
                                        $incomeInputName = 'income_amount[' . $incomeCountRow . ']';
                                        $hiddenInputName = 'income_sub_account_id[' . $incomeCountRow . ']';
                                        $hiddenInputAccount = 'income_account_id[' . $incomeCountRow . ']';
                                        $incomeAmountValue = isset($subAccountElement['amount']) ? (float)$subAccountElement['amount'] : 0.0;

                                        // calculate PSF server-side
                                        $incomePsf = ($totalSqrFt > 0) ? ($incomeAmountValue / $totalSqrFt / 12) : 0.0;
                                        ?>
                                        <tr data-account-group="income-<?= $incomeAccountIndex; ?>">
                                            <td class="text-primary text-bold ps-3">
                                                <?= htmlspecialchars($subAccountElement['sub_account_code_name']); ?>
                                            </td>
                                            <td class="text-end">
                                                <input type="text"
                                                       id="<?= $incomeInputId ?>"
                                                       name="<?= $incomeInputName ?>"
                                                       class="form-control form-control-sm amount income-amount"
                                                       placeholder="Enter Amount"
                                                       value="<?= number_format($incomeAmountValue, 2, '.', ''); ?>"
                                                       data-row-type="income"
                                                       data-row-index="<?= $incomeCountRow; ?>"
                                                       data-account-group="income-<?= $incomeAccountIndex; ?>">
                                                <input type="hidden" name="<?= $hiddenInputName ?>" value="<?= $subAccountElement['sub_account_id']; ?>">
                                                <input type="hidden" name="<?= $hiddenInputAccount ?>" value="<?= $incomeElement['account_id']; ?>">
                                            </td>
                                            <td class="text-center psf-cell">
                                                <?= number_format($incomePsf, 2, '.', ''); ?>
                                            </td>
                                        </tr>
                                        <?php
                                    }
                                }
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- JS to recalc PSF live when amounts change -->
<script>
(function(){
    // read total sqft from parent div attribute
    var parentDiv = document.querySelector('div.container-fluid[data-totalsqft]');
    var totalSqFt = parentDiv ? parseFloat(parentDiv.getAttribute('data-totalsqft') || 0) : 0;

    function parseNumber(val) {
        if (val === null || val === undefined) return 0;
        // remove commas and trim
        val = String(val).replace(/,/g, '').trim();
        var f = parseFloat(val);
        return isNaN(f) ? 0 : f;
    }

    function formatNumber(num) {
        return num.toLocaleString('en-IN', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    }

    // Function to update account-wise totals
    function updateAccountTotal(accountGroup) {
        var inputs = document.querySelectorAll('input.amount[data-account-group="' + accountGroup + '"]');
        var total = 0;
        inputs.forEach(function(inp) {
            total += parseNumber(inp.value);
        });

        var totalPsf = (totalSqFt > 0) ? (total / totalSqFt / 12) : 0;

        // Update account total cell
        var accountTotalCell = document.querySelector('.expense-account-total[data-account="' + accountGroup + '"], .income-account-total[data-account="' + accountGroup + '"]');
        if (accountTotalCell) {
            accountTotalCell.textContent = formatNumber(total);
        }

        // Update account PSF cell
        var accountPsfCell = document.querySelector('.expense-account-psf[data-account="' + accountGroup + '"], .income-account-psf[data-account="' + accountGroup + '"]');
        if (accountPsfCell) {
            accountPsfCell.textContent = totalPsf.toFixed(2);
        }
    }

    // delegated input listener for any .amount input
    document.addEventListener('input', function(e){
        var el = e.target;
        if (!el.classList.contains('amount')) return;

        var row = el.closest('tr');
        if (!row) return;

        var amount = parseNumber(el.value);
        var psfCell = row.querySelector('.psf-cell');
        if (!psfCell) return;

        var psf = (totalSqFt > 0) ? (amount / totalSqFt / 12) : 0;
        psfCell.textContent = psf.toFixed(2);

        // Update account-wise total
        var accountGroup = el.getAttribute('data-account-group');
        if (accountGroup) {
            updateAccountTotal(accountGroup);
        }
    });

    // Optional: format initial input values (remove thousand separators) and force initial PSF render
    document.addEventListener('DOMContentLoaded', function() {
        // trigger input event on all amount fields to refresh PSF cells
        var amounts = document.querySelectorAll('input.amount');
        amounts.forEach(function(inp){
            // ensure a consistent number format (2 decimals)
            var v = parseNumber(inp.value);
            inp.value = v.toFixed(2);
            // trigger manual calculation
            var ev = new Event('input', { bubbles: true });
            inp.dispatchEvent(ev);
        });
    });
})();
</script>