<?php 
$this->ionAuth    = new \App\Libraries\IonAuth();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Broker.broker_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_broker',
				);
				echo form_open_multipart('',$form_id);
				$brokerId = (isset($broker_data['broker_id']) && ($broker_data['broker_id'] != '')) ? $broker_data['broker_id'] : '';
				?>
				<input type="hidden" id="broker_id" name="broker_id" value="<?= $brokerId ?>">
				<input type="hidden" id="is_button_click" name="is_button_click" value="0">

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Broker.broker_phone_number');?><span class="text-danger"> *</span></label>
						<div class="col-sm-8">	
							<input type="text" class="form-control numberInit" name="broker_phone_number" id="broker_phone_number" placeholder="Enter <?= lang('Broker.broker_phone_number');?>" value="<?= (isset($broker_data['broker_phone_number']) && ($broker_data['broker_phone_number'] != '')) ? $broker_data['broker_phone_number'] : '';  ?>" />
						</div>
						<div class="col-sm-2">
							<button type="button" class="btn btn-label-primary dt-broker-detail btn btn-md" >Broker Detail </button>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Broker.broker_name');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="broker_name" id="broker_name" placeholder="Enter <?= lang('Broker.broker_name');?>" value="<?= (isset($broker_data['broker_name']) && ($broker_data['broker_name'] != '')) ? $broker_data['broker_name'] : '';  ?>" />
						</div>
					</div>

					
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Broker.broker_address');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
                        	<textarea name="broker_address"  id="broker_address" placeholder="Enter <?= lang('Broker.broker_address'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($broker_data['broker_address']) && ($broker_data['broker_address'] != '')) ? $broker_data['broker_address'] : ''; ?></textarea>
                        </div>
                    </div>

                    <?PHP if($this->ionAuth->isAdmin()) {?>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Broker.society');?></label>
						<div class="col-sm-10">
							<select data-placeholder="Select  <?= lang('Broker.society'); ?>" name="society_id[]"
								id="society_id" class="form-control societyDd" multiple>
							
							<?php
							if(isset($broker_society_data) && !empty($broker_society_data)) {
								foreach ($broker_society_data as  $brokerElement){ ?>
									<option  value="<?= isset($brokerElement['society_id']) ? $brokerElement['society_id'] : ""; ?>" selected> <?= $brokerElement['society_name']; ?> </option>
								<?php  }
							} ?>
							</select>
						</div>
					</div>
				<?php } ?>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($broker_data['is_active']) || $broker_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Broker'); ?>'" class="btn btn-label-secondary"><?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
        numberInit();
        societyDd();
		switcheryKeyGen("datatable-list-switchery");
        // Initialize
		var validator = $("#form_broker").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				broker_name: {
					required: true,
				},
				broker_phone_number: {
					required: true,
                    minlength: 10,
					maxlength: 10,
				},
				broker_address: {
					required: true,
				},
				// ifsc_code:{
				// 	required: true,
				// 	minlength: 11,
				// 	maxlength: 11,
				// },
				
            },
            messages: {
				broker_name: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Broker.broker_name"); ?>',
				},
				broker_phone_number: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Broker.broker_phone_number'); ?>",
				},
				broker_address: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Broker.broker_address'); ?>",
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Broker/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Broker');?>';
                                }
							});
							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Broker');?>';
							// }, 1000);
						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });


    $(document).on('click', '.dt-broker-detail', function() {
		
		var brokerPhoneNumber = $("#broker_phone_number").val();
		$.ajax({
			type: "post",
			url: '<?php echo admin_url("Broker/getBrokerDetail");?>',
			dataType: "json",
			async: false,
			data: {
				broker_phone_number: brokerPhoneNumber,
			},
			success: function(data) {
				if (data) {
					if (data.success) {
						var brokerSocietySelect = $('#society_id');
						brokerSocietySelect.val("").trigger('change');
						$("#broker_name").val('');
						$("#broker_id").val('');
						$("#broker_address").val('');
						$("#is_button_click").val('');
		                var brokerSocietyData = data.broker_society_data;
						console.log(data.broker_data['broker_address']);
						$("#broker_name").val(data.broker_data['broker_name']);
						$("#broker_id").val(data.broker_data['broker_id']);
						$("#broker_address").val(data.broker_data['broker_address']);
						var brokerActive = data.broker_data['is_active'];
						if(brokerActive == 1){
							$('#is_active').prop("checked","checked");
						}
						else{
							$('#is_active').prop('checked', false);
						}
						$("#is_button_click").val(data.is_button_click);
						$("#society_id").empty().trigger('change');
						$.each(brokerSocietyData, function(index, val){
		                	var option = new Option(val.society_name,val.society_id, true, true);
							// Append it to the select
							$("#society_id").append(option).trigger('change');
						});
						$('#broker_name').prop("readonly", true);
						$('#broker_address').prop("readonly", true);
					}
					else {
						$("#is_button_click").val(data.is_button_click);
						

					}
				}
			}
		});
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>