<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#booking_detail" aria-controls="booking_detail" aria-selected="true">
			<?= lang('Booking.booking_detail'); ?>
		</button>
	</li>
	<!-- <li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#contact-information" aria-controls="contact-information" aria-selected="false">
			<?= lang('Booking.contact_person_detail'); ?>
		</button>
	</li> -->
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="booking_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="booking_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Booking.amenities"); ?></td>
						<td><?php
							echo (isset($booking_data['amenities_name']) && $booking_data['amenities_name'] != "") ? $booking_data['amenities_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Booking.booking_date"); ?></td>
						<td><?php
							echo (isset($booking_data['booking_date']) && $booking_data['booking_date'] != "") ? siteDateFormat($booking_data['booking_date']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Booking.time_slot"); ?></td>
						<td><?php
							echo (isset($booking_data['time_slot_name']) && $booking_data['time_slot_name'] != "") ? $booking_data['time_slot_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Booking.flat"); ?></td>
						<td><?php
							echo (isset($booking_data['tower_flat_name']) && $booking_data['tower_flat_name'] != "") ? $booking_data['tower_flat_name'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Booking.status"); ?></td>
						<td><?php
							echo (isset($booking_data['status']) && $booking_data['status'] != "") ? $booking_data['status'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Booking.booked_by"); ?></td>
						<td><?php
							echo (isset($booking_data['name']) && $booking_data['name'] != "") ? $booking_data['name'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Booking.amenities_unit"); ?></td>
						<td><?php
							echo (isset($booking_data['unit_name']) && $booking_data['unit_name'] != "") ? $booking_data['unit_name'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($booking_data['created_at']) && isValidDate($booking_data['created_at'])) ? siteDateFormat($booking_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($booking_data['created_by']) && $booking_data['created_by'] != "") ? $booking_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($booking_data['updated_at']) && isValidDate($booking_data['updated_at'])) ? siteDateFormat($booking_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($booking_data['updated_by']) && $booking_data['updated_by'] != "") ? $booking_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="tab-pane fade" id="contact-information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="contact_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Booking.contact_person_name"); ?></td>
						<td><?php
							echo (isset($booking_data['contact_person_name']) && $booking_data['contact_person_name'] != "") ? $booking_data['contact_person_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Booking.contact_phone_number"); ?></td>
						<td><?php
							echo (isset($booking_data['contact_phone_number']) && $booking_data['contact_phone_number'] != "") ? $booking_data['contact_phone_number'] : '-';
							?>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</div>