<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Booking.booking_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_booking',
				);
				echo form_open_multipart('',$form_id);
				$bookingId = (isset($booking_data['booking_id']) && ($booking_data['booking_id'] != '')) ? $booking_data['booking_id'] : '';
				$bookingDate = (isset($booking_data['booking_date']) && ($booking_data['booking_date'] != '')) ? $booking_data['booking_date'] : '';
				?>
				<input type="hidden" id="booking_id" name="booking_id" value="<?= $bookingId ?>">
					<div class="row g-3">
						<div class="col-md-6">
							<label class="form-label" ><?= lang('Booking.amenities'); ?><span class="text-danger"> *</span></label>
							<select id="amenities_id" name="amenities_id" class="select2 form-select amenitiesDd"  data-allow-clear="true">
								<option></option>
								<?php if(isset($booking_data['amenities_id']) && $booking_data['amenities_id'] != 0){ ?>
									<option value="<?= isset($booking_data['amenities_id']) ? $booking_data['amenities_id'] : 0 ?>" selected> <?= isset($booking_data['amenities_name']) ? $booking_data['amenities_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
						<div class="col-md-6">
							<label class="form-label booking_date" for="basic-default-name"><?= lang('Booking.booking_date');?><span class="text-danger"> *</span></label>
							<input type="text" class="form-control" name="booking_date" id="booking_date" placeholder="Enter <?= lang('Booking.booking_date');?>" value="<?= (isset($booking_data['booking_date']) && isValidDate($booking_data['booking_date'])) ? siteDateFormat($booking_data['booking_date']) : ''; ?>" />
						</div>
					</div>

					<div class="row g-3">
						<div class="col-md-6">
							<label class="form-label"><?= lang('Booking.member');?><span class="text-danger"> *</span></label>
								<select id="ownership_flat_member_id" name="ownership_flat_member_id" class="select2 form-select getFlatMemberDd dt-ownership-flat-member" data-allow-clear="true">
									<option></option>
									<?php if(isset($booking_data['ownership_flat_member_id']) && $booking_data['ownership_flat_member_id'] != 0){ ?>
									<option value="<?= isset($booking_data['ownership_flat_member_id']) ? $booking_data['ownership_flat_member_id'] : 0 ?>" selected> <?= isset($booking_data['name']) ? $booking_data['name'] : ''  ?> </option>
									<?php } ?>
								</select>
						</div>
						<div class="col-md-6">
							<label class="form-label" ><?= lang('Booking.amenities_unit'); ?><span class="text-danger"> *</span></label>
							<select id="amenities_unit_id" name="amenities_unit_id" class="select2 form-select amenitiesUnitDd"  data-allow-clear="true">
								<option></option>
								<?php if(isset($booking_data['amenities_unit_id']) && $booking_data['amenities_unit_id'] != 0){ ?>
									<option value="<?= isset($booking_data['amenities_unit_id']) ? $booking_data['amenities_unit_id'] : 0 ?>" selected> <?= isset($booking_data['unit_name']) ? $booking_data['unit_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>
					<div class="row g-3">
						<div class="col-md-6">
							<label class="form-label"><?= lang('Booking.time_slot');?><span class="text-danger"> *</span></label>
								<select id="time_slots" name="time_slots" class="select2 form-select time-slots" data-allow-clear="true">
									<option></option>
									<?php if(isset($booking_data['time_slot_name']) && $booking_data['time_slot_name'] != 0){ ?>
									<option value="<?= isset($booking_data['time_slot_name']) ? $booking_data['time_slot_name'] : 0 ?>" selected> <?= isset($booking_data['time_slot_name']) ? $booking_data['time_slot_name'] : ''  ?> </option>
									<?php } ?>
								</select>
						</div>
					</div>
						<?php /*?>
						<div class="col-md-6">
							<label class="form-label" ><?= lang('Booking.time_slot'); ?><span class="text-danger"> *</span></label>
							<select id="time_slot_id" name="time_slot_id" class="select2 form-select timeSlotDd"  data-allow-clear="true">
								<option></option>
								<?php if(isset($booking_data['time_slot_id']) && $booking_data['time_slot_id'] != 0){ ?>
									<option value="<?= isset($booking_data['time_slot_id']) ? $booking_data['time_slot_id'] : 0 ?>" selected> <?= isset($booking_data['time_slot_name']) ? $booking_data['time_slot_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
						
						<div class="col-md-6">
							<label class="form-label" ><?= lang('Booking.flat'); ?><span class="text-danger"> *</span></label>
							<select id="flat_id" name="flat_id" class="select2 form-select flatDd dt-flat"  data-allow-clear="true">
								<option></option>
								<?php if(isset($booking_data['flat_id']) && $booking_data['flat_id'] != 0){ ?>
									<option value="<?= isset($booking_data['flat_id']) ? $booking_data['flat_id'] : 0 ?>" selected> <?= isset($booking_data['tower_flat_name']) ? $booking_data['tower_flat_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
						<?php */?>
					
			
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Booking'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
    	amenitiesDd();
    	// timeSlotDd();
    	// flatDd();
		amenitiesUnitDd();
		getFlatMemberDd();
    	// $(".dt-slot-type").select2();
    	$(".time-slots").select2();
		switcheryKeyGen("datatable-list-switchery");
		$(".time-slots").select2({
			placeholder: "Select Time Slot",
			allowClear: true
		});
		
        // Initialize
		var validator = $("#form_booking").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				booking_date:{
					required : true,
				},
				amenities_id : {
					required: true,
				},
				ownership_flat_member_id : {
					required: true,
				},
				amenities_unit_id : {
					required: true,
				},
				time_slots : {
					required: true,
				},
				
            },
            messages: {
				booking_date: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Booking.booking_date"); ?>',
				},
				amenities_id: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Booking.amenities"); ?>',
				},
				ownership_flat_member_id : {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Booking.member"); ?>',
				},
				amenities_unit_id : {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Booking.amenities_unit"); ?>',
				},
				time_slots : {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Booking.time_slot"); ?>',
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Booking/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Booking');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Booking');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });

		<?php 
        if(!empty($bookingId)){
        	$minDate = $bookingDate;
        }
        else{
        	$minDate = DATERANGEPICKER_MIN_DATE;
        }
        ?>

        $("#booking_date").flatpickr({
			// monthSelectorType: 'static',
			dateFormat: "d-m-Y",
			minDate: '<?= $minDate;?>',
			// dateFormat: 'd-m-Y',
            // minDate: "today",
            //maxDate:"15-07-2024"
		});

		$(document).on('change','#booking_date', function () {
			var amenitiesId    = $('#amenities_id').val();
			var bookingDate    = $('#booking_date').val();
			$.ajax({
				type: "POST",
				url: "<?php echo admin_url('Booking/getAmenitiesTimeSlot'); ?>",
				dataType: "json",
				data: {
					amenities_id : amenitiesId,
					booking_date : bookingDate,
				},
				success: function (resObj) {
					// console.log(resObj);
					if (resObj.success) {
						// Clear any previous options in the time slots dropdown
						// Get the currently selected value
						if(bookingDate != '<?= $bookingDate?>'){
							$('#time_slots').empty();
						} 
						var selectedValue = $('#time_slots').val();
						// Populate the time slots dynamically
						$.each(resObj.time_slots_array, function (index, value) {
							// Check if the current value is not the selected value
							if (value !== selectedValue) {
								$('#time_slots').append('<option value="' + value + '">' + value + '</option>');
							}
						});
						// Initialize or refresh select2
						$(".time-slots").select2({
							placeholder: "Select Time Slot",
							allowClear: true
						});
					} 
				}  
			});
    	});
    });

	<?php if ($bookingId != '') { ?>
        $(document).ready(function() {
            $('#booking_date').change(); // Trigger the change event
        });
	<?php } ?>

	<?php if ($bookingId != '') { ?>
		$(document).on('change','#booking_date', function () {
			$('#time_slots').empty();
		});
	<?php } ?>

</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
