<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('BankAccount.bank_account_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_bank_account',
				);
				echo form_open_multipart('',$form_id);
				$bankAccountId = (isset($bank_account_data['bank_account_id']) && ($bank_account_data['bank_account_id'] != '')) ? $bank_account_data['bank_account_id'] : '';
				?>
				<input type="hidden" id="bank_account_id" name="bank_account_id" value="<?= $bankAccountId ?>">
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('BankAccount.bank_name');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<select id="bank_id" name="bank_id" class="select2 form-select form-select-lg bankDd dt-bank" data-allow-clear="true">
							<option></option>
							<?php if(isset($bank_account_data['bank_id']) && $bank_account_data['bank_id'] != 0){ ?>
							<option value="<?= isset($bank_account_data['bank_id']) ? $bank_account_data['bank_id'] : 0 ?>" selected> <?= isset($bank_account_data['bank_name']) ? $bank_account_data['bank_name'] : ''  ?> </option>
							<?php } ?>
						</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('BankAccount.account_type');?><span class="text-danger"> *</span></label>
							<div class="col-sm-10">
								<?php
								$bankAccountTypes = bankAccountType();
								?>
								<select data-placeholder="Select  <?= lang('BankAccount.account_type'); ?>" name="bank_account_type"
										id="bank_account_type" class="select2 form-select dt-bank-account-type">
									<option> </option>
									<?php
									$selectedBankAccountType = isset($bank_account_data['bank_account_type']) ? $bank_account_data['bank_account_type'] : "";
									foreach ($bankAccountTypes as $bankAccountKey => $bankAccountType) { ?>
										<option <?= ($selectedBankAccountType == $bankAccountKey) ? "selected" : ""; ?>
											value="<?= $bankAccountKey; ?>"> <?= $bankAccountType; ?> </option>
									<?php } ?>
								</select>
							</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('BankAccount.branch');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="branch" id="branch" placeholder="Enter <?= lang('BankAccount.branch');?>" value="<?= (isset($bank_account_data['branch']) && ($bank_account_data['branch'] != '')) ? $bank_account_data['branch'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('BankAccount.bank_account_no');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="bank_account_no" id="bank_account_no" placeholder="Enter <?= lang('BankAccount.bank_account_no');?>" value="<?= (isset($bank_account_data['bank_account_no']) && ($bank_account_data['bank_account_no'] != '')) ? $bank_account_data['bank_account_no'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('BankAccount.ifsc_code');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="ifsc_code" id="ifsc_code" placeholder="Enter <?= lang('BankAccount.ifsc_code');?>" value="<?= (isset($bank_account_data['ifsc_code']) && ($bank_account_data['ifsc_code'] != '')) ? $bank_account_data['ifsc_code'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($bank_account_data['is_active']) || $bank_account_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('BankAccount'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
		switcheryKeyGen("datatable-list-switchery");
		bankDd();
		$('.dt-bank-account-type').select2();
        // Initialize
		var validator = $("#form_bank_account").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				bank_id: {
					required: true,
				},
				branch: {
					required: true,
				},
				bank_account_type: {
					required: true,
				},
				bank_account_no: {
					required: true,
				},
				ifsc_code:{
					required: true,
				},
				
            },
            messages: {
				bank_id: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("BankAccount.bank_name"); ?>',
				},
				branch: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('BankAccount.branch'); ?>",
				},
				bank_account_type: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('BankAccount.account_type'); ?>",
				},
				bank_account_no: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('BankAccount.bank_account_no'); ?>",
				},
				ifsc_code:{
					required:  "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('BankAccount.ifsc_code'); ?>",
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("BankAccount/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('BankAccount');?>';
                                }
							});
							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('BankAccount');?>';
							// }, 1000);
						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>