<?php
$html = '';
if (isset($user_group_data) && !empty($user_group_data)) {
	foreach ($user_group_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["user_group_data"] = $value;
		$html .= view('Admin/Auth/UserGroupTableRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="user_group_table" class="table table-bordered">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('Auth.society'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Auth.assigned_group'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($user_group_data) && !empty($user_group_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/Auth/UserGroupTableRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addUserGroup() {
		var lastIndex = ($("#user_group_table tbody tr:last").length >= 1) ? $("#user_group_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('Auth/addUserGroupRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#user_group_table tbody').append(data);
					addSerialNumber('user_group_table');
					societyDd();
					groupDd();
					userGroup();
				}
			}
		});
	}

	$(document).on('click', '.dt-delete-user-group-row', function () {
        var trField = $(this).closest('tr');
        var id = $(this).closest('tr').find(".user_society_group_id").val();
        if (id != '') {
            Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
                if (result.value) {
                    $.ajax({
                        type: "POST",
                        url: "<?php echo admin_url('Auth/deleteUserGroupRow');?>",
                        dataType: "json",
                        data: {row_id: id},
                        success: function (resObj) {
                            addSerialNumber('user_group_table');
                            if (resObj.success) {
                                $(trField).remove();
                                Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function () {
                                    if ($('#user_group_table tbody > tr').length == 0) {
                                        addUserGroup();
                                    }
                                });
                            } else {
                                Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
                            }
                        }
                    });
                }
            });
        } else {
            $(trField).remove();
            addSerialNumber('user_group_table');
            if ($('#user_group_table tbody > tr').length == 0) {
                addUserGroup();
            }
        }
    });
</script>