<!-- Change Password -->
<div class="card mb-4">
    <h5 class="card-header"><?php echo lang('Auth.change_password_heading'); ?></h5>
    <div class="card-body">
        <?php
        //create  form open tag
        $form_id = array(
            'id' => 'form_change_password',
            'method' => 'post',
            'class' => '',
        );
        echo form_open_multipart('', $form_id);
        ?>

        <!-- Login User id-->
        <input type="hidden" name="user_id" value="<?php echo $user_id = (isset($user_id) && ($user_id != '')) ? $user_id : '' ?>" id="user_id">

        <div class="row">
            <div class="mb-3 col-md-6 form-password-toggle">
                <label class="form-label" for="currentPassword"><?= lang('Auth.change_password_old_password_label'); ?></label>
                <div class="input-group input-group-merge">
                    <input class="form-control" type="password" name="old" id="old" placeholder="Enter <?= lang('Auth.change_password_old_password_label'); ?>" />
                    <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="mb-3 col-md-6 form-password-toggle">
                <label class="form-label" for="newPassword"><?= sprintf(lang('Auth.change_password_new_password_label'), $minPasswordLength); ?></label>
                <div class="input-group input-group-merge">
                    <input class="form-control" type="password" id="new" name="new" placeholder="Enter <?= sprintf(lang('Auth.change_password_new_password_label'), $minPasswordLength); ?>" />
                    <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                </div>
            </div>

            <div class="mb-3 col-md-6 form-password-toggle">
                <label class="form-label" for="confirmPassword"><?= lang('Auth.change_password_new_password_confirm_label'); ?></label>
                <div class="input-group input-group-merge">
                    <input class="form-control" type="password" name="new_confirm" id="new_confirm" placeholder="Enter <?= lang('Auth.change_password_new_password_confirm_label'); ?>" />
                    <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                </div>
            </div>

            <div>
                <button type="submit" name="submit" class="btn btn-primary me-2"><?= lang('Auth.change_password_heading'); ?></button>
                <button type="reset" name="clear" class="btn btn-label-secondary clear">Clear</button>

            </div>
        </div>
        <?php echo form_close(); ?>
    </div>
</div>
<!--/ Change Password -->

<script>
    $(document).ready(function() {
        $(".clear").click(function() {
            $("form#form_change_password .validation-error-label").html('');
        })
        // Initialize
        var validator = $("#form_change_password").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },

            // Different components require proper error label placement
            errorPlacement: function(error, element) {

                // Styled checkboxes, radios, bootstrap switch
                if (element.parents('div').hasClass("checker") || element.parents('div').hasClass("choice") || element.parent().hasClass('bootstrap-switch-container')) {
                    if (element.parents('label').hasClass('checkbox-inline') || element.parents('label').hasClass('radio-inline')) {
                        error.appendTo(element.parent().parent().parent().parent());
                    } else {
                        error.appendTo(element.parent().parent().parent().parent().parent());
                    }
                }

                // Unstyled checkboxes, radios
                else if (element.parents('div').hasClass('checkbox') || element.parents('div').hasClass('radio')) {
                    error.appendTo(element.parent().parent().parent());
                }

                // Input with icons and Select2
                else if (element.parents('div').hasClass('has-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Inline checkboxes, radios
                else if (element.parents('label').hasClass('checkbox-inline') || element.parents('label').hasClass('radio-inline')) {
                    error.appendTo(element.parent().parent());
                }

                // Input group, styled file input
                else if (element.parent().hasClass('uploader') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                } else {
                    error.insertAfter(element);
                }
            },
            validClass: "validation-valid-label",
            success: function(label) {
                label.addClass("validation-valid-label").text("Success.")
            },
            rules: {
                old: {
                    required: true,
                    remote: {
                        url: "<?php echo admin_url("Auth/checkOldPassword"); ?>",
                        type: "post",
                        data: {
                            old: function() {
                                return $("#old").val();
                            }
                        }
                    }

                },

                new: {
                    required: true,
                    remote: {
                        url: "<?php echo admin_url("Auth/newPasswordNotSameAsOldPassword"); ?>",
                        type: "post",
                        data: {
                            new: function() {
                                return $("#new").val();
                            },
                            id: function() {
                                return $("#user_id").val();
                            }
                        }
                    },
                    minlength: '<?php echo $minPasswordLength ?>',
                    maxlength: '<?php echo $maxPasswordLength;?>'
                },
                new_confirm: {
                    required: true,
                    equalTo: "#new"
                }
            },
            messages: {
                old: {
                    required: "<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Auth.change_password_validation_old_password_label"); ?>",
                    remote: "<?= lang("Auth.change_password_validation_old_password_label"); ?> <?= lang("Auth.is_wrong"); ?>"

                },
                new: {
                    required: "<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Auth.change_password_validation_new_password_label"); ?>",
                    remote: "<?= lang("Auth.change_password_validation_new_password_label"); ?> and <?= lang("Auth.change_password_validation_old_password_label"); ?> Can't Be Same"
                },
                new_confirm: {
                    required: "<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Auth.change_password_validation_new_password_confirm_label"); ?>",
                    equalTo: "<?= lang("Auth.change_password_validation_new_password_label"); ?> and <?= lang("Auth.change_password_validation_new_password_confirm_label"); ?> must be same"
                }

            },
            submitHandler: function(e) {
                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("Auth/change_password");?>',
                    type: 'post',
                    beforeSubmit: function(formData, jqForm, options) {
                        //$(e).find('button').hide();
                        //$('#loader').show();
                    },
                    complete: function() {
                        //$('#loader').hide();
                        //(e).find('button').show();
                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function(resObj, statusText) {
                        if (resObj.success) {
                            Swal.fire({
                                title: 'Success',
                                text: resObj.msg,
                                icon: 'success',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                                window.location.href = '<?php echo admin_url('Auth/logout');?>';
                            });
                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: resObj.msg,
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                                window.location.href = '<?php echo admin_url('Auth/change_password');?>';
                            });
                        }
                    }
                });
            }
        });

    });
</script>