<?php
$html = '';
if (isset($amenities_unit_data) && !empty($amenities_unit_data)) {
	foreach ($amenities_unit_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["amenities_unit_data"] = $value;
		$html .= view('Admin/Amenities/AmenitiesUnitRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="amenities_unit_table" class="table table-bordered">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('Amenities.unit_name'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($amenities_unit_data) && !empty($amenities_unit_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/Amenities/AmenitiesUnitRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addAmenitiesUnit() {
		var lastIndex = ($("#amenities_unit_table tbody tr:last").length >= 1) ? $("#amenities_unit_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('Amenities/addAmenitiesUnitRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#amenities_unit_table tbody').append(data);
					addSerialNumber('amenities_unit_table');
                    amenitiesUnit();
					customToolTip();
                    unitPriceStore();
				}
			}
		});
	}

	var deleteId = [];
	$(document).on('click', '.dt-delete-unit-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".amenities_unit_id").val();
		var amenitiesId = $("#amenities_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					deleteId.push(id);
					$("#delete_amenities_unit_id").val(deleteId);
                    $(trField).remove();
                    addSerialNumber('amenities_unit_table');
                    if ($('#amenities_unit_table tbody > tr').length == 0) {
                        addAmenitiesUnit();
						updateUnitNames();
                        unitPriceStore();
                    }
                    unitPriceStore();
					// $.ajax({
					// 	type: "POST",
					// 	url: "<?php echo admin_url('Amenities/deleteAmenitiesUnitRow');?>",
					// 	dataType: "json",
					// 	async:false,
					// 	data: {
                    //         amenities_unit_id: deleteId,
                    //         amenities_id: amenitiesId
					// 	},
					// 	success: function (resObj) {
					// 		if (resObj.success) {
					// 			$(trField).remove();
					// 			addSerialNumber('amenities_unit_table');
					// 			Swal.fire({
					// 				title: 'Success',
					// 				text: resObj['msg'],
					// 				icon: 'success',
					// 				customClass: {
					// 					confirmButton: 'btn btn-primary waves-effect waves-light'
					// 				},
					// 				buttonsStyling: false
					// 			}).then(function() {
					// 				if ($('#amenities_unit_table tbody > tr').length == 0) {
                    //                     addAmenitiesUnit();
					// 					updateUnitNames();
                    //                     unitPriceStore();
					// 				}
                    //                 unitPriceStore();
					// 			});

					// 		} else {
					// 			Swal.fire({
					// 				title: 'Error!',
					// 				text: resObj['msg'],
					// 				icon: 'error',
					// 				customClass: {
					// 					confirmButton: 'btn btn-primary waves-effect waves-light'
					// 				},
					// 				buttonsStyling: false
					// 			});
                    //             unitPriceStore();
					// 		}
					// 	}
					// });
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('amenities_unit_table');
			if ($('#amenities_unit_table tbody > tr').length == 0) {
                addAmenitiesUnit();
				updateUnitNames();
			}
            unitPriceStore();
		}
	});
</script>