<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$rowNumber = isset($row_number) ? $row_number : 0;
$amenities_unit_data = isset($amenities_unit_data) ? $amenities_unit_data : array();
$amenitiesUnitId = isset($amenities_unit_data['amenities_unit_id']) ? $amenities_unit_data['amenities_unit_id'] : array();

// Generate a default unit name based on the row number if not set
$defaultUnitName = "Unit-" . ($rowNumber);  // Adding 1 because row number might be 0-indexed
$unitName = isset($amenities_unit_data['unit_name']) ? $amenities_unit_data['unit_name'] : $defaultUnitName;
?>
<tr data-id="tr_<?= $rowNumber; ?>">
	<td scope="row" class="dt-serial_number"></td>
	<td>
		<input type="hidden" id="amenities_unit_id_<?= $rowNumber; ?>"  name="amenities_unit_id[<?= $rowNumber; ?>]" class="amenities_unit_id" value="<?= isset($amenities_unit_data['amenities_unit_id']) ? $amenities_unit_data['amenities_unit_id'] : ""; ?>">

        <input type="text" name="unit_name[<?= $rowNumber;?>]" id="unit_name_<?= $rowNumber;?>" class="form-control dt-unit-name dt-serial_number" placeholder="Enter <?= lang('Amenities.unit_name'); ?>"  value="<?= $unitName ?>" />
	</td>
	
	<td>
        <?php if (!empty($amenitiesUnitId)) { ?>
            <?php if ($dtCIAcl->checkAccess('Amenities|deleteItem')) { ?>
                <button type="button"
                        class="rounded-pill waves-effect btn btn-sm btn-icon btn-danger dt-delete-unit-row"
                        data-bs-toggle="tooltip"
                        data-bs-placement="top" title="<?= lang('Amenities.delete_unit') ?>">
                    <i class="ti ti-trash"></i>
                </button>
            <?php } ?>
        <?php } else { ?>
            <button type="button" class=" rounded-pill waves-effect btn btn-sm btn-icon btn-danger dt-delete-unit-row"
                    data-bs-toggle="tooltip"
                    data-bs-placement="top" title="<?= lang('Amenities.delete_unit') ?>">
                <i class="ti ti-trash"></i>
            </button>
        <?php } ?>
    </td>

</tr>

