<?php
$assets = base_url() . 'assets/';
$amcData = !empty($amc_data) && is_array($amc_data) ? $amc_data : array();
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $name; ?></title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
          type="text/css">

    <link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
    <link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">

</head>

<body style='font-family:chelvetica;font-size: 9px'>
<div class="row">
    <div class="col-xs-12">
        <h3 style="color: red;text-align: center;"><?= lang('AMC.amc_detail'); ?></h3>
        <table class="table" width="100%" cellspacing="0" cellpadding="0" border="1">
            <tr>
                <td style="vertical-align : middle" colspan="7" rowspan="2">
                    <center><strong>DUE DATES</strong></center>
                </td>
                <td style="vertical-align : middle" colspan="2">
                    <center><strong><?php
                            if (isset($society_data['society_name']) && $society_data['society_name'] != '') {
                                echo $society_data['society_name'];
                            } ?></strong></center>
                </td>
            </tr>
            <tr>
                <td>
                    <center><strong>YEAR</strong>
                        <center>
                </td>
                <td><?= isset($financial_year_data["financial_year_prefix"]) ? $financial_year_data["financial_year_prefix"] : ""; ?></td>
            </tr>
            <?php if (isset($amc_data) && !empty($amc_data)) {
                foreach ($amc_data as $amcKey => $amcValue) { ?>
                    <tr>
                        <td style="vertical-align : middle" colspan="9">
                            <center><strong><?= underscoreToUcWord($amcKey); ?></strong></center>
                        </td>
                    </tr>
                    <tr>
                        <td rowspan="2" style="vertical-align : middle">
                            <center><strong>SN</strong></center>
                        </td>
                        <td rowspan="2" style="vertical-align : middle">
                            <center><strong>FACILITIES</strong></center>
                        </td>
                        <td rowspan="2" style="vertical-align : middle">
                            <center><strong>DESCRIPTION</strong></center>
                        </td>
                        <td rowspan="2" style="vertical-align : middle">
                            <center><strong> <?= lang('AMC.company_person'); ?></strong></center>
                        </td>
                        <td rowspan="2" style="vertical-align : middle">
                            <center><strong> <?= lang('AMC.contact'); ?></strong></center>
                        </td>
                        <td rowspan="2" style="vertical-align : middle">
                            <center><strong>PLACE</strong></center>
                        </td>
                        <td colspan="2" style="vertical-align : middle">
                            <center><strong>PERIOD</strong></center>
                        </td>
                        <td rowspan="2" style="vertical-align : middle;text-align: right;">
                            <strong>AMOUNT</strong>
                        </td>
                    </tr>
                    <tr>
                        <td style="vertical-align : middle">
                            <center><strong>FROM</strong></center>
                        </td>
                        <td style="vertical-align : middle">
                            <center><strong>UPTO</strong></center>
                        </td>
                    </tr>

                    <?php
                    if (is_array($amcValue) && !empty($amcValue)) {
                        foreach ($amcValue as $amcValueKey => $amcValueElement) {
                            ?>
                            <tr>
                                <td> <center><?= ++$amcValueKey; ?> </center></td>
                                <td>
                                    <center><?= isset($amcValueElement['amenities_name']) ? $amcValueElement['amenities_name'] : ''; ?></center>
                                </td>
                                <td>
                                    <center><?= isset($amcValueElement['particular']) ? $amcValueElement['particular'] : ''; ?></center>
                                </td>
                                <td>
                                    <center> <?= isset($amcValueElement['vendor_name']) ? $amcValueElement['vendor_name'] : ''; ?></center>
                                </td>
                                <td>
                                    <center> <?= isset($amcValueElement['vendor_mobile_no']) ? $amcValueElement['vendor_mobile_no'] : ''; ?></center>
                                </td>
                                <td>
                                    <center><?= isset($amcValueElement['place']) ? $amcValueElement['place'] : ''; ?></center>
                                </td>
                                <td>
                                    <center><?= isset($amcValueElement['period_from']) ? YMDToDMY($amcValueElement['period_from']) : ''; ?></center>
                                </td>
                                <td>
                                    <center><?= isset($amcValueElement['period_upto']) ? YMDToDMY($amcValueElement['period_upto']) : ''; ?></center>
                                </td>
                                <td style="text-align: right"><?= isset($amcValueElement['amount']) ? roundNumber($amcValueElement['amount'], 2) : ''; ?></td>
                            </tr>
                            <?php
                        }
                    } else {
                        echo "<tr><td colspan='9' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
                    } ?>
                <?php } ?>
            <?php } ?>
        </table>


    </div>
</div>
</body>
</html>
