<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class WarrantyModel extends BaseModel
{

    public function getWarrantyData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_warranty as tw');
        $builder->select("tw.*,COALESCE(tm.manufacturer_name,'') as manufacturer_name,COALESCE(ti.item_name,'') as item_name,COALESCE(tv.vendor_name,'') as vendor_name,GROUP_CONCAT(tvm.vendor_person_name SEPARATOR ',') as vendor_person_name,GROUP_CONCAT(tvm.vendor_designation SEPARATOR ',') as vendor_designation");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join("tbl_manufacturer as tm","tm.manufacturer_id = tw.manufacturer_id","left");
        $builder->join("tbl_item as ti","ti.item_id = tw.item_id","left");
        $builder->join("tbl_vendor as tv","tv.vendor_id = tw.vendor_id","left");
        $builder->join("tbl_vendor_mobile as tvm","tvm.vendor_id = tw.vendor_id","left");
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tw.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tw.created_by","left");

        if (isset($filterData['warranty_id']) && !empty($filterData['warranty_id'])) {
            if (is_array($filterData['warranty_id'])) {
                $builder->whereIn('tw.warranty_id', $filterData['warranty_id']);
            } else {
                $builder->where('tw.warranty_id', $filterData['warranty_id']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tw.society_id', $filterData['society_id']);
            } else {
                $builder->where('tw.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tw.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        $builder->groupBy('tw.warranty_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($warrantyId)
    {

        $warrantyIdArray = is_array($warrantyId) ? $warrantyId : array($warrantyId);
        $builder = $this->db->table('tbl_warranty_vendor_contact');
        $builder->whereIn('warranty_id', $warrantyIdArray);
        $builder->delete();

        $builder = $this->db->table('tbl_warranty');
        $builder->whereIn('warranty_id', $warrantyIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($warrantyId)){
                foreach($warrantyId as $warranty){
                    $deleteDataArray['module'] = 'Warranty';
                    $deleteDataArray['activity'] = "Warranty Deleted";
                    $deleteDataArray['module_id'] = $warranty;
                    logActivity('Warranty Deleted [WarrantyID: ' . $warranty . ']',$this->ionAuth->getUserId(),'Warranty',$warranty,json_encode($deleteDataArray),'','Warranty',$warranty);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteWarrantyVendorContactRecord($warranty)
    {
        $builder = $this->db->table('tbl_warranty_vendor_contact');
        $warrantyArray = is_array($warranty) ? $warranty : array($warranty);
        $builder->whereIn('warranty_id',$warrantyArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }

    }

    function getWarrantyVendorContactData($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        //$this->db->start_cache();
        $builder = $this->db->table('tbl_warranty_vendor_contact as twvm');
        $builder->select("twvm.*");

        if(isset($filterData['warranty_id']) && !empty($filterData['warranty_id'])) {
            if (is_array($filterData['warranty_id'])) {
                $builder->whereIn('twvm.warranty_id', $filterData['warranty_id']);
            } else {
                $builder->where('twvm.warranty_id', $filterData['warranty_id']);
            }
        }
        //$this->db->stop_cache();
        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }
}