<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class VisitModel extends BaseModel
{

    public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}

    public function getVisitData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_visit as tvi');

		$builder->select("tvi.*");
		$builder->select("COALESCE(ts.society_name,'') as society_name");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->select("COALESCE(tad.amc_type,'') as amc_type,tad.period_from,tad.period_upto");
		$builder->select("COALESCE(tad.particular,'') as particular");
		$builder->select("COALESCE(tv.vendor_name,'') as service_provider");
		// $builder->select("GROUP_CONCAT(distinct(tvm.vendor_mobile_no) SEPARATOR ',') as vendor_mobile_no");
		
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tvi.society_id","left");
		$builder->join("tbl_amc_detail as tad","tad.amc_id = tvi.amc_id","left");
		$builder->join("tbl_vendor as tv","tv.vendor_id = tvi.vendor_id","left");
		// $builder->join("tbl_vendor_mobile as tvm","tvm.vendor_id = tv.vendor_id","left");
		$builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tvi.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tvi.created_by","left");

		if (isset($filterData['visit_id']) && !empty($filterData['visit_id'])) {
			if (is_array($filterData['visit_id'])) {
				$builder->whereIn('tvi.visit_id', $filterData['visit_id']);
			} else {
				$builder->where('tvi.visit_id', $filterData['visit_id']);
			}
		}

		// if (isset($filterData['financial_year_id']) && !empty($filterData['financial_year_id'])) {
		// 	if (is_array($filterData['financial_year_id'])) {
		// 		$builder->whereIn('tad.financial_year_id', $filterData['financial_year_id']);
		// 	} else {
		// 		$builder->where('tad.financial_year_id', $filterData['financial_year_id']);
		// 	}
		// }

		if (isset($filterData['start'])) {
			if ($filterData['start'] != '1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			//$builder->like('member_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tvi.is_active', $filterData['is_active']);
		}
		accessFilter($builder, array("society" => "tvi.society_id"));

		$builder->groupBy('tvi.visit_id');

		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

    public function deleteRecord($visitId)
	{
		$builder = $this->db->table('tbl_visit');
        $visitIdArray = is_array($visitId) ? $visitId : array($visitId);
        $builder->whereIn('visit_id', $visitIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($visitId)){
				foreach($visitId as $documentElement){
					$deleteDataArray['module'] = 'Visit';
					$deleteDataArray['activity'] = "Visit Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('visit Deleted [VisitID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Visit',$documentElement,json_encode($deleteDataArray),'','Visit',$documentElement);
				}
			}
			return true;
		}
		return false;
	}

    function getVisit($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		// $this->db->start_cache();
		$builder = $this->db->table('tbl_visit as tvi');
		$builder->select("tvi.visit_id as id,tvi.visit_type as text");
		$builder->where("tvi.is_active", 1);
		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tvi.visit_type", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}
		accessFilter($builder, array("society" => "tvi.society_id"));
		// $builder->stop_cache();
		$totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
		// $builder->flush_cache();
		return json_encode($result);
	}

}