<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class TowerModel extends BaseModel
{

    public function getTowerData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_tower as tt');
        $builder->select("tt.*");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tt.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tt.created_by","left");

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tt.society_id', $filterData['society_id']);
            } else {
                $builder->where('tt.society_id', $filterData['society_id']);
            }
        }
        if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
            if (is_array($filterData['tower_id'])) {
                $builder->whereIn('tt.tower_id', $filterData['tower_id']);
            } else {
                $builder->where('tt.tower_id', $filterData['tower_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tt.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('tower_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }
        
        $builder->orderBy('tt.tower_name', 'ASC'); // or 'DESC'

        $builder->groupBy('tt.tower_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($towerId)
    {
        $towerIdArray = is_array($towerId) ? $towerId : array($towerId);
        $builder = $this->db->table('tbl_tower_unit');
        $builder->whereIn('tower_id', $towerIdArray);
        $builder->delete();

        $builder = $this->db->table('tbl_tower');     
        $builder->whereIn('tower_id', $towerIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {

            if(!empty($towerId)){
                foreach($towerId as $tower){
                    $deleteDataArray['module'] = 'Tower';
                    $deleteDataArray['activity'] = "Tower Deleted";
                    $deleteDataArray['module_id'] = $tower;
                    logActivity('Tower Deleted [TowerID: ' . $tower . ']',$this->ionAuth->getUserId(),'Tower',$tower,json_encode($deleteDataArray),'','Tower',$tower);
                }
            }

            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getTower($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_tower as tt');
        //$builder->startCache();
        $builder->select("tt.tower_id as id,COALESCE(tt.tower_name,'') as text,tt.society_id,ts.society_name");
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tt.society_id","left");
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tt.society_id', $filterData['society_id']);
            } else {
                $builder->where('tt.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
            if (is_array($filterData['tower_id'])) {
                $builder->whereIn('tt.tower_id', $filterData['tower_id']);
            } else {
                $builder->where('tt.tower_id', $filterData['tower_id']);
            }
        }

        accessFilter($builder, array("society" => "tt.society_id"));
        $builder->groupBy("tt.tower_id");
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tt.tower_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tt.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);
        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        // printArray($result,1);
        return json_encode($result);
    }

    public function deleteTowerUnitRecord($towerUnitId)
    {
        $builder = $this->db->table('tbl_tower_unit');
        $towerUnitIdArray = is_array($towerUnitId) ? $towerUnitId : array($towerUnitId);
        $builder->whereIn('tower_unit_id',$towerUnitIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }


    public function deleteTowerUnit($towerId)
    {
        $builder = $this->db->table('tbl_tower_unit');
        $towerIdArray = is_array($towerId) ? $towerId : array($towerId);
        $builder->whereIn('tower_id',$towerIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function getTowerUnitData($filterData)
    {
        $builder = $this->db->table('tbl_tower_unit as ttu');
        $builder->select("ttu.*,tt.*");
        $builder->join("tbl_tower as tt","tt.tower_id = ttu.tower_id","left");
        $builder->groupBy("ttu.tower_unit_id");

        if(isset($filterData['tower_unit_id']) && !empty($filterData['tower_unit_id'])) {
            if (is_array($filterData['tower_unit_id'])) {
                $builder->whereIn('ttu.tower_unit_id', $filterData['tower_unit_id']);
            } else {
                $builder->where('ttu.tower_unit_id', $filterData['tower_unit_id']);
            }
        }

        if(isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
            if (is_array($filterData['tower_id'])) {
                $builder->whereIn('ttu.tower_id', $filterData['tower_id']);
            } else {
                $builder->where('ttu.tower_id', $filterData['tower_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tt.society_id', $filterData['society_id']);
            } else {
                $builder->where('tt.society_id', $filterData['society_id']);
            }
        }

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    function getTowerUnit($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_tower_unit as ttu');
        //$builder->startCache();
        $builder->select("ttu.tower_unit_id as id,COALESCE(ttu.unit_group,'') as text,ttu.bhk,ttu.sqr_ft,ttu.carpet_area");

        if(isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
            if (is_array($filterData['tower_id'])) {
                $builder->whereIn('ttu.tower_id', $filterData['tower_id']);
            } else {
                $builder->where('ttu.tower_id', $filterData['tower_id']);
            }
        }
        else{
            $builder->where('ttu.tower_id', -9);
        }

        if (isset($filterData['tower_unit_id']) && !empty($filterData['tower_unit_id'])) {
            if (is_array($filterData['tower_unit_id'])) {
                $builder->whereIn('ttu.tower_unit_id', $filterData['tower_unit_id']);
            } else {
                $builder->where('ttu.tower_unit_id', $filterData['tower_unit_id']);
            }
        }

        // accessFilter($builder, array("society" => "ttu.society_id"));

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(ttu.unit_group,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        // printArray($result,1);
        return json_encode($result);
    }

    public function updateTowerId($filterData = array())
    {
        $sql = "UPDATE tbl_tower_unit AS ttu
                LEFT JOIN tbl_tower AS tt
                ON tt.tower_slug = ttu.tower_slug
                SET ttu.tower_id = tt.tower_id
                WHERE ttu.tower_slug IS NOT NULL AND ttu.tower_slug != ''";

        $this->db->query($sql);
    }

    public function updateTowerUnitId($filterData = array())
    {
        $sql = "UPDATE tbl_flat AS tf
                LEFT JOIN tbl_tower_unit AS ttu
                ON tf.tower_unit_slug = ttu.tower_unit_slug
                SET tf.tower_id = ttu.tower_id,
                    tf.floor_id = ttu.tower_unit_id
                WHERE tf.tower_unit_slug IS NOT NULL AND tf.tower_unit_slug != ''";

        $this->db->query($sql);
    }

}