<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class TaxModel extends BaseModel
{

    public function getTaxData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_tax as tt');
        $builder->select("tt.*");

        if (isset($filterData['tax_id']) && !empty($filterData['tax_id'])) {
            if (is_array($filterData['tax_id'])) {
                $builder->whereIn('tt.tax_id', $filterData['tax_id']);
            } else {
                $builder->where('tt.tax_id', $filterData['tax_id']);
            }
        }

        if (isset($filterData['tax_rate']) && !empty($filterData['tax_rate'])) {
            if (is_array($filterData['tax_rate'])) {
                $builder->whereIn('tt.tax_rate', $filterData['tax_rate']);
            } else {
                $builder->where('tt.tax_rate', $filterData['tax_rate']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tt.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('tax_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tt.tax_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($taxId)
    {
        $builder = $this->db->table('tbl_tax');
        $taxIdArray = is_array($taxId) ? $taxId : array($taxId);
        $builder->whereIn('tax_id', $taxIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {

            if(!empty($taxId)){
                foreach($taxId as $tax){
                    $deleteDataArray['module'] = 'Tax';
                    $deleteDataArray['activity'] = "Tax Deleted";
                    $deleteDataArray['module_id'] = $tax;
                    logActivity('Tax Deleted [TaxID: ' . $tax . ']',$this->ionAuth->getUserId(),'Tax',$tax,json_encode($deleteDataArray),'','Tax',$tax);
                }
            }

            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getTax($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_tax as tt');
        //$builder->startCache();
        $builder->select("tt.tax_id as id,COALESCE(tt.tax_name,'') as text,tt.tax_rate,tt.tax_name");

        if (isset($filterData['tax_id']) && !empty($filterData['tax_id'])) {
            if (is_array($filterData['tax_id'])) {
                $builder->whereIn('tt.tax_id', $filterData['tax_id']);
            } else {
                $builder->where('tt.tax_id', $filterData['tax_id']);
            }
        }
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tt.tax_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tt.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}