<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ShareFeeReceivedModel extends BaseModel
{

    public function getShareFeeReceivedData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_share_fee_received as tsc');
        $builder->select('tsc.*');

        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->select("tf.flat_no");
        $builder->select("tba.*");
        $builder->select("tb.*");
        $builder->join("tbl_flat as tf","tf.flat_id = tsc.flat_id","left");
        $builder->join("tbl_bank_account as tba","tba.bank_account_id = tsc.bank_account_id","left");
        $builder->join("tbl_bank as tb","tb.bank_id = tba.bank_id","left");
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tsc.society_id","left"); 
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tsc.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tsc.created_by","left");

        if(isset($filterData['id']) && !empty($filterData['id'])) {
            if (is_array($filterData['id'])) {
                $builder->whereIn('tsc.id', $filterData['id']);
            } else {
                $builder->where('tsc.id', $filterData['id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        $builder->groupBy('tsc.id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function deleteRecord($ShareFeeReceivedId)
    {
        $ShareFeeReceivedIdArray = is_array($ShareFeeReceivedId) ? $ShareFeeReceivedId : array($ShareFeeReceivedId);

        $builder = $this->db->table('tbl_share_fee_received');
        $builder->whereIn('id', $ShareFeeReceivedIdArray);
        $builder->delete();

        if ($this->db->affectedRows()) {
            if(!empty($ShareFeeReceivedId)){
                foreach($ShareFeeReceivedId as $ShareFeeReceived){
                    $deleteDataArray['module'] = 'ShareFeeReceived';
                    $deleteDataArray['activity'] = "ShareFeeReceived Deleted";
                    $deleteDataArray['module_id'] = $ShareFeeReceived;
                    logActivity('ShareFeeReceived Deleted [ShareFeeReceivedID: ' . $ShareFeeReceived . ']',$this->ionAuth->getUserId(),'ShareFeeReceived',$ShareFeeReceived,json_encode($deleteDataArray),'','ShareFeeReceived',$ShareFeeReceived);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getSociety($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_society as ts');
        //$builder->startCache();
        $builder->select("ts.society_id as id,COALESCE(ts.society_name,'') as text");

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ts.society_id', $filterData['society_id']);
            } else {
                $builder->where('ts.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(ts.society_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('ts.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function deleteShareFeeReceivedImage($ShareFeeReceivedImageId)
    {
        $builder = $this->db->table('tbl_share_certificate_image');
        $ShareFeeReceivedImageIdArray = is_array($ShareFeeReceivedImageId) ? $ShareFeeReceivedImageId : array($ShareFeeReceivedImageId);
        $builder->whereIn('share_certificate_image_id', $ShareFeeReceivedImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}