<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ShareCertificateModel extends BaseModel
{

    public function getShareCertificateData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_share_certificate as tsc');
        $builder->select('tsc.*');

        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->select("tf.flat_no");
        $builder->select("ts.*");
        $builder->join("tbl_flat as tf","tf.flat_id = tsc.flat_id","left"); 
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tsc.society_id","left"); 
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tsc.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tsc.created_by","left");

        if(isset($filterData['share_certificate_id']) && !empty($filterData['share_certificate_id'])) {
            if (is_array($filterData['share_certificate_id'])) {
                $builder->whereIn('tsc.id', $filterData['share_certificate_id']);
            } else {
                $builder->where('tsc.id', $filterData['share_certificate_id']);
            }
        }

        if(isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
            if (is_array($filterData['flat_id'])) {
                $builder->whereIn('tsc.flat_id', $filterData['flat_id']);
            } else {
                $builder->where('tsc.flat_id', $filterData['flat_id']);
            }
        }

        if(isset($filterData['share_certificate_id_not']) && !empty($filterData['share_certificate_id_not'])) {
            if (is_array($filterData['share_certificate_id_not'])) {
                $builder->whereNotIn('tsc.id', $filterData['share_certificate_id_not']);
            } else {
                $builder->where('tsc.id !=', $filterData['share_certificate_id_not']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        // if(isset($filterData['search']) && $filterData['search'] != ''){
        //     $builder->groupStart();
        //     $builder->like('share_certificate_name', $filterData['search'], 'both');
        //     $builder->groupEnd();
        // }

        $builder->groupBy('tsc.id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function deleteRecord($shareCertificateId)
    {
        $shareCertificateIdArray = is_array($shareCertificateId) ? $shareCertificateId : array($shareCertificateId);

        $builder = $this->db->table('tbl_share_certificate');
        $builder->whereIn('id', $shareCertificateIdArray);
        $builder->delete();

        if ($this->db->affectedRows()) {
            if(!empty($shareCertificateId)){
                foreach($shareCertificateId as $shareCertificate){
                    $deleteDataArray['module'] = 'ShareCertificate';
                    $deleteDataArray['activity'] = "ShareCertificate Deleted";
                    $deleteDataArray['module_id'] = $shareCertificate;
                    logActivity('ShareCertificate Deleted [ShareCertificateID: ' . $shareCertificate . ']',$this->ionAuth->getUserId(),'ShareCertificate',$shareCertificate,json_encode($deleteDataArray),'','ShareCertificate',$shareCertificate);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getSociety($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_society as ts');
        //$builder->startCache();
        $builder->select("ts.society_id as id,COALESCE(ts.society_name,'') as text");

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ts.society_id', $filterData['society_id']);
            } else {
                $builder->where('ts.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(ts.society_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('ts.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function deleteShareCertificateImage($shareCertificateImageId)
    {
        $builder = $this->db->table('tbl_share_certificate_image');
        $shareCertificateImageIdArray = is_array($shareCertificateImageId) ? $shareCertificateImageId : array($shareCertificateImageId);
        $builder->whereIn('share_certificate_image_id', $shareCertificateImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}