<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ServiceModel extends BaseModel
{

	public function getServiceData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_service as tser');
		$builder->select("tser.*,ts.society_name,tv.vendor_name,ti.item_name");

		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tser.society_id","left");
		$builder->join("tbl_vendor as tv","tv.vendor_id = tser.vendor_id","left");
		$builder->join("tbl_item as ti","ti.item_id = tser.item_id","left");
		if (isset($filterData['service_id']) && !empty($filterData['service_id'])) {
			if (is_array($filterData['service_id'])) {
				$builder->whereIn('tser.service_id', $filterData['service_id']);
			} else {
				$builder->where('tser.service_id', $filterData['service_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tser.is_active', $filterData['is_active']);
		}
		$builder->groupBy('tser.service_id');
		accessFilter($builder, array("society" => "tser.society_id"));
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $$builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecord($serviceId)
	{
		$builder = $this->db->table('tbl_service');
		$serviceIdArray = is_array($serviceId) ? $serviceId : array($serviceId);
		$builder->whereIn('service_id', $serviceIdArray);
		$builder->delete();

		if ($this->db->affectedRows()) {
			if(!empty($serviceId)){
				foreach($serviceId as $service){
					$deleteDataArray['module'] = 'Service';
            		$deleteDataArray['activity'] = "Service Deleted";
					$deleteDataArray['module_id'] = $service;
					logActivity('Service Deleted [ServiceID: ' . $service . ']',$this->ionAuth->getUserId(),'Service',$service,json_encode($deleteDataArray),'','Service',$service);
				}
			}
			$response['success'] = true;
			return $response;
		} else {
            $response['success'] = false;
            return $response;
        }
	}
}
?>
