<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class OrganicWasteRecordModel extends BaseModel
{

	public function getOrganicWasteRecordData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_organic_waste_record as towr');
        $builder->select("towr.*,tsoc.society_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = towr.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = towr.created_by","left");
        $builder->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = towr.society_id","left");


        if (isset($filterData['organic_waste_record_id']) && !empty($filterData['organic_waste_record_id'])) {
            if (is_array($filterData['organic_waste_record_id'])) {
                $builder->whereIn('towr.organic_waste_record_id', $filterData['organic_waste_record_id']);
            } else {
                $builder->where('towr.organic_waste_record_id', $filterData['organic_waste_record_id']);
            }
        }
        if (isset($filterData['organic_waste_record_id_not']) && !empty($filterData['organic_waste_record_id_not'])) {
            if (is_array($filterData['organic_waste_record_id_not'])) {
                $builder->whereNotIn('towr.organic_waste_record_id', $filterData['organic_waste_record_id_not']);
            } else {
                $builder->where('towr.organic_waste_record_id !=', $filterData['organic_waste_record_id_not']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('towr.society_id', $filterData['society_id']);
            } else {
                $builder->where('towr.society_id', $filterData['society_id']);
            }
        }
        if (isset($filterData['record_date']) && !empty($filterData['record_date'])) {
            if (is_array($filterData['record_date'])) {
                $builder->whereIn('towr.record_date', $filterData['record_date']);
            } else {
                $builder->where('towr.record_date', $filterData['record_date']);
            }
        }

        // if(isset($filterData['start_date']) && $filterData['start_date'] != $filterData['end_date']){
			if (isset($filterData['start_date']) && !empty($filterData['start_date'])) {
				if (is_array($filterData['start_date'])) {
					$builder->whereIn('towr.record_date  >=', $filterData['start_date']);
				} else {
					$builder->where('towr.record_date  >=', $filterData['start_date']);
					$builder->where('towr.record_date  <=', $filterData['end_date']);
				}
			}
		// }

        if (isset($filterData['start'])) {
            if ($filterData['start'] != '1') {
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        // if(isset($filterData['search']) && $filterData['search'] != ''){
        //     $builder->groupStart();
        //     $builder->like('towr.staff_name', $filterData['search'], 'both');
        //     $builder->groupEnd();
        // }
        $builder->orderBy('towr.organic_waste_record_id','DESC');
        $builder->groupBy('towr.organic_waste_record_id');
        if(!isset($filterData['is_api_call'])){
			accessFilter($builder, array("society" => "towr.society_id"));
		}
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
	

	public function deleteRecord($organivWasteRecordId)
    {
        $organivWasteRecordIdArray = is_array($organivWasteRecordId) ? $organivWasteRecordId : array($organivWasteRecordId);
        $builder = $this->db->table('tbl_organic_waste_record');
        $builder->whereIn('organic_waste_record_id', $organivWasteRecordIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($organivWasteRecordId)){
                foreach($organivWasteRecordId as $documentElement){
                    $deleteDataArray['module'] = 'OrganicWasteRecord';
                    $deleteDataArray['activity'] = "OrganicWasteRecord Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('OrganicWasteRecord Deleted [OrganicWasteRecordID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'OrganicWasteRecord',$documentElement,json_encode($deleteDataArray),'','OrganicWasteRecord',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}
?>
