<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class NoticeModel extends BaseModel
{

	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getNoticeData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$ownershipFlatMemberId = isset($filterData['ownership_flat_member_id']) ? $filterData['ownership_flat_member_id'] : 0;
		$builder = $this->db->table('tbl_notice as tn');
        $builder->select("tn.*");
        
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tn.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tn.created_by","left");

        if (isset($filterData['is_bookmark']) && !empty($filterData['is_bookmark'])) {
        	$builder->join("tbl_bookmark as tb","tb.type = 'notice' AND tb.type_id = tn.notice_id AND tb.ownership_flat_member_id = '". $ownershipFlatMemberId ."'","left");
        	$builder->where('tb.bookmark_id IS NOT NULL');
        }
		if (isset($filterData['notice_id']) && !empty($filterData['notice_id'])) {
			if (is_array($filterData['notice_id'])) {
				$builder->whereIn('tn.notice_id', $filterData['notice_id']);
			} else {
				$builder->where('tn.notice_id', $filterData['notice_id']);
			}
		}
		if (isset($filterData['category_id']) && !empty($filterData['category_id'])) {
			if (is_array($filterData['category_id'])) {
				$builder->whereIn('tnc.category_id', $filterData['category_id']);
			} else {
				$builder->where('tnc.category_id', $filterData['category_id']);
			}
		}
		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tn.society_id', $filterData['society_id']);
			} else {
				$builder->where('tn.society_id', $filterData['society_id']);
			}
		}

		if (isset($filterData['is_check_expiry_date'])) {
			$builder->where("tn.expiry_date >= '".($filterData['is_check_expiry_date'])."'", NULL, FALSE);
		}

		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('notice_title', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		$builder->orderBy("tn.notice_id",'desc');
		$builder->groupBy('tn.notice_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		//lastQuery();
		return $queryData;
	}

	public function getBookmarkData($filterData = array())
	{
		$builder = $this->db->table('tbl_bookmark as tnb');
        $builder->select("tnb.*");
		if (isset($filterData['type_id']) && !empty($filterData['type_id'])) {
			if (is_array($filterData['type_id'])) {
				$builder->whereIn('tnb.type_id', $filterData['type_id']);
			} else {
				$builder->where('tnb.type_id', $filterData['type_id']);
			}
		}

		if (isset($filterData['bookmark_id']) && !empty($filterData['bookmark_id'])) {
			if (is_array($filterData['bookmark_id'])) {
				$builder->whereIn('tnb.bookmark_id', $filterData['bookmark_id']);
			} else {
				$builder->where('tnb.bookmark_id', $filterData['bookmark_id']);
			}
		}

		if (isset($filterData['type']) && !empty($filterData['type'])) {
			if (is_array($filterData['type'])) {
				$builder->whereIn('tnb.type', $filterData['type']);
			} else {
				$builder->where('tnb.type', $filterData['type']);
			}
		}
		if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
			if (is_array($filterData['ownership_flat_member_id'])) {
				$builder->whereIn('tnb.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			} else {
				$builder->where('tnb.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
			}
		}
		$builder->groupBy('tnb.bookmark_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function getNoticeCategoryData($filterData = array())
	{
		$builder = $this->db->table('tbl_notice_category as tnc');
        $builder->select("tnc.*,tc.category_name");
        $builder->join("tbl_category as tc","tc.category_id = tnc.category_id","left");
		if (isset($filterData['notice_id']) && !empty($filterData['notice_id'])) {
			if (is_array($filterData['notice_id'])) {
				$builder->whereIn('tnc.notice_id', $filterData['notice_id']);
			} else {
				$builder->where('tnc.notice_id', $filterData['notice_id']);
			}
		}
		$builder->groupBy('tnc.notice_category_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteNoticeCategoryRecord($noticeId){
        $builder = $this->db->table('tbl_notice_category');
        $noticeIdArray = is_array($noticeId) ? $noticeId : array($noticeId);
        $builder->whereIn('notice_id', $noticeIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
	public function getNoticeTowerData($filterData = array())
	{
		$builder = $this->db->table('tbl_notice_tower as tnt');
        $builder->select("tnt.*,tt.tower_name");
        $builder->join("tbl_tower as tt","tt.tower_id = tnt.tower_id","left");
		if (isset($filterData['notice_id']) && !empty($filterData['notice_id'])) {
			if (is_array($filterData['notice_id'])) {
				$builder->whereIn('tnt.notice_id', $filterData['notice_id']);
			} else {
				$builder->where('tnt.notice_id', $filterData['notice_id']);
			}
		}
		$builder->groupBy('tnt.notice_tower_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteNoticeTowerRecord($noticeId){
        $builder = $this->db->table('tbl_notice_tower');
        $noticeIdArray = is_array($noticeId) ? $noticeId : array($noticeId);
        $builder->whereIn('notice_id', $noticeIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
	public function getNoticeFlatData($filterData = array())
	{
		$builder = $this->db->table('tbl_notice_flat as tnf');
        $builder->select("tnf.*,concat(tt.tower_name,' - ',tf.flat_no) as flat_no");
        $builder->join("tbl_ownership_flat as tof","tof.flat_id = tnf.flat_id","left");
        $builder->join("tbl_flat as tf","tf.flat_id = tnf.flat_id","left");
        $builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		if (isset($filterData['notice_id']) && !empty($filterData['notice_id'])) {
			if (is_array($filterData['notice_id'])) {
				$builder->whereIn('tnf.notice_id', $filterData['notice_id']);
			} else {
				$builder->where('tnf.notice_id', $filterData['notice_id']);
			}
		}
		$builder->groupBy('tnf.notice_flat_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteNoticeFlatRecord($noticeId){
        $builder = $this->db->table('tbl_notice_flat');
        $noticeIdArray = is_array($noticeId) ? $noticeId : array($noticeId);
        $builder->whereIn('notice_id', $noticeIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	public function deleteBookmarkRecord($bookmarkId)
    {
        $bookmarkIdArray = is_array($bookmarkId) ? $bookmarkId : array($bookmarkId);
        $builder = $this->db->table('tbl_bookmark');
        $builder->whereIn('bookmark_id',$bookmarkIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }

    }
	
	public function deleteRecord($noticeId)
    {
        $noticeIdArray = is_array($noticeId) ? $noticeId : array($noticeId);
        $builder = $this->db->table('tbl_notice');
        $builder->whereIn('notice_id', $noticeIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($noticeId)){
                foreach($noticeId as $documentElement){
                    $deleteDataArray['module'] = 'Notice';
                    $deleteDataArray['activity'] = "Notice Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Notice Deleted [NoticeID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Notice',$documentElement,json_encode($deleteDataArray),'','Notice',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
	function getNotice($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_notice as tn');
        //$builder->startCache();
        $builder->select("tn.notice_id as id,tn.notice_title as text");

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tn.society_id', $filterData['society_id']);
            } else {
                $builder->where('tn.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['notice_id']) && !empty($filterData['notice_id'])) {
            if (is_array($filterData['notice_id'])) {
                $builder->whereIn('tn.notice_id', $filterData['notice_id']);
            } else {
                $builder->where('tn.notice_id', $filterData['notice_id']);
            }
        }

        accessFilter($builder, array("society" => "tn.society_id"));
        $builder->groupBy("tn.notice_id");
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("tn.notice_title", $filterData['filter_param'], 'both');
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tn.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        // $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        // $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}
?>
