<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ManagementCommitteeResponsibilitiesModel extends BaseModel
{

    public function getManagementCommitteeResponsibilitiesData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_management_committee_responsibilities as tm');
        $builder->select("tm.*");

        if(isset($filterData['management_committee_responsibilities_id']) && !empty($filterData['management_committee_responsibilities_id'])) {
            if (is_array($filterData['management_committee_responsibilities_id'])) {
                $builder->whereIn('tm.management_committee_responsibilities_id', $filterData['management_committee_responsibilities_id']);
            } else {
                $builder->where('tm.management_committee_responsibilities_id', $filterData['management_committee_responsibilities_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tm.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('management_committee_responsibilities_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tm.management_committee_responsibilities_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($managementCommitteeResponsibilitiesId)
    {
        $builder = $this->db->table('tbl_management_committee_responsibilities');
        $managementCommitteeResponsibilitiesIdArray = is_array($managementCommitteeResponsibilitiesId) ? $managementCommitteeResponsibilitiesId : array($managementCommitteeResponsibilitiesId);
        $builder->whereIn('management_committee_responsibilities_id', $managementCommitteeResponsibilitiesIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($managementCommitteeResponsibilitiesId)){
                foreach($managementCommitteeResponsibilitiesId as $managementCommitteeResponsibilities){
                    $deleteDataArray['module'] = 'ManagementCommitteeResponsibilities';
                    $deleteDataArray['activity'] = "ManagementCommitteeResponsibilities Deleted";
                    $deleteDataArray['module_id'] = $managementCommitteeResponsibilities;
                    logActivity('ManagementCommitteeResponsibilities Deleted [ManagementCommitteeResponsibilitiesID: ' . $managementCommitteeResponsibilities . ']',$this->ionAuth->getUserId(),'ManagementCommitteeResponsibilities',$managementCommitteeResponsibilities,json_encode($deleteDataArray),'','ManagementCommitteeResponsibilities',$managementCommitteeResponsibilities);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getManagementCommitteeResponsibilities($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_management_committee_responsibilities as tm');
        //$builder->startCache();
        $builder->select("tm.management_committee_responsibilities_id as id,COALESCE(tm.management_committee_responsibilities_name,'') as text");

        if(isset($filterData['management_committee_responsibilities_id']) && !empty($filterData['management_committee_responsibilities_id'])) {
            if (is_array($filterData['management_committee_responsibilities_id'])) {
                $builder->whereIn('tm.management_committee_responsibilities_id', $filterData['management_committee_responsibilities_id']);
            } else {
                $builder->where('tm.management_committee_responsibilities_id', $filterData['management_committee_responsibilities_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tm.society_id', $filterData['society_id']);
            } else {
                $builder->where('tm.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tm.management_committee_responsibilities_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tm.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResultm(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}