<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class MaintenanceCalculationModel extends BaseModel
{

    public function getMaintenanceCalculationData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_maintenance as tm');
        $builder->select("tm.*");

        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tm.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tm.created_by","left");


        if(isset($filterData['id']) && !empty($filterData['id'])) {
            if (is_array($filterData['id'])) {
                $builder->whereIn('tm.id', $filterData['id']);
            } else {
                $builder->where('tm.id', $filterData['id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tm.society_id', $filterData['society_id']);
            } else {
                $builder->where('tm.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }


        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        // if(isset($filterData['search']) && $filterData['search'] != ''){
        //     $builder->groupStart();
        //     $builder->like('ti.prefix', $filterData['search'], 'both');
        //     $builder->orLike('ti.series', $filterData['search'], 'both');
        //     $builder->groupEnd();
        // }

        $builder->groupBy('tm.id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getMaintenanceCalculationFlatData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_maintenance_flat as tmf');
        $builder->select("tmf.*");
        $builder->select("tf.*");
        $builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
        $builder->join("tbl_maintenance as tm", "tm.id = tmf.maintenance_id", "left");
        $builder->join("tbl_flat as tf", "tf.flat_id = tmf.flat_id", "left");
        $builder->join("tbl_tower as tt", "tt.tower_id = tf.tower_id", "left");

        $builder->join("society_user_master_view as tupdate", "tupdate.user_society_id = tmf.updated_by", "left");
        $builder->join("society_user_master_view as tcreate", "tcreate.user_society_id = tmf.created_by", "left");


        if (isset($filterData['maintenance_id']) && !empty($filterData['maintenance_id'])) {
            if (is_array($filterData['maintenance_id'])) {
                $builder->whereIn('tmf.maintenance_id', $filterData['maintenance_id']);
            } else {
                $builder->where('tmf.maintenance_id', $filterData['maintenance_id']);
            }
        }

        // if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
        //     if (is_array($filterData['society_id'])) {
        //         $builder->whereIn('tm.society_id', $filterData['society_id']);
        //     } else {
        //         $builder->where('tm.society_id', $filterData['society_id']);
        //     }
        // }

        if (isset($filterData['start'])) {
            if ($filterData['start'] != '-1') {
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }


        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey, $orderValue);
                    }
                }
            }
        }

        // if(isset($filterData['search']) && $filterData['search'] != ''){
        //     $builder->groupStart();
        //     $builder->like('ti.prefix', $filterData['search'], 'both');
        //     $builder->orLike('ti.series', $filterData['search'], 'both');
        //     $builder->groupEnd();
        // }

        // $builder->groupBy('tm.id');
        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getMaintenanceCalculationParticularData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_invoice_particular as tip');
        $builder->select("tip.*,tt.tax_name,tt.tax_rate,tt.tax_id");
        $builder->join("tbl_invoice_particular_tax as tipt","tipt.invoice_particular_id = tip.invoice_particular_id","left");
        $builder->join("tbl_tax as tt","tt.tax_id = tipt.tax_id","left");

        if(isset($filterData['invoice_id']) && !empty($filterData['invoice_id'])) {
            if (is_array($filterData['invoice_id'])) {
                $builder->whereIn('tip.invoice_id', $filterData['invoice_id']);
            } else {
                $builder->where('tip.invoice_id', $filterData['invoice_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            // $builder->like('ti.prefix', $filterData['search'], 'both');
            // $builder->orLike('ti.series', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        // $builder->groupBy('ti.invoice_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getMaintenanceCalculationParticularTaxData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_invoice_particular_tax as tip');
        $builder->select("tip.*,tt.tax_name,tt.tax_rate");

        $builder->join("tbl_tax as tt","tt.tax_id = tip.tax_id","left");
        if(isset($filterData['invoice_id']) && !empty($filterData['invoice_id'])) {
            if (is_array($filterData['invoice_id'])) {
                $builder->whereIn('tip.invoice_id', $filterData['invoice_id']);
            } else {
                $builder->where('tip.invoice_id', $filterData['invoice_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            // $builder->like('ti.prefix', $filterData['search'], 'both');
            // $builder->orLike('ti.series', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        // $builder->groupBy('ti.invoice_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function deleteRecord($calculationId)
    {
        $builder = $this->db->table('tbl_maintenance');
        $calculationIdArray = is_array($calculationId) ? $calculationId : array($calculationId);
        $builder->whereIn('id', $calculationIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($calculationId)){
                foreach($calculationId as $calculation){
                    $deleteDataArray['module'] = 'MaintenanceCalculation';
                    $deleteDataArray['activity'] = "MaintenanceCalculation Deleted";
                    $deleteDataArray['module_id'] = $calculation;
                    logActivity('MaintenanceCalculation Deleted [AmenitiesID: ' . $calculation . ']',$this->ionAuth->getUserId(),'MaintenanceCalculation',$calculation,json_encode($deleteDataArray),'','MaintenanceCalculation',$calculation);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteParticularTaXId($maintenanceId)
    {
        $builder = $this->db->table('tbl_maintenance_flat');
        $maintenanceIdArray = is_array($maintenanceId) ? $maintenanceId : array($maintenanceId);
        $builder->whereIn('maintenance_id', $maintenanceIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            // if(!empty($maintenanceId)){
            //     foreach($maintenanceId as $invoice){
            //         $deleteDataArray['module'] = 'Maintenance Calculation flat';
            //         $deleteDataArray['activity'] = "Maintenance Calculation Deleted";
            //         $deleteDataArray['module_id'] = $invoice;
            //         logActivity('MaintenanceCalculation Deleted [AmenitiesID: ' . $invoice . ']',$this->ionAuth->getUserId(),'MaintenanceCalculation',$invoice,json_encode($deleteDataArray),'','MaintenanceCalculation',$invoice);
            //     }
            // }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteMultipleParticularId($maintenanceId)
    {
        $builder = $this->db->table('tbl_maintenance_flat');
        $maintenanceIdArray = is_array($maintenanceId) ? $maintenanceId : array($maintenanceId);
        $builder->whereIn('maintenance_id', $maintenanceIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($maintenanceId)){
                foreach($maintenanceId as $invoice){
                    $deleteDataArray['module'] = 'Maintenance Calculation';
                    $deleteDataArray['activity'] = "Maintenance Calculation Deleted";
                    $deleteDataArray['module_id'] = $invoice;
                    logActivity('MaintenanceCalculation Deleted [AmenitiesID: ' . $invoice . ']',$this->ionAuth->getUserId(),'MaintenanceCalculation',$invoice,json_encode($deleteDataArray),'','MaintenanceCalculation',$invoice);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }


}