<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class KeyIssueModel extends BaseModel
{
	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getKeyIssueData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_key_issue as tki');
        $builder->select("tki.*,ts.society_name,tck.description,tcka.keys_name");
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tki.society_id","left");
		$builder->join("tbl_common_keys as tck","tck.common_keys_id = tki.common_keys_id","left");
		$builder->join("tbl_common_keys_availability as tcka","tcka.common_keys_availability_id = tki.common_keys_availability_id","left");
		if (isset($filterData['key_issue_id']) && !empty($filterData['key_issue_id'])) {
			if (is_array($filterData['key_issue_id'])) {
				$builder->whereIn('tki.key_issue_id', $filterData['key_issue_id']);
			} else {
				$builder->where('tki.key_issue_id', $filterData['key_issue_id']);
			}
		}

		if (isset($filterData['common_keys_id']) && !empty($filterData['common_keys_id'])) {
			if (is_array($filterData['common_keys_id'])) {
				$builder->whereIn('tki.common_keys_id', $filterData['common_keys_id']);
			} else {
				$builder->where('tki.common_keys_id', $filterData['common_keys_id']);
			}
		}

		if (isset($filterData['common_keys_availability_id']) && !empty($filterData['common_keys_availability_id'])) {
			if (is_array($filterData['common_keys_availability_id'])) {
				$builder->whereIn('tki.common_keys_availability_id', $filterData['common_keys_availability_id']);
			} else {
				$builder->where('tki.common_keys_availability_id', $filterData['common_keys_availability_id']);
			}
		}

		if (isset($filterData['start'])) {
			if ($filterData['start'] != '1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('ts.society_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tki.is_active', $filterData['is_active']);
		}
		$builder->groupBy('tki.key_issue_id');
		accessFilter($builder, array("society" => "tki.society_id"));
		if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
		return $queryData;
	}

	public function deleteRecord($keyIssueId)
	{
		$builder = $this->db->table('tbl_key_issue');
        $keyIssueIdArray = is_array($keyIssueId) ? $keyIssueId : array($keyIssueId);
        $builder->whereIn('key_issue_id', $keyIssueIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($keyIssueId)){
				foreach($keyIssueId as $keyIssue){
					$deleteDataArray['module'] = 'Key Issue';
            		$deleteDataArray['activity'] = "Key Issue Deleted";
					$deleteDataArray['module_id'] = $keyIssue;
					logActivity('Key Issue Deleted [keyIssueID: ' . $keyIssue . ']',$this->ionAuth->getUserId(),'Key Issue',$keyIssue,json_encode($deleteDataArray),'','Key Issue',$keyIssue);
				}
			}
			return true;
		}
		return false;
	}
}
?>
