<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class InvoiceModel extends BaseModel
{

    public function getInvoiceData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_invoice as ti');
        $builder->select("ti.*");
        $builder->select("tb.bank_name");
        $builder->select("CONCAT(COALESCE(tb.bank_name,''),'-',COALESCE(tba.bank_account_no,'')) as bank_account_no");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");

        // $builder->join("tbl_ownership_flat as towf","towf.ownership_flat_id = ti.ownership_flat_id","left");
        $builder->join("tbl_flat as tf","tf.flat_id = ti.ownership_flat_id","left");
        $builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
        $builder->join("tbl_bank_account as tba","tba.bank_account_id = ti.bank_account_id","left");
        $builder->join("tbl_bank as tb","tb.bank_id = tba.bank_id","left");


        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = ti.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = ti.created_by","left");


        if(isset($filterData['invoice_id']) && !empty($filterData['invoice_id'])) {
            if (is_array($filterData['invoice_id'])) {
                $builder->whereIn('ti.invoice_id', $filterData['invoice_id']);
            } else {
                $builder->where('ti.invoice_id', $filterData['invoice_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ti.society_id', $filterData['society_id']);
            } else {
                $builder->where('ti.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }


        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('ti.prefix', $filterData['search'], 'both');
            $builder->orLike('ti.series', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('ti.invoice_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getInvoiceParticularData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_invoice_particular as tip');
        $builder->select("tip.*,tt.tax_name,tt.tax_rate,tt.tax_id");
        $builder->join("tbl_invoice_particular_tax as tipt","tipt.invoice_particular_id = tip.invoice_particular_id","left");
        $builder->join("tbl_tax as tt","tt.tax_id = tipt.tax_id","left");

        if(isset($filterData['invoice_id']) && !empty($filterData['invoice_id'])) {
            if (is_array($filterData['invoice_id'])) {
                $builder->whereIn('tip.invoice_id', $filterData['invoice_id']);
            } else {
                $builder->where('tip.invoice_id', $filterData['invoice_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            // $builder->like('ti.prefix', $filterData['search'], 'both');
            // $builder->orLike('ti.series', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        // $builder->groupBy('ti.invoice_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getInvoiceParticularTaxData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_invoice_particular_tax as tip');
        $builder->select("tip.*,tt.tax_name,tt.tax_rate");

        $builder->join("tbl_tax as tt","tt.tax_id = tip.tax_id","left");
        if(isset($filterData['invoice_id']) && !empty($filterData['invoice_id'])) {
            if (is_array($filterData['invoice_id'])) {
                $builder->whereIn('tip.invoice_id', $filterData['invoice_id']);
            } else {
                $builder->where('tip.invoice_id', $filterData['invoice_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            // $builder->like('ti.prefix', $filterData['search'], 'both');
            // $builder->orLike('ti.series', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        // $builder->groupBy('ti.invoice_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function deleteRecord($invoiceId)
    {
        $builder = $this->db->table('tbl_invoice');
        $invoiceIdArray = is_array($invoiceId) ? $invoiceId : array($invoiceId);
        $builder->whereIn('invoice_id', $invoiceIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($invoiceId)){
                foreach($invoiceId as $invoice){
                    $deleteDataArray['module'] = 'Invoice';
                    $deleteDataArray['activity'] = "Invoice Deleted";
                    $deleteDataArray['module_id'] = $invoice;
                    logActivity('Invoice Deleted [AmenitiesID: ' . $invoice . ']',$this->ionAuth->getUserId(),'Invoice',$invoice,json_encode($deleteDataArray),'','Invoice',$invoice);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteParticularTaXId($invoiceId)
    {
        $builder = $this->db->table('tbl_invoice_particular_tax');
        $invoiceIdArray = is_array($invoiceId) ? $invoiceId : array($invoiceId);
        $builder->whereIn('invoice_id', $invoiceIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($invoiceIdArray)){
                foreach($invoiceIdArray as $invoice){
                    $deleteDataArray['module'] = 'Invoice';
                    $deleteDataArray['activity'] = "Invoice Deleted";
                    $deleteDataArray['module_id'] = $invoice;
                    logActivity('Invoice Deleted [AmenitiesID: ' . $invoice . ']',$this->ionAuth->getUserId(),'Invoice',$invoice,json_encode($deleteDataArray),'','Invoice',$invoice);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }


}