<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class InvestmentsModel extends BaseModel
{

    public function getInvestmentsData($filterData = array())
    {
    	$limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_investments as ti');

        $builder->select("ti.*,tb.bank_name,tfy.financial_year_prefix");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		
		$builder->join("tbl_bank as tb","tb.bank_id = ti.bank_id","left");
		$builder->join("society_user_master_view as tupdate","tupdate.user_society_id = ti.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = ti.created_by","left");
		$builder->join("tbl_financial_year as tfy","tfy.financial_year_id = ti.financial_year_id","left");
		if (isset($filterData['investments_id']) && !empty($filterData['investments_id'])) {
			if (is_array($filterData['investments_id'])) {
				$builder->whereIn('ti.investments_id', $filterData['investments_id']);
			} else {
				$builder->where('ti.investments_id', $filterData['investments_id']);
			}
		}
		if (isset($filterData['financial_year_id']) && !empty($filterData['financial_year_id'])) {
			if (is_array($filterData['financial_year_id'])) {
				$builder->whereIn('ti.financial_year_id', $filterData['financial_year_id']);
			} else {
				$builder->where('ti.financial_year_id', $filterData['financial_year_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('investments_type', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('ti.is_active', $filterData['is_active']);
		}
		accessFilter($builder, array("society" => "ti.society_id"));

		$builder->groupBy('ti.investments_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
    }


    public function deleteRecord($investmentsId)
    {
        $builder = $this->db->table('tbl_investments');
        $investmentsIdArray = is_array($investmentsId) ? $investmentsId : array($investmentsId);
        $builder->whereIn('investments_id', $investmentsIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($investmentsId)){
                foreach($investmentsId as $documentElement){
                    $deleteDataArray['module'] = 'Investments';
                    $deleteDataArray['activity'] = "Investments Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Investments Deleted [InvestmentsID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Investments',$documentElement,json_encode($deleteDataArray),'','Investments',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getFinancialYear($filterData = array())
	{
		if(isset($filterData['page']) && $filterData['page'] != 1) {
			$filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
		}

		// $this->db->start_cache();
        $builder = $this->db->table('tbl_financial_year as tfy');
		$builder->select("tfy.financial_year_id as id,tfy.financial_year_prefix as text");
		$builder->where("tfy.is_active", 1);
		if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
			$builder->groupStart();
			$builder->like("tfy.financial_year_prefix", $filterData['filter_param'], 'both');
			$builder->groupEnd();
		}
		// $this->db->stop_cache();
		$totalRows = $builder->countAllResults(false);
		$builder->limit($filterData['limit'], $filterData['start']);
		$query = $builder->get();
		$result['result'] = $query->getResultArray();
		$result['totalRows'] = $totalRows;
		$result['page'] = $filterData['page'];
		// $builder->flush_cache();
		return json_encode($result);
	}

}