<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class GeneratorReadingModel extends BaseModel
{
	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getGeneratorReadingData($filterData = array())
	{
		$limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_generator_reading as tgr');
        $builder->select("tgr.*,ts.society_name,COALESCE(tg.generator_name,'') as generator_name");
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tgr.society_id","left");
		$builder->join("tbl_generator as tg","tg.generator_id = tgr.generator_id","left");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tgr.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tgr.created_by","left");
	
		if (isset($filterData['generator_reading_id']) && !empty($filterData['generator_reading_id'])) {
			if (is_array($filterData['generator_reading_id'])) {
				$builder->whereIn('tgr.generator_reading_id', $filterData['generator_reading_id']);
			} else {
				$builder->where('tgr.generator_reading_id', $filterData['generator_reading_id']);
			}
		}

		if (isset($filterData['generator_id']) && !empty($filterData['generator_id'])) {
			if (is_array($filterData['generator_id'])) {
				$builder->whereIn('tgr.generator_id', $filterData['generator_id']);
			} else {
				$builder->where('tgr.generator_id', $filterData['generator_id']);
			}
		}

		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tgr.society_id', $filterData['society_id']);
			} else {
				$builder->where('tgr.society_id', $filterData['society_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('ts.society_name', $filterData['search'], 'both');
			$builder->orLike('COALESCE(tg.generator_name,"")', $filterData['search'], 'both');
			$builder->groupEnd();
		}

		$builder->orderBy('tgr.generator_reading_id','DESC');
		$builder->groupBy('tgr.generator_reading_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecord($generatorReadingId,$userId = 0,$societyId = 0)
	{
		$builder = $this->db->table('tbl_generator_reading');
        $generatorReadingIdArray = is_array($generatorReadingId) ? $generatorReadingId : array($generatorReadingId);
        $builder->whereIn('generator_reading_id', $generatorReadingIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($generatorReadingId)){
				foreach($generatorReadingId as $generatorReading){
					$deleteDataArray['module'] = 'Generator Reading';
            		$deleteDataArray['activity'] = "Generator Reading Deleted";
					$deleteDataArray['module_id'] = $generatorReading;
					$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
					logActivity('Generator Reading Deleted [GeneratorReadingID: ' . $generatorReading . ']',$userId,'Generator Reading',$generatorReading,json_encode($deleteDataArray),'','Generator Reading',$generatorReading);
				}
			}
			return true;
		}
		return false;
	}
}
?>
