<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;

class ForumModel extends BaseModel{

    public function getForumData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_forum as tf');
        $builder->select("tf.*,tm.member_id");
        $builder->select("(CASE WHEN tf.type = 'manager' THEN concat(COALESCE(tu.first_name,''),' ',COALESCE(tu.last_name,''))
                                    WHEN tf.type = 'member' THEN  COALESCE(tm.name, '') 
                                    END) as member_name,tf.type");

        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        
        $builder->join("tbl_ownership_flat_member as tofw","tofw.ownership_flat_member_id = tf.type_id AND tf.type = 'member'","left");
        $builder->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofw.member_id","left");
        $builder->join("society_user_master_view as tu","tu.id = tf.type_id  AND tf.type = 'manager'","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tf.created_by","left");
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tf.updated_by","left");
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tf.society_id","left");
        $builder->where("tf.is_deleted",0);
        $builder->groupBy("tf.forum_id");

        if(isset($filterData['forum_id']) && !empty($filterData['forum_id'])) {
            if (is_array($filterData['forum_id'])) {
                $builder->whereIn('tf.forum_id', $filterData['forum_id']);
            } else {
                $builder->where('tf.forum_id', $filterData['forum_id']);
            }
        }

        if(isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
            if (is_array($filterData['ownership_flat_member_id'])) {
                $builder->whereIn('tf.type_id', $filterData['ownership_flat_member_id']);
            } else {
                $builder->where('tf.type_id', $filterData['ownership_flat_member_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tf.society_id', $filterData['society_id']);
            } else {
                $builder->where('tf.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('forum_id', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
    
    public function deleteRecord($forumId,$userId)
	{
		$builder = $this->db->table('tbl_forum');
        $forumIdArray = is_array($forumId) ? $forumId : array($forumId);
        $builder->whereIn('forum_id', $forumIdArray);
        $data = [
			'is_deleted' => 1,
			'updated_at'  => date("Y-m-d H:i:s"),
			'updated_by'  => $userId,
		];
        $builder->update($data);
		if ($this->db->affectedRows()) {
			if(!empty($forumId)){
				foreach($forumId as $documentElement){
					$deleteDataArray['module'] = 'Forum';
					$deleteDataArray['activity'] = "Forum Deleted";
					$deleteDataArray['module_id'] = $documentElement;
					logActivity('Forum Deleted [ForumID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Forum',$documentElement,json_encode($deleteDataArray),'','Forum',$documentElement);
				}
			}
			return true;
		}
		return false;
	}

    public function deleteForumCommentRecord($filterData = array())
    {
        $builder = $this->db->table('tbl_comment');
        $typeIdArray = is_array($filterData['type_id']) ? $filterData['type_id'] : array($filterData['type_id']);
        $builder->where('type',$filterData['type']);
        $builder->whereIn('type_id',$typeIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	public function deleteForumImage($forumImageId)
    {
        $builder = $this->db->table('tbl_forum_image');
        $forumImageIdArray = is_array($forumImageId) ? $forumImageId : array($forumImageId);
        $builder->whereIn('forum_image_id', $forumImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getForum($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_forum as tf');
        //$builder->startCache();
        $builder->select("tf.forum_id as id,COALESCE(tf.title,'') as text");

        if(isset($filterData['forum_id']) && !empty($filterData['forum_id'])) {
            if (is_array($filterData['forum_id'])) {
                $builder->whereIn('tf.forum_id', $filterData['forum_id']);
            } else {
                $builder->where('tf.forum_id', $filterData['forum_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tf.society_id', $filterData['society_id']);
            } else {
                $builder->where('tf.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tf.title,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tf.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResultf(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

}