<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class FlatModel extends BaseModel
{

    public function getFlatData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_flat as tf');
        $builder->select("tf.*,tt.tower_name,concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name");
        $builder->select("concat(tt.tower_name,'|',tf.flat_no) as clubbed_tower_flat_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->select("COALESCE(ttu.unit_group,'') as floor,ttu.unit");
        $builder->join("tbl_tower_unit as ttu","ttu.tower_unit_id = tf.floor_id","left");
        $builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tf.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tf.created_by","left");
        if (isset($filterData['is_flat']) && $filterData['is_flat'] == 1) {
            $builder->where("tf.flat_id NOT IN (SELECT flat_id FROM tbl_ownership_flat)");
            $builder->where("tf.flat_id NOT IN (SELECT flat_id FROM tbl_parking_slot)");
            $builder->orderBy("tf.flat_id",'DESC');
        }

        if (isset($filterData['is_flat_assign']) && $filterData['is_flat_assign'] == 1) {
            $builder->groupStart();
            $builder->where("tf.flat_id NOT IN (SELECT flat_id FROM tbl_ownership_flat)");
            $builder->orWhere("tf.flat_id NOT IN (SELECT flat_id FROM tbl_parking_slot)");
            $builder->orWhere("tf.flat_id NOT IN (SELECT flat_id FROM tbl_booking)");
            $builder->orWhere("tf.flat_id NOT IN (SELECT flat_id FROM tbl_complain)");
            $builder->orWhere("tf.flat_id NOT IN (SELECT flat_id FROM tbl_intercom)");
            $builder->orWhere("tf.flat_id NOT IN (SELECT flat_id FROM tbl_management_committee)");
            $builder->orWhere("tf.flat_id NOT IN (SELECT flat_id FROM tbl_notice_flat)");
            $builder->orWhere("tf.flat_id NOT IN (SELECT flat_id FROM tbl_tag_assign)");
            $builder->orWhere("tf.flat_id NOT IN (SELECT flat_id FROM tbl_resource_flat)");
            $builder->orWhere("tf.flat_id NOT IN (SELECT flat_id FROM tbl_rentals)");
            $builder->groupEnd();
            $builder->orderBy("tf.flat_id",'DESC');
        }

        if (isset($filterData['flat_id']) && !empty($filterData['flat_id'])) {
            if (is_array($filterData['flat_id'])) {
                $builder->whereIn('tf.flat_id', $filterData['flat_id']);
            } else {
                $builder->where('tf.flat_id', $filterData['flat_id']);
            }
        }
        if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
            if (is_array($filterData['tower_id'])) {
                $builder->whereIn('tf.tower_id', $filterData['tower_id']);
            } else {
                $builder->where('tf.tower_id', $filterData['tower_id']);
            }
        }
        if (isset($filterData['tower_unit_id']) && !empty($filterData['tower_unit_id'])) {
            if (is_array($filterData['tower_unit_id'])) {
                $builder->whereIn('tf.floor_id', $filterData['tower_unit_id']);
            } else {
                $builder->where('tf.floor_id', $filterData['tower_unit_id']);
            }
        }
        if (isset($filterData['floor_id']) && !empty($filterData['floor_id'])) {
            if (is_array($filterData['floor_id'])) {
                $builder->whereIn('tf.floor_id', $filterData['floor_id']);
            } else {
                $builder->where('tf.floor_id', $filterData['floor_id']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tf.society_id', $filterData['society_id']);
            } else {
                $builder->where('tf.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tf.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->like('flat_no', $filterData['search'], 'both');
            $builder->orLike('concat(tt.tower_name," - ",tf.flat_no)', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tf.flat_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($flatId)
    {
        $builder = $this->db->table('tbl_flat');
        $flatIdArray = is_array($flatId) ? $flatId : array($flatId);
        $builder->whereIn('flat_id', $flatIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($flatId)){
                foreach($flatId as $flat){
                    $deleteDataArray['module'] = 'Flat';
                    $deleteDataArray['activity'] = "Flat Deleted";
                    $deleteDataArray['module_id'] = $flat;
                    logActivity('Flat Deleted [FlatID: ' . $flat . ']',$this->ionAuth->getUserId(),'Flat',$flat,json_encode($deleteDataArray),'','Flat',$flat);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function getTotalFlatDetails($filterData = array()){
        $builder = $this->db->table('tbl_flat as tf');
        $builder->select("COUNT(*) as total_flats, SUM(carpet_area) as total_carpet_area, SUM(sqr_ft) as total_sqr_ft");
        // $builder->where('society_id', $this->session->get('society_id'));

        $summary = $builder->get()->getRowArray();

        return [
            'total_flats'       => (int) ($summary['total_flats'] ?? 0),
            'total_carpet_area' => (float) ($summary['total_carpet_area'] ?? 0),
            'total_sqr_ft'      => (float) ($summary['total_sqr_ft'] ?? 0),
        ];
    }

    function getFlat($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_flat as tf');
        //$builder->startCache();
        $builder->select("tf.flat_id as id,concat(tt.tower_name,' - ',tf.flat_no) as text,tf.*");
        $builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");

        if(isset($filterData['is_ownership_flat']) && $filterData['is_ownership_flat'] == 1) {
            if (isset($filterData['ownership_flat_id']) && !empty($filterData['ownership_flat_id'])) {
                $builder->where('tf.flat_id NOT IN(SELECT tof.flat_id  FROM tbl_ownership_flat as tof WHERE tof.is_delete = 0 AND tof.ownership_flat_id !="' . $filterData['ownership_flat_id'] . '" )', null, false);
            } else {
                $builder->where('tf.flat_id NOT IN(SELECT tof.flat_id  FROM tbl_ownership_flat as tof WHERE tof.is_delete = 0)', null, false);
            }
        }


        if(isset($filterData['is_intercom_flat']) && $filterData['is_intercom_flat'] == 1) {
            if(isset($filterData['intercom_id']) && !empty($filterData['intercom_id'])) {
                $builder->where('tf.flat_id NOT IN(SELECT ti.flat_id  FROM tbl_intercom as ti WHERE ti.intercom_type="flat" AND ti.intercom_id !="'.$filterData['intercom_id'].'" )',null,false);
            } else {
                $builder->where('tf.flat_id NOT IN(SELECT ti.flat_id  FROM tbl_intercom as ti  WHERE ti.intercom_type="flat")',null,false);
            }
        }

        if(isset($filterData['is_rental_flat']) && $filterData['is_rental_flat'] == 1) {
            if(isset($filterData['rental_id']) && !empty($filterData['rental_id'])) {
                $builder->where('tf.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr WHERE tr.rental_id !="'.$filterData['rental_id'].'" )',null,false);
            } else {
                $builder->groupStart();
                $builder->where('tf.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr)',null,false);
                //$this->db->or_where('(tf.flat_id IN(SELECT tr.flat_id  FROM tbl_rentals as tr where rent_agreement_period_to < "'.TODAY_DATE_YMD.'") OR (tf.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr where status_id != (SELECT tstatus.status_id  FROM tbl_status as tstatus where tstatus.is_close = 1))))',null,false);
                $builder->orWhere('(tf.flat_id IN(SELECT tr.flat_id  FROM tbl_rentals as tr where rent_agreement_period_from  >= "'.TODAY_DATE_YMD.'" AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) <= "'.TODAY_DATE_YMD.'"  ) OR (tf.flat_id NOT IN(SELECT tr.flat_id  FROM tbl_rentals as tr where status_id != (SELECT tstatus.status_id  FROM tbl_status as tstatus where tstatus.is_close = 1) AND rent_agreement_period_from  <= "'.TODAY_DATE_YMD.'" AND IF(rental_closing_date IS NULL,tr.rent_agreement_period_to,tr.rental_closing_date) >= "'.TODAY_DATE_YMD.'" )))',null,false);
                $builder->groupEnd();
            }
        }

        if (isset($filterData['tower_id']) && !empty($filterData['tower_id'])) {
            if (is_array($filterData['tower_id'])) {
                $builder->whereIn('tf.tower_id', $filterData['tower_id']);
            } else {
                $builder->where('tf.tower_id', $filterData['tower_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tf.society_id', $filterData['society_id']);
            } else {
                $builder->where('tf.society_id', $filterData['society_id']);
            }
        }

        accessFilter($builder, array("society" => "tf.society_id"));
        $builder->groupBy("tf.flat_id");
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("concat(tt.tower_name,' - ',tf.flat_no)", $filterData['filter_param'], 'both');
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tf.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function getUserData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table(MASTER_DB.'.tbl_users as tu');
        $builder->select("tu.*");

        if (isset($filterData['id']) && !empty($filterData['id'])) {
            if (is_array($filterData['id'])) {
                $builder->whereIn('tu.id', $filterData['id']);
            } else {
                $builder->where('tu.id', $filterData['id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['active'])){
            $builder->where('tu.active', $filterData['active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        // if (isset($filterData['search']) && $filterData['search'] != '') {
        //     $builder->groupStart();
        //     $builder->like('flat_no', $filterData['search'], 'both');
        //     $builder->orLike('concat(tt.tower_name," - ",tf.flat_no)', $filterData['search'], 'both');
        //     $builder->groupEnd();
        // }

        $builder->groupBy('tu.id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
}