<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class EventModel extends BaseModel
{

	public function getEventData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_event as te');
        $builder->select("te.*,tsoc.society_name,tca.common_area_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
       
       
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = te.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = te.created_by","left");
        $builder->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = te.society_id","left");
        $builder->join("tbl_common_area as tca","tca.common_area_id = te.common_area_id","left");
       
		
		


        // $builder->join("(SELECT tsi.event_image AS event_image,tsi.event_id  from tbl_event_image tsi  ORDER BY tsi.updated_at DESC) AS eventImage",  "eventImage.event_id = ts.event_id", "left");

        if (isset($filterData['event_id']) && !empty($filterData['event_id'])) {
            if (is_array($filterData['event_id'])) {
                $builder->whereIn('te.event_id', $filterData['event_id']);
            } else {
                $builder->where('te.event_id', $filterData['event_id']);
            }
        }
        
        if (isset($filterData['category_id']) && !empty($filterData['category_id'])) {
			if (is_array($filterData['category_id'])) {
				$builder->whereIn('tec.category_id', $filterData['category_id']);
			} else {
				$builder->where('tec.category_id', $filterData['category_id']);
			}
		}

        if (isset($filterData['date_greater_than_equal_to']) && !empty($filterData['date_greater_than_equal_to'])) {
            if (is_array($filterData['date_greater_than_equal_to'])) {
                $builder->whereIn('DATE(te.end_date)  >= ', $filterData['date_greater_than_equal_to']);
            } else {
                $builder->where('DATE(te.end_date)  >= ', $filterData['date_greater_than_equal_to']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('te.society_id', $filterData['society_id']);
            } else {
                $builder->where('te.society_id', $filterData['society_id']);
            }
        }
        if (isset($filterData['event_type']) && !empty($filterData['event_type'])) {
            if (is_array($filterData['event_type'])) {
                $builder->whereIn('te.event_type', $filterData['event_type']);
            } else {
                $builder->where('te.event_type', $filterData['event_type']);
            }
        }

        if (isset($filterData['start'])) {
            if ($filterData['start'] != '1') {
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
            $builder->where('te.is_active', $filterData['is_active']);
        }

        if(isset($filterData['form_submit']) && !empty($filterData['form_submit'])){
            $builder->where('te.form_submit', $filterData['form_submit']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('te.event_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->orderBy('te.event_id','DESC');
        $builder->groupBy('te.event_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
	

	public function deleteRecord($eventId)
    {
        $eventIdArray = is_array($eventId) ? $eventId : array($eventId);
        $builder = $this->db->table('tbl_event_image');
        $builder->whereIn('event_id', $eventIdArray);
        $builder->delete();
        $builder = $this->db->table('tbl_event');
        $builder->whereIn('event_id', $eventIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($eventId)){
                foreach($eventId as $documentElement){
                    $deleteDataArray['module'] = 'Event';
                    $deleteDataArray['activity'] = "Event Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Event Deleted [EventID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Event',$documentElement,json_encode($deleteDataArray),'','Event',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	function getEvent($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_event as te');
        //$builder->startCache();
        $builder->select("te.event_id as id,COALESCE(te.event_name,'')  as text");
        if(isset($filterData['event_id']) && !empty($filterData['event_id'])) {
            if (is_array($filterData['event_id'])) {
                $builder->whereIn('te.event_id', $filterData['event_id']);
            } else {
                $builder->where('te.event_id', $filterData['event_id']);
            }
        }
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('te.society_id', $filterData['society_id']);
            } else {
                $builder->where('te.society_id', $filterData['society_id']);
            }
        }
        if(isset($filterData['form_submit']) && !empty($filterData['form_submit'])) {
            if (is_array($filterData['form_submit'])) {
                $builder->whereIn('te.form_submit', $filterData['form_submit']);
            } else {
                $builder->where('te.form_submit', $filterData['form_submit']);
            }
        }
        
        if (isset($filterData['date_greater_than_equal_to']) && !empty($filterData['date_greater_than_equal_to'])) {
            if (is_array($filterData['date_greater_than_equal_to'])) {
                $builder->whereIn('DATE(te.end_date)  >= ', $filterData['date_greater_than_equal_to']);
            } else {
                $builder->where('DATE(te.end_date)  >= ', $filterData['date_greater_than_equal_to']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(te.event_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('te.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function getEventImageData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_event_image as tmi');
        $builder->select("tmi.event_image_id, tmi.event_image,tmi.event_id");
        $builder->join('tbl_event tm', 'tm.event_id = tmi.event_id', 'left');

        if(isset($filterData['event_id']) && !empty($filterData['event_id'])) {
            if (is_array($filterData['event_id'])) {
                $builder->whereIn('tmi.event_id', $filterData['event_id']);
            } else {
                $builder->where('tmi.event_id', $filterData['event_id']);
            }
        }

        if (isset($filterData['event_image_id']) && $filterData['event_image_id'] != '') {
            $builder->where("tmi.event_image_id", $filterData['event_image_id']);
        }

        // if (isset($filterData['is_order_by_event_id']) ) {
        //     $builder->orderBy("tmi.event_image_id","DESC");
        // } else {
        //     $builder->orderBy("tmi.event_id");
        // }

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
//lastQuery();
        return $query;
    }

    public function getEventBookingData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_event_booking as teb');
        $builder->select("teb.*,te.event_name,te.start_date as event_start_date,te.event_thumbnail_image,te.booking_type,te.event_name");
        $builder->select("te.is_guest_allowed");
        $builder->select("tm.name as member_name");
        $builder->join('tbl_event as te','te.event_id = teb.event_id','left');
        $builder->join('tbl_ownership_flat_member as tofm','tofm.ownership_flat_member_id = teb.ownership_flat_member_id', 'left');
        $builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
        $builder->join("tbl_event_category as tec","tec.event_id = te.event_id","left");

        if(isset($filterData['event_id']) && !empty($filterData['event_id'])) {
            if (is_array($filterData['event_id'])) {
                $builder->whereIn('teb.event_id', $filterData['event_id']);
            } else {
                $builder->where('teb.event_id', $filterData['event_id']);
            }
        }

        if (isset($filterData['category_id']) && !empty($filterData['category_id'])) {
            if (is_array($filterData['category_id'])) {
                $builder->whereIn('tec.category_id', $filterData['category_id']);
            } else {
                $builder->where('tec.category_id', $filterData['category_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('teb.society_id', $filterData['society_id']);
            } else {
                $builder->where('teb.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start_date']) && !empty($filterData['start_date'])) {
            if (is_array($filterData['start_date'])) {
                $builder->whereIn('teb.start_date', $filterData['start_date']);
            } else {
                $builder->where('teb.start_date', $filterData['start_date']);
            }
        }

        if(isset($filterData['end_date']) && !empty($filterData['end_date'])) {
            if (is_array($filterData['end_date'])) {
                $builder->whereIn('teb.end_date', $filterData['end_date']);
            } else {
                $builder->where('teb.end_date', $filterData['end_date']);
            }
        }

        if(isset($filterData['type']) && !empty($filterData['type'])) {
            if (is_array($filterData['type'])) {
                $builder->whereIn('teb.type', $filterData['type']);
            } else {
                $builder->where('teb.type', $filterData['type']);
            }
        }

        if(isset($filterData['type_id']) && !empty($filterData['type_id'])) {
            if (is_array($filterData['type_id'])) {
                $builder->whereIn('teb.type_id', $filterData['type_id']);
            } else {
                $builder->where('teb.type_id', $filterData['type_id']);
            }
        }

        if(isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
            if (is_array($filterData['ownership_flat_member_id'])) {
                $builder->whereIn('teb.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            } else {
                $builder->where('teb.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            }
        }

        if(isset($filterData['event_booking_id']) && !empty($filterData['event_booking_id'])) {
            if (is_array($filterData['event_booking_id'])) {
                $builder->whereIn('teb.event_booking_id', $filterData['event_booking_id']);
            } else {
                $builder->where('teb.event_booking_id', $filterData['event_booking_id']);
            }
        }

        if(isset($filterData['is_cancel'])){
            $builder->where('teb.is_cancel', $filterData['is_cancel']);
        }

        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->like('te.event_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }
        $builder->orderBy("teb.event_booking_id","DESC");
        $builder->groupBy("teb.event_booking_id");
        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function getEventBookingRegistrationData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_event_booking_registration as teb');
        $builder->select("teb.*,COALESCE(tm.name,'') as member_name,te.start_date as event_start_date, te.end_date as event_end_date,tm.start_date as booking_start_date,tm.end_date as booking_end_date,tm.total_adult,tm.total_child,tm.total_guest,tm.is_cancel");
        $builder->select("(SELECT count(*) FROM tbl_event_booking_registration as tebrs WHERE tebrs.event_booking_id = teb.event_booking_id AND tebrs.is_enter = 1) as enter");
        $builder->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no, 1 as total_pass_scan");
        $builder->join('tbl_event_booking tm', 'tm.event_booking_id = teb.event_booking_id', 'left');
        $builder->join('tbl_event te', 'te.event_id = teb.event_id', 'left');
        $builder->join('tbl_ownership_flat_member tofm', 'tofm.ownership_flat_member_id = tm.ownership_flat_member_id', 'left');
        $builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
        $builder->join('tbl_ownership_flat tof', 'tof.ownership_flat_id = tofm.ownership_flat_id', 'left');
        $builder->join("tbl_flat as tf","tf.flat_id = tof.flat_id","left");
        $builder->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");

        if(isset($filterData['event_id']) && !empty($filterData['event_id'])) {
            if (is_array($filterData['event_id'])) {
                $builder->whereIn('teb.event_id', $filterData['event_id']);
            } else {
                $builder->where('teb.event_id', $filterData['event_id']);
            }
        }

        if(isset($filterData['is_enter']) && $filterData['is_enter'] == 1){
            $builder->where('teb.is_enter', $filterData['is_enter']);
        }

        if(isset($filterData['event_booking_registration_id']) && !empty($filterData['event_booking_registration_id'])) {
            if (is_array($filterData['event_booking_registration_id'])) {
                $builder->whereIn('teb.event_booking_registration_id', $filterData['event_booking_registration_id']);
            } else {
                $builder->where('teb.event_booking_registration_id', $filterData['event_booking_registration_id']);
            }
        }

        if(isset($filterData['qr_code_number']) && !empty($filterData['qr_code_number'])) {
            if (is_array($filterData['qr_code_number'])) {
                $builder->whereIn('teb.qr_code_number', $filterData['qr_code_number']);
            } else {
                $builder->where('teb.qr_code_number', $filterData['qr_code_number']);
            }
        }

        if(isset($filterData['event_booking_id']) && !empty($filterData['event_booking_id'])) {
            if (is_array($filterData['event_booking_id'])) {
                $builder->whereIn('teb.event_booking_id', $filterData['event_booking_id']);
            } else {
                $builder->where('teb.event_booking_id', $filterData['event_booking_id']);
            }
        }

        if(isset($filterData['qr_code_number']) && !empty($filterData['qr_code_number'])) {
            if (is_array($filterData['qr_code_number'])) {
                $builder->whereIn('teb.qr_code_number', $filterData['qr_code_number']);
            } else {
                $builder->where('teb.qr_code_number', $filterData['qr_code_number']);
            }
        }

        if(isset($filterData['type']) && !empty($filterData['type'])) {
            if (is_array($filterData['type'])) {
                $builder->whereIn('teb.type', $filterData['type']);
            } else {
                $builder->where('teb.type', $filterData['type']);
            }
        }

        if(isset($filterData['type_id']) && !empty($filterData['type_id'])) {
            if (is_array($filterData['type_id'])) {
                $builder->whereIn('teb.type_id', $filterData['type_id']);
            } else {
                $builder->where('teb.type_id', $filterData['type_id']);
            }
        }

        if(isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
            if (is_array($filterData['ownership_flat_member_id'])) {
                $builder->whereIn('teb.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            } else {
                $builder->where('teb.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            }
        }

        

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function getEventRateData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_event_rate as ter');
        $builder->select("ter.*,te.is_guest_allowed");
        $builder->join('tbl_event te', 'te.event_id = ter.event_id', 'left');

        if(isset($filterData['event_id']) && !empty($filterData['event_id'])) {
            if (is_array($filterData['event_id'])) {
                $builder->whereIn('ter.event_id', $filterData['event_id']);
            } else {
                $builder->where('ter.event_id', $filterData['event_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('te.society_id', $filterData['society_id']);
            } else {
                $builder->where('te.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start_date']) && $filterData['start_date'] != $filterData['end_date']){
            if (isset($filterData['start_date']) && !empty($filterData['start_date'])) {
                if (is_array($filterData['start_date'])) {
                    $builder->whereIn('ter.date  >=', $filterData['start_date']);
                } else {
                    $builder->where('ter.date  >=', $filterData['start_date']);
                    $builder->where('ter.date  <=', $filterData['end_date']);
                }
            }
        }

        if(isset($filterData['start_date']) && $filterData['start_date'] == $filterData['end_date']){
            if (isset($filterData['start_date']) && !empty($filterData['start_date'])) {
                if (is_array($filterData['start_date'])) {
                    $builder->whereIn('ter.date', $filterData['start_date']);
                } else {
                    $builder->where('ter.date', $filterData['start_date']);
                }
            }
        }

        if (isset($filterData['event_rate_id']) && $filterData['event_rate_id'] != '') {
            $builder->where("ter.event_rate_id", $filterData['event_rate_id']);
        }

        // if (isset($filterData['is_order_by_event_id']) ) {
        //     $builder->orderBy("ter.event_rate_id","DESC");
        // } else {
        //     $builder->orderBy("ter.event_id");
        // }

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
//lastQuery();
        return $query;
    }

    public function deleteEventImage($eventImageId)
    {
        $builder = $this->db->table('tbl_event_image');
        $eventImageIdArray = is_array($eventImageId) ? $eventImageId : array($eventImageId);
        $builder->whereIn('event_image_id', $eventImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteRecordEventRate($eventId)
    {
        $builder = $this->db->table('tbl_event_rate');
        $eventIdArray = is_array($eventId) ? $eventId : array($eventId);
        $builder->whereIn('event_id', $eventIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function getEventCategoryData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_event_category as tec');
        $builder->select("tec.event_category_id,tec.category_id,tec.event_id");
        $builder->select("tc.category_name");
        $builder->join('tbl_event te', 'te.event_id = tec.event_id', 'left');
        $builder->join('tbl_category tc', 'tc.category_id = tec.category_id', 'left');

        if(isset($filterData['event_id']) && !empty($filterData['event_id'])) {
            if (is_array($filterData['event_id'])) {
                $builder->whereIn('tec.event_id', $filterData['event_id']);
            } else {
                $builder->where('tec.event_id', $filterData['event_id']);
            }
        }

        $builder->orderBy("tec.event_id");

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }

        return $query;
    }

    public function deleteCategoryRecord($eventId){
        $builder = $this->db->table('tbl_event_category');
        $eventIdArray = is_array($eventId) ? $eventId : array($eventId);
        $builder->whereIn('event_id', $eventIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
}
?>
