<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class DailyReportModel extends BaseModel
{

    public function getDailyReportData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_daily_report as tdr');
        $builder->select("tdr.*");
        accessFilter($builder, array("society" => "tdr.society_id"));

        if(isset($filterData['id']) && !empty($filterData['id'])) {
            if (is_array($filterData['id'])) {
                $builder->whereIn('tdr.id', $filterData['id']);
            } else {
                $builder->where('tdr.id', $filterData['id']);
            }
        }

        if(isset($filterData['id_not']) && !empty($filterData['id_not'])) {
            if (is_array($filterData['id_not'])) {
                $builder->whereNotIn('tdr.id', $filterData['id_not']);
            } else {
                $builder->where('tdr.id !=', $filterData['id_not']);
            }
        }

        if(isset($filterData['report_date']) && !empty($filterData['report_date'])) {
            if (is_array($filterData['report_date'])) {
                $builder->whereIn('tdr.report_date', $filterData['report_date']);
            } else {
                $builder->where('tdr.report_date', $filterData['report_date']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tdr.society_id', $filterData['society_id']);
            } else {
                $builder->where('tdr.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('tdr.report_date', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tdr.id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($id)
    {
        $builder = $this->db->table('tbl_daily_report');
        $idArray = is_array($id) ? $id : array($id);
        $builder->whereIn('id', $idArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($idArray)){
                foreach($idArray as $ids){
                    $deleteDataArray['module'] = 'Daily Report';
                    $deleteDataArray['activity'] = "Daily Report Deleted";
                    $deleteDataArray['module_id'] = $ids;
                    logActivity('Daily Report Deleted [DailyReportID: ' . $ids . ']',$this->ionAuth->getUserId(),'Daily Report',$ids,json_encode($deleteDataArray),'','Daily Report',$ids);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getDailyReport($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_bank_account as tba');
        //$builder->startCache();
        $builder->select("tba.bank_account_id as id,CONCAT(COALESCE(tb.bank_name,''),'-',COALESCE(tba.bank_account_no,'')) as text,tb.bank_name,tba.branch,tba.ifsc_code");
        $builder->join("tbl_bank as tb","tb.bank_id = tba.bank_id","left");

        if(isset($filterData['bank_account_id']) && !empty($filterData['bank_account_id'])) {
            if (is_array($filterData['bank_account_id'])) {
                $builder->whereIn('tba.bank_account_id', $filterData['bank_account_id']);
            } else {
                $builder->where('tba.bank_account_id', $filterData['bank_account_id']);
            }
        }
        accessFilter($builder, array("society" => "tba.society_id"));
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("CONCAT(COALESCE(tb.bank_name,''),'-',COALESCE(tba.bank_account_no,''))", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tba.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        // printArray($result,1);
        return json_encode($result);
    }
}