<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class ComplainModel extends BaseModel
{
	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getComplainData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_complain as tc');
		$builder->select("tc.*,tt.tower_name,tcat.category_name,ts.status_name,ts.is_resolved,tc.created_by as complain_created_by,ts.is_open,ts.is_default,ts.is_close");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by_name");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by_name");

		$builder->select("concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name");
		$builder->select("tf.flat_no as flat_no");
		$builder->select("tca.common_area_name as common_area_name");
        $builder->select("(SELECT count(*) FROM tbl_comment as tcomment WHERE tcomment.type = 'complain' AND tcomment.type_id = tc.complain_id AND tcomment.is_deleted = 0) as total_comment");
        $builder->select("(CASE 
                                WHEN  
                                    tc.complainant ='manager' THEN COALESCE(tman.full_name,'')   
                                WHEN
                                    tc.complainant ='member' THEN COALESCE(tofm.name,'')   
                            END) as complainant_name");
		$builder->select("concat(tc.prefix,tc.series) as complain_number");
		$builder->join("tbl_status as ts","ts.status_id = tc.status_id","left");
		$builder->join("tbl_tower as tt","tt.tower_id = tc.tower_id","left");
		$builder->join("tbl_flat as tf","tf.flat_id = tc.flat_id","left");
		$builder->join(MASTER_DB.'.tbl_users_info as tum',"tum.id = tc.complainant_id AND tc.complainant = 'manager' AND tum.society_id = tc.society_id","left");
		$builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tc.complainant_id AND tc.complainant = 'member'","left");
		$builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
		$builder->join("tbl_category as tcat","tcat.category_id = tc.category_id","left");
		$builder->join("tbl_common_area as tca","tca.common_area_id = tc.common_area_id","left");
		$builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tc.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tc.created_by","left");
        $builder->join("society_user_master_view as tman","tman.user_society_id = tc.complainant_id AND tc.complainant = 'manager' AND tman.society_id = tc.society_id","left");
		if (isset($filterData['complain_id']) && !empty($filterData['complain_id'])) {
			if (is_array($filterData['complain_id'])) {
				$builder->whereIn('tc.complain_id', $filterData['complain_id']);
			} else {
				$builder->where('tc.complain_id', $filterData['complain_id']);
			}
		}

		if (isset($filterData['ownership_flat_id']) && !empty($filterData['ownership_flat_id'])) {
			if (is_array($filterData['ownership_flat_id'])) {
				$builder->whereIn('tofm.ownership_flat_id', $filterData['ownership_flat_id']);
			} else {
				$builder->where('tofm.ownership_flat_id', $filterData['ownership_flat_id']);
			}
		}

		if (isset($filterData['complain_type']) && !empty($filterData['complain_type'])) {
			if (is_array($filterData['complain_type'])) {
				$builder->whereIn('tc.complain_type', $filterData['complain_type']);
			} else {
				$builder->where('tc.complain_type', $filterData['complain_type']);
			}
		}
		if (isset($filterData['status_id']) && !empty($filterData['status_id'])) {
			if (is_array($filterData['status_id'])) {
				$builder->whereIn('tc.status_id', $filterData['status_id']);
			} else {
				$builder->where('tc.status_id', $filterData['status_id']);
			}
		}

		if (isset($filterData['category_id']) && !empty($filterData['category_id'])) {
			if (is_array($filterData['category_id'])) {
				$builder->whereIn('tc.category_id', $filterData['category_id']);
			} else {
				$builder->where('tc.category_id', $filterData['category_id']);
			}
		}

		if (isset($filterData['is_urgent'])) {
			if (is_array($filterData['is_urgent'])) {
				$builder->whereIn('tc.is_urgent', $filterData['is_urgent']);
			} else {
				$builder->where('tc.is_urgent', $filterData['is_urgent']);
			}
		}

		if(isset($filterData['complain_id_not']) && !empty($filterData['complain_id_not'])) {
			if (is_array($filterData['complain_id_not'])) {
				$builder->whereNotIn('tc.complain_id', $filterData['complain_id_not']);
			} else {
				$builder->where('tc.complain_id != ', $filterData['complain_id_not']);
			}
		}

		if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tc.society_id', $filterData['society_id']);
			} else {
				$builder->where('tc.society_id', $filterData['society_id']);
			}
		}
        if (isset($filterData['start'])) {
			if ($filterData['start'] != '-1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('tc.complain_title', $filterData['search'], 'both');
			$builder->orLike('tc.description', $filterData['search'], 'both');
			$builder->orLike('tt.tower_name', $filterData['search'], 'both');
			$builder->orLike('concat(tc.prefix,tc.series)', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tc.is_active', $filterData['is_active']);
		}
		$builder->orderBy("tc.complain_id",'desc');
		$builder->groupBy('tc.complain_id');
		if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		} else {
			$queryData = $builder->get()->getRowArray();
		}
		// lastQuery();
		return $queryData;
	}

	public function deleteRecord($complainId,$userId = 0,$societyId = 0)
	{	
		$complainIdArray = is_array($complainId) ? $complainId : array($complainId);
		foreach ($complainIdArray as $complainIds){
			$complainHistoryImageData = $this->getComplainHistoryImageData(array("complain_id" => $complainIds));
			$fileHistoryUrl = '';
			$thumbnailFileHistoryUrl = '';
			if(!empty($complainHistoryImageData)){
				if($complainHistoryImageData['complain_image'] != '') {
					$fileHistoryUrl = MEDIA_IMAGE_PATH . $complainHistoryImageData['complain_image'];
					$thumbnailFileHistoryUrl = THUMBNAIL_MEDIA_IMAGE_PATH . $complainHistoryImageData['complain_image'];
				}
				if (file_exists($thumbnailFileHistoryUrl)) {
					unlink($thumbnailFileHistoryUrl);
				}
				if (file_exists($fileHistoryUrl)) {
					unlink($fileHistoryUrl);
				}
			}

			$complainImageData = $this->getMediaData(array("media_for" => 'complain',"media_for_id" => $complainIds));
			$fileUrl = '';
			$thumbnailFileUrl = '';
			if(!empty($complainImageData)){
				if($complainImageData['media_file'] != '') {
					$fileUrl = MEDIA_IMAGE_PATH . $complainImageData['media_file'];
					$thumbnailFileUrl = THUMBNAIL_MEDIA_IMAGE_PATH . $complainImageData['media_file'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				}
				if (file_exists($fileUrl)) {
					unlink($fileUrl);
				}
			}
		}
		$builder = $this->db->table('tbl_complain_history_image');
        $builder->whereIn('complain_id', $complainIdArray);
        $builder->delete();

        $builder = $this->db->table('tbl_complain_history');
        $builder->whereIn('complain_id', $complainIdArray);
        $builder->delete();

        $builder = $this->db->table('tbl_media');
        $builder->where('media_for', 'complain');
        $builder->whereIn('media_for_id', $complainIdArray);
        $builder->delete();
        $builder = $this->db->table('tbl_complain');
        $builder->whereIn('complain_id', $complainIdArray);
		$ids = is_array($complainId) ? implode(',',$complainId) : $complainId;
		$builder->delete();

		if ($this->db->affectedRows()) {

			if(!empty($complainId)){
				foreach($complainId as $complain){
					$deleteDataArray['module'] = 'Complain';
            		$deleteDataArray['activity'] = "Complain Deleted";
					$deleteDataArray['module_id'] = $complain;
					$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
					logActivity('Complain Deleted [ComplainID: ' . $complain . ']',$userId,'Complain',$complain,json_encode($deleteDataArray),'','Complain',$complain,$societyId);
				}
			}
			return true;
		}
		return false;
	}

	public function getComplainImageData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_complain_image as tci');
		$builder->select("tci.complain_image_id, tci.complain_image,tci.complain_id");
		$builder->join('tbl_complain tc', 'tc.complain_id = tci.complain_id', 'left');
		if(isset($filterData['complain_id']) && !empty($filterData['complain_id'])) {
            if (is_array($filterData['complain_id'])) {
                $builder->whereIn('tci.complain_id', $filterData['complain_id']);
            } else {
                $builder->where('tci.complain_id', $filterData['complain_id']);
            }
        }

		if (isset($filterData['complain_image_id']) && $filterData['complain_image_id'] != '') {
			$builder->where("tci.complain_image_id", $filterData['complain_image_id']);
		}
		
		$builder->orderBy("tci.complain_id");

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}

		return $query;
	}

	public function getComplainHistoryData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_complain_history as tch');
		$builder->select("tch.*,tc.description,ts.status_name,ts.is_close,ts.is_open");
		$builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by_name");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by_name");
		$builder->join("tbl_status as ts","ts.status_id = tch.status_id","left");
		$builder->join("tbl_complain as tc","tc.complain_id = tch.complain_id","left");
		$builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tch.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tch.created_by","left");

		if(isset($filterData['complain_id']) && !empty($filterData['complain_id'])) {
            if (is_array($filterData['complain_id'])) {
                $builder->whereIn('tch.complain_id', $filterData['complain_id']);
            } else {
                $builder->where('tch.complain_id', $filterData['complain_id']);
            }
        }
        $builder->orderBy("tch.complain_history_id",'DESC');
        $builder->groupBy("tch.complain_history_id");
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}

		return $query;
	}

	public function getComplainHistoryImageData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_complain_history_image as tchi');
		$builder->select("tchi.*");
		if(isset($filterData['complain_id']) && !empty($filterData['complain_id'])) {
            if (is_array($filterData['complain_id'])) {
                $builder->whereIn('tchi.complain_id', $filterData['complain_id']);
            } else {
                $builder->where('tchi.complain_id', $filterData['complain_id']);
            }
        }
        if(isset($filterData['complain_history_id']) && !empty($filterData['complain_history_id'])) {
            if (is_array($filterData['complain_history_id'])) {
                $builder->whereIn('tchi.complain_history_id', $filterData['complain_history_id']);
            } else {
                $builder->where('tchi.complain_history_id', $filterData['complain_history_id']);
            }
        }
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		// printArray($query,1);
		return $query;

	}

	public function deleteComplainImage($complainImageId)
	{
		$builder = $this->db->table('tbl_complain_image');
        $complainImageIdArray = is_array($complainImageId) ? $complainImageId : array($complainImageId);
        $builder->whereIn('complain_image_id', $complainImageIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

	public function getDocument($filterData)
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_module_document as tmd');
        $builder->select("tmd.*,tdoc.document_name");
        $builder->join('tbl_document tdoc','tdoc.document_id = tmd.document_id','left');

		if(isset($filterData['module']) && !empty($filterData['module'])) {
			if (is_array($filterData['module'])) {
				$builder->whereIn('tmd.module', $filterData['module']);
			} else {
				$builder->where('tmd.module', $filterData['module']);
			}
		}


		if(isset($filterData['module_id']) && !empty($filterData['module_id'])) {
			if (is_array($filterData['module_id'])) {
				$builder->whereIn('tmd.module_id', $filterData['module_id']);
			} else {
				$builder->where('tmd.module_id', $filterData['module_id']);
			}
		}

		if(isset($filterData['module_document_id']) && !empty($filterData['module_document_id'])) {
			if (is_array($filterData['module_document_id'])) {
				$builder->whereIn('tmd.module_document_id', $filterData['module_document_id']);
			} else {
				$builder->where('tmd.module_document_id', $filterData['module_document_id']);
			}
		}

        
        $builder->orderBy("tmd.module_document_id");
        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function getDocumentImage($filterData)
    {
    	$builder = $this->db->table('tbl_module_document_image as tmdi');
        $builder->select("tmdi.*");                     
        
		if(isset($filterData['module']) && !empty($filterData['module'])) {
			if (is_array($filterData['module'])) {
				$builder->whereIn('tmdi.module', $filterData['module']);
			} else {
				$builder->where('tmdi.module', $filterData['module']);
			}
		}


		if(isset($filterData['module_id']) && !empty($filterData['module_id'])) {
			if (is_array($filterData['module_id'])) {
				$builder->whereIn('tmdi.module_id', $filterData['module_id']);
			} else {
				$builder->where('tmdi.module_id', $filterData['module_id']);
			}
		}

		if(isset($filterData['module_document_image_id']) && !empty($filterData['module_document_image_id'])) {
			if (is_array($filterData['module_document_image_id'])) {
				$builder->whereIn('tmdi.module_document_image_id', $filterData['module_document_image_id']);
			} else {
				$builder->where('tmdi.module_document_image_id', $filterData['module_document_image_id']);
			}
		}

		if(isset($filterData['module_document_id']) && !empty($filterData['module_document_id'])) {
			if (is_array($filterData['module_document_id'])) {
				$builder->whereIn('tmdi.module_document_id', $filterData['module_document_id']);
			} else {
				$builder->where('tmdi.module_document_id', $filterData['module_document_id']);
			}
		}

        
        $builder->orderBy("tmdi.module_document_image_id");
        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function getComplainCode($prefix = '',$societyDb = '')
	{
		// $session       = \Config\Services::session();
		// $societyId = $session->get('society_id');

		// // printArray($societyId,1);
		// $query = $this->db->query("select getNextSeries('complaint','".$prefix."', ".$societyId.") as nextSeries");

        // $return = $query->getRowArray();
        // // printArray($return,1);
        // return isset($return['nextSeries'])?$return['nextSeries'] : 1;

        $this->centralDB->query("CALL getNextSeriesNumber(?, ?, ?, @nextSeries)", ['complaint', $prefix, $societyDb]);

		// Fetch the OUT parameter
		$query = $this->centralDB->query("SELECT @nextSeries as nextSeries");
		$result = $query->getRowArray();

		return isset($result['nextSeries']) ? $result['nextSeries'] : 1;

	}

	public function deleteRecordComplainImage($complainId,$userId = 0,$societyId = 0)
	{	
		$complainIdArray = is_array($complainId) ? $complainId : array($complainId);
		foreach ($complainIdArray as $complainIds){
			$getImageData = $this->getComplainImageData(array("complain_id" => $complainIds));
			$fileUrl = '';
			if(!empty($getImageData)){
				if($getImageData['complain_image'] != '') {
					$fileUrl = COMPLAIN_IMAGE_PATH . $getImageData['complain_image'];
				}
				if (file_exists($fileUrl)) {
					unlink($fileUrl);
				}
			}
			
		}

		$builder = $this->db->table('tbl_complain_image');
        $builder->whereIn('complain_id', $complainIdArray);
        $builder->delete();
		$ids = is_array($complainId) ? implode(',',$complainId) : $complainId;

		if ($this->db->affectedRows()) {

			if(!empty($complainId)){
				
				$deleteDataArray['module'] = 'Complain Image';
				$deleteDataArray['activity'] = "Complain Image Deleted";
				$deleteDataArray['module_id'] = $complainId;
				$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
				logActivity('Complain Image Deleted [ComplainID: ' . $complainId . ']',$userId,'Complain Image',$complainId,json_encode($deleteDataArray),'','Complain',$complainId,$societyId);
			}
			return true;
		}
		return false;
	}

	// public function deleteComplainImageForHistory($complainId,$userId = 0,$societyId = 0)
	// {	
	// 	$complainIdArray = is_array($complainId) ? $complainId : array($complainId);
		

	// 	$builder = $this->db->table('tbl_complain_image');
    //     $builder->whereIn('complain_id', $complainIdArray);
    //     $builder->delete();
	// 	$ids = is_array($complainId) ? implode(',',$complainId) : $complainId;

	// 	if ($this->db->affectedRows()) {

	// 		// if(!empty($complainId)){
				
	// 		// 	$deleteDataArray['module'] = 'Complain Image';
	// 		// 	$deleteDataArray['activity'] = "Complain Image Deleted";
	// 		// 	$deleteDataArray['module_id'] = $complainId;
	// 		// 	$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
	// 		// 	logActivity('Complain Image Deleted [ComplainID: ' . $complainId . ']',$userId,'Complain Image',$complainId,json_encode($deleteDataArray),'','Complain',$complainId,$societyId);
	// 		// }
	// 		return true;
	// 	}
	// 	return false;
	// }


	public function getMediaData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_media as tm');
		$builder->select("tm.*");

		if(isset($filterData['media_for_id']) && !empty($filterData['media_for_id'])) {
            if (is_array($filterData['media_for_id'])) {
                $builder->whereIn('tm.media_for_id', $filterData['media_for_id']);
            } else {
                $builder->where('tm.media_for_id', $filterData['media_for_id']);
            }
        }

        if(isset($filterData['media_type']) && !empty($filterData['media_type'])) {
            if (is_array($filterData['media_type'])) {
                $builder->whereIn('tm.media_type', $filterData['media_type']);
            } else {
                $builder->where('tm.media_type', $filterData['media_type']);
            }
        }

        if(isset($filterData['media_for']) && !empty($filterData['media_for'])) {
            if (is_array($filterData['media_for'])) {
                $builder->whereIn('tm.media_for', $filterData['media_for']);
            } else {
                $builder->where('tm.media_for', $filterData['media_for']);
            }
        }
		if (isset($filterData['media_id']) && $filterData['media_id'] != '') {
			$builder->where("tm.media_id", $filterData['media_id']);
		}
		$builder->orderBy("tm.media_id","desc");
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function deleteMediaRecord($mediaId,$userId = 0,$societyId = 0)
	{	
		$mediaIdArray = is_array($mediaId) ? $mediaId : array($mediaId);
		foreach ($mediaIdArray as $mediaIds){
			$getMediaData = $this->getMediaData(array("media_id" => $mediaIds));
			$fileUrl = '';
			$thumbnailFileUrl = '';
			if(!empty($getMediaData)){
				if($getMediaData['media_file'] != '') {
					$fileUrl = MEDIA_IMAGE_PATH . $getMediaData['media_file'];
					$thumbnailFileUrl = THUMBNAIL_MEDIA_IMAGE_PATH . $getMediaData['media_file'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				}
				if (file_exists($fileUrl)) {
					unlink($fileUrl);
				}
			}
			
		}
		$builder = $this->db->table('tbl_media');
		$builder->whereIn('media_id', $mediaIdArray);
       
        $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

	public function deleteComplainMediaRecord($mediaId,$userId = 0,$societyId = 0)
	{	
		$mediaIdArray = is_array($mediaId) ? $mediaId : array($mediaId);
		$builder = $this->db->table('tbl_media');
		$builder->whereIn('media_id', $mediaIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

	public function deleteComplainImageForHistory($complainId,$userId = 0,$societyId = 0)
	{	
		$complainIdArray = is_array($complainId) ? $complainId : array($complainId);
		

		$builder = $this->db->table('tbl_media');
        $builder->where('media_for', 'complain');
        $builder->where('media_type', 'image');
        $builder->whereIn('media_for_id', $complainIdArray);
        $builder->delete();
		$ids = is_array($complainId) ? implode(',',$complainId) : $complainId;

		if ($this->db->affectedRows()) {

			// if(!empty($complainId)){
				
			// 	$deleteDataArray['module'] = 'Complain Image';
			// 	$deleteDataArray['activity'] = "Complain Image Deleted";
			// 	$deleteDataArray['module_id'] = $complainId;
			// 	$userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
			// 	logActivity('Complain Image Deleted [ComplainID: ' . $complainId . ']',$userId,'Complain Image',$complainId,json_encode($deleteDataArray),'','Complain',$complainId,$societyId);
			// }
			return true;
		}
		return false;
	}

	function getUser($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

		$societyId = "NULL";
		if(isset($filterData['society_id']) && !empty($filterData['society_id'])){
			$societyId = $filterData['society_id'];
		}
		// First, call the procedure to populate temporary table
		
		// Then use the temporary table in your JOIN
		
		$builder = $this->db->table(MASTER_DB.'.tbl_users as tu');
		//$builder->startCache();
		$builder->select("tus.user_society_id as id,concat(COALESCE(tus.first_name,'') ,' - ',COALESCE(tus.last_name,'')) as text,tus.phone as contact_number");
		$builder->join(MASTER_DB.".tbl_user_society as tus","tus.user_id = tu.id","left");
		$this->db->query("CALL ".MASTER_DB.".GetSocietyResourceTypes(".$societyId.", NULL, NULL)");
		// $builder->join(MASTER_DB.".society_resource_type_view as tsrtv","tus.resource_type_id = tsrtv.resource_type_id","left");
		$builder->join(MASTER_DB.".temp_resource_types as tsrtv", "tus.resource_type_id = tsrtv.resource_type_id", "left");
		$builder->where("tsrtv.resource_type_name", "manager");
		$builder->groupBy("tu.id");
        if(isset($filterData['user_id']) && !empty($filterData['user_id'])) {
            if (is_array($filterData['user_id'])) {
                $builder->whereIn('tu.id', $filterData['user_id']);
            } else {
                $builder->where('tu.id', $filterData['user_id']);
            }
        }

       

        // if(isset($filterData['is_active'])){
        //     $builder->where('tu.is_active', $filterData['is_active']);
        // }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("concat(COALESCE(tus.first_name,'') ,' - ',COALESCE(tus.last_name,''))", $filterData['filter_param'],'both');
            $builder->groupEnd();
        }
        accessFilter($builder, array("society" => "tus.society_id"));
        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
		// lastQueryTenent($this->db,1);
        return json_encode($result);
    }


    function getGroup($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table(MASTER_DB.'.tbl_groups as tg');
        //$builder->startCache();
        $builder->select("tg.id as id,COALESCE(tg.name,'') as text");

        if(isset($filterData['group_id']) && !empty($filterData['group_id'])) {
            if (is_array($filterData['group_id'])) {
                $builder->whereIn('tg.id', $filterData['group_id']);
            } else {
                $builder->where('tg.id', $filterData['group_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tg.name,'')", $filterData['filter_param'],'both');
            $builder->groupEnd();
        }
        accessFilter($builder, array("society" => "tg.society_id"));
        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
    
}
?>
