<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class CommonWebServiceModel extends BaseModel
{
    public function getUserGroupsBySociety($userId, $societyId)
{
    $builder = $this->db->table(MASTER_DB . '.tbl_users_groups ug');
    $builder->select('g.*');
    $builder->join(MASTER_DB . '.tbl_groups g', 'g.id = ug.group_id');
    $builder->where('ug.user_id', $userId);
    $builder->where('ug.society_id', $societyId);

    $query = $builder->get();
    $groups = $query->getResultArray();

    foreach ($groups as &$group) {
        $group['permissions'] = !empty($group['permissions']) ? unserialize($group['permissions']) : [];
    }

    return $groups;
}

public function getUserPermissionsBySociety($userId, $societyId)
{
    $builder = $this->db->table(MASTER_DB . '.tbl_users_groups ug');
    $builder->select('g.permissions');
    $builder->join(MASTER_DB . '.tbl_groups g', 'g.id = ug.group_id');
    $builder->where('ug.user_id', $userId);
    $builder->where('ug.society_id', $societyId);
    $query = $builder->get();

    $allPermissions = [];
    foreach ($query->getResultArray() as $row) {
        $perms = !empty($row['permissions']) ? unserialize($row['permissions']) : [];
        $allPermissions = array_merge($allPermissions, $perms);
    }
    return array_unique($allPermissions);
}
    public function getUserData($filterData = array())
    {
        // printArray($filterData,1);
        $limit = DATA_LIMIT;
        $builder = $this->db->table(MASTER_DB.'.tbl_users as tu');
        $builder->select('tu.*,CONCAT(COALESCE(tu.first_name,"")," - ",COALESCE(tu.last_name,"")) as full_name,tus.user_image');
        $builder->select('tus.user_society_id,tus.society_id,tus.resource_type_id,tus.type_id');
        // Get comma-separated society IDs and optionally other fields
        $builder->select('GROUP_CONCAT(DISTINCT tus.society_id) as society_ids');

        $builder->join(MASTER_DB.".tbl_user_society as tus","tu.id = tus.user_id AND tus.is_delete = 0","left");
        if(isset($filterData['email']) && !empty($filterData['email'])) {
            if (is_array($filterData['email'])) {
                $builder->whereIn('tu.email', $filterData['email']);
            } else {
                $builder->where('tu.email', $filterData['email']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tus.society_id', $filterData['society_id']);
            } else {
                $builder->where('tus.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['member_id']) && !empty($filterData['member_id'])) {
            if (is_array($filterData['member_id'])) {
                $builder->whereIn('tu.member_id', $filterData['member_id']);
            } else {
                $builder->where('tu.member_id', $filterData['member_id']);
            }
        }

        if(isset($filterData['resource_type_id']) && !empty($filterData['resource_type_id'])) {
            if (is_array($filterData['resource_type_id'])) {
                $builder->whereIn('tus.resource_type_id', $filterData['resource_type_id']);
            } else {
                $builder->where('tus.resource_type_id', $filterData['resource_type_id']);
            }
        }

        if(isset($filterData['resource_type_id_not']) && !empty($filterData['resource_type_id_not'])) {
            if (is_array($filterData['resource_type_id_not'])) {
                $builder->whereNotIn('tus.resource_type_id', $filterData['resource_type_id_not']);
            } else {
                $builder->where('tus.resource_type_id != ', $filterData['resource_type_id_not']);
            }
        }

        if(isset($filterData['user_type_id_not']) && !empty($filterData['user_type_id_not'])) {
            if (is_array($filterData['user_type_id_not'])) {
                $builder->whereNotIn('tus.user_type_id', $filterData['user_type_id_not']);
            } else {
                $builder->where('tus.user_type_id != ', $filterData['user_type_id_not']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        
        if(isset($filterData['phone']) && !empty($filterData['phone'])) {
            if (is_array($filterData['phone'])) {
                $builder->whereIn('tu.phone', $filterData['phone']);
            } else {
                $builder->where('tu.phone', $filterData['phone']);
            }
        }

        if(isset($filterData['id']) && !empty($filterData['id'])) {
            if (is_array($filterData['id'])) {
                $builder->whereIn('tu.id', $filterData['id']);
            } else {
                $builder->where('tu.id', $filterData['id']);
            }
        }
        $builder->groupBy('tu.id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function deviceData($filterData = array())
    {
        $builder = $this->db->table(MASTER_DB.'.tbl_user_device_info as tudi');
        $builder->select('tudi.*');
        $builder->join(MASTER_DB.".tbl_user_society as tus","tudi.user_society_id = tus.user_society_id AND tus.is_delete = 0","left");

        if(isset($filterData['is_notification_allowed']) && $filterData['is_notification_allowed'] == 1){
            $builder->select("tudnc.is_enabled,tudnc.notification_type_id,tudnc.ownership_flat_member_id,tudnc.society_id");
            // $builder->join("tbl_user_device_notification_config as tudnc","tudnc.ownership_flat_member_id = '". $filterData['ownership_flat_member_id'] ."' AND tudnc.society_id = '". $filterData['society_id'] ."' AND tudnc.notification_type_id = '". $filterData['notification_type_id'] ."' AND tudnc.device_id = tudi.device_id","left");
            
            $builder->join("tbl_user_device_notification_config as tudnc","tudnc.society_id = '". $filterData['society_id'] ."' AND tudnc.notification_type_id = '". $filterData['notification_type_id'] ."' AND tudnc.device_id = tudi.device_id","left");

            if (is_array($filterData['ownership_flat_member_id'])) {
                $builder->whereIn('tudnc.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            } else {
                $builder->where('tudnc.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            }
        }

        if(isset($filterData['user_id']) && !empty($filterData['user_id'])) {
            if (is_array($filterData['user_id'])) {
                $builder->whereIn('tudi.user_id', $filterData['user_id']);
            } else {
                $builder->where('tudi.user_id', $filterData['user_id']);
            }
        }
        if(isset($filterData['user_type']) && !empty($filterData['user_type'])) {
            if (is_array($filterData['user_type'])) {
                $builder->whereIn('tudi.user_type', $filterData['user_type']);
            } else {
                $builder->where('tudi.user_type', $filterData['user_type']);
            }
        }
        if(isset($filterData['resource_type_id']) && !empty($filterData['resource_type_id'])) {
            if (is_array($filterData['resource_type_id'])) {
                $builder->whereIn('tus.resource_type_id', $filterData['resource_type_id']);
            } else {
                $builder->where('tus.resource_type_id', $filterData['resource_type_id']);
            }
        }

        if(isset($filterData['user_society_id']) && !empty($filterData['user_society_id'])) {
            if (is_array($filterData['user_society_id'])) {
                $builder->whereIn('tudi.user_society_id', $filterData['user_society_id']);
            } else {
                $builder->where('tudi.user_society_id', $filterData['user_society_id']);
            }
        }

        if(isset($filterData['user_type_id']) && !empty($filterData['user_type_id'])) {
            if (is_array($filterData['user_type_id'])) {
                $builder->whereIn('tudi.user_type_id', $filterData['user_type_id']);
            } else {
                $builder->where('tudi.user_type_id', $filterData['user_type_id']);
            }
        }
        if(isset($filterData['user_type_id_not']) && !empty($filterData['user_type_id_not'])) {
            if (is_array($filterData['user_type_id_not'])) {
                $builder->whereNotIn('tudi.user_type_id', $filterData['user_type_id_not']);
            } else {
                $builder->where('tudi.user_type_id !=', $filterData['user_type_id_not']);
            }
        }
        if(isset($filterData['device_type']) && !empty($filterData['device_type'])) {
            if (is_array($filterData['device_type'])) {
                $builder->whereIn('LOWER(tudi.device_type)', $filterData['device_type']);
            } else {
                $builder->where('LOWER(tudi.device_type)', $filterData['device_type']);
            }
        }
        if(isset($filterData['device_id']) && !empty($filterData['device_id'])) {
            if (is_array($filterData['device_id'])) {
                $builder->whereIn('tudi.device_id', $filterData['device_id']);
            } else {
                $builder->where('tudi.device_id', $filterData['device_id']);
            }
        }
        if(isset($filterData['is_latest']) && !empty($filterData['is_latest'])) {
            $builder->where('tudi.is_latest', $filterData['is_latest']);
        }
        $builder->where('tudi.is_deleted',0);
        $builder->groupBy("tudi.user_device_info_id");
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        //lastQuery();
        return $queryData;
    }

    public function getGroupsData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table(MASTER_DB.'.tbl_groups as tg');
        $builder->select('tg.*,ts.society_name');
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tg.society_id","left");
        if(isset($filterData['name']) && !empty($filterData['name'])) {
            if (is_array($filterData['name'])) {
                $builder->whereIn('tg.name', $filterData['name']);
            } else {
                $builder->where('tg.name', $filterData['name']);
            }
        }

        if(isset($filterData['group_id']) && !empty($filterData['group_id'])) {
            if (is_array($filterData['group_id'])) {
                $builder->whereIn('tg.id', $filterData['group_id']);
            } else {
                $builder->where('tg.id', $filterData['group_id']);
            }
        }

        if(isset($filterData['id']) && !empty($filterData['id'])) {
            if (is_array($filterData['id'])) {
                $builder->whereIn('tg.id', $filterData['id']);
            } else {
                $builder->where('tg.id', $filterData['id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tg.society_id', $filterData['society_id']);
            } else {
                $builder->where('tg.society_id', $filterData['society_id']);
            }
        }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
//        lastQueryTenent($this->db);
        return $queryData;
    }

    public function getUserGroupsData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table(MASTER_DB.'.tbl_users_groups as tug');
        $builder->select('tug.*,tg.permissions');
        $builder->join(MASTER_DB.".tbl_groups as tg","tg.id = tug.group_id","left");
        
        if(isset($filterData['name']) && !empty($filterData['name'])) {
            if (is_array($filterData['name'])) {
                $builder->whereIn('tg.name', $filterData['name']);
            } else {
                $builder->where('tg.name', $filterData['name']);
            }
        }

        if(isset($filterData['id']) && !empty($filterData['id'])) {
            if (is_array($filterData['id'])) {
                $builder->whereIn('tg.id', $filterData['id']);
            } else {
                $builder->where('tg.id', $filterData['id']);
            }
        }

        if(isset($filterData['user_id']) && !empty($filterData['user_id'])) {
            if (is_array($filterData['user_id'])) {
                $builder->whereIn('tug.user_id', $filterData['user_id']);
            } else {
                $builder->where('tug.user_id', $filterData['user_id']);
            }
        }

        if(isset($filterData['user_society_id']) && !empty($filterData['user_society_id'])) {
            if (is_array($filterData['user_society_id'])) {
                $builder->whereIn('tug.user_society_id', $filterData['user_society_id']);
            } else {
                $builder->where('tug.user_society_id', $filterData['user_society_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tg.society_id', $filterData['society_id']);
            } else {
                $builder->where('tg.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['society_user_id']) && !empty($filterData['society_user_id'])) {
            if (is_array($filterData['society_user_id'])) {
                $builder->whereIn('tug.society_id', $filterData['society_user_id']);
            } else {
                $builder->where('tug.society_id', $filterData['society_user_id']);
            }
        }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getNotificationTypeData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_notification_type as tnt');
        $builder->select('tnt.*');
        // $builder->select('tnt.*,tudnc.is_enabled,tudnc.ownership_flat_member_id,tudnc.device_id,tudnc.society_id');
        // $builder->join('tbl_user_device_notification_config tudnc', 'tudnc.notification_type_id = tnt.notification_type_id', 'left');
        if(isset($filterData['notification_type']) && !empty($filterData['notification_type'])) {
            if (is_array($filterData['notification_type'])) {
                $builder->whereIn('tnt.notification_type', $filterData['notification_type']);
            } else {
                $builder->where('tnt.notification_type', $filterData['notification_type']);
            }
        }

        // if(isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
        //     if (is_array($filterData['ownership_flat_member_id'])) {
        //         $builder->whereIn('tudnc.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
        //     } else {
        //         $builder->where('tudnc.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
        //     }
        // }

        // if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
        //     if (is_array($filterData['society_id'])) {
        //         $builder->whereIn('tudnc.society_id', $filterData['society_id']);
        //     } else {
        //         $builder->where('tudnc.society_id', $filterData['society_id']);
        //     }
        // }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like("tnt.notification_type", $filterData['search'], 'both');
            $builder->groupEnd();
        }
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getNotificationStoreList($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_user_device_notification_config as tudnc');
        $builder->select('tudnc.*');
        if(isset($filterData['notification_type_id']) && !empty($filterData['notification_type_id'])) {
            if (is_array($filterData['notification_type_id'])) {
                $builder->whereIn('tudnc.notification_type_id', $filterData['notification_type_id']);
            } else {
                $builder->where('tudnc.notification_type_id', $filterData['notification_type_id']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tudnc.society_id', $filterData['society_id']);
            } else {
                $builder->where('tudnc.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['device_id']) && !empty($filterData['device_id'])) {
            if (is_array($filterData['device_id'])) {
                $builder->whereIn('tudnc.device_id', $filterData['device_id']);
            } else {
                $builder->where('tudnc.device_id', $filterData['device_id']);
            }
        }
        if(isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
            if (is_array($filterData['ownership_flat_member_id'])) {
                $builder->whereIn('tudnc.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            } else {
                $builder->where('tudnc.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            }
        }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getAppVersionData($filterData = array())
    {
        $builder = $this->db->table(MASTER_DB.'.tbl_app_version as tav');
        $builder->select('tav.*');
        if(isset($filterData['app_type']) && !empty($filterData['app_type'])) {
            if (is_array($filterData['app_type'])) {
                $builder->whereIn('tav.app_type', $filterData['app_type']);
            } else {
                $builder->where('tav.app_type', $filterData['app_type']);
            }
        }
        if(isset($filterData['platform']) && !empty($filterData['platform'])) {
            if (is_array($filterData['platform'])) {
                $builder->whereIn('tav.platform', $filterData['platform']);
            } else {
                $builder->where('tav.platform', $filterData['platform']);
            }
        }
        if(isset($filterData['version_code']) && !empty($filterData['version_code'])) {
            if (is_array($filterData['version_code'])) {
                $builder->whereIn('tav.version_code', $filterData['version_code']);
            } else {
                $builder->where('tav.version_code', $filterData['version_code']);
            }
        }        
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getUserSocietyData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $resourceTypeNot = isset($filterData['resource_type_id_not']) ? $filterData['resource_type_id_not'] : [];
        $userIdNot = isset($filterData['user_id_not']) ? $filterData['user_id_not'] : [];
        $builder = $this->db->table(MASTER_DB.'.tbl_user_society as tus');
        $builder->select('tm.*,tus.*,tug.id as user_group_id,tus.user_society_id as manager_id');
        // $builder->select("concat(tus.first_name,' ',tus.last_name) as name");
        $builder->select("concat(tus.first_name,' ',tus.last_name) as full_name");
        $builder->select("ts.society_name,tug.group_id");
        $builder->select("tus.phone,tu.email");
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tus.society_id","left");
        $builder->join(MASTER_DB.".tbl_users as tu","tu.id = tus.user_id","left");
        // $builder->join(MASTER_DB.".tbl_user_society as tu","tu.user_Society_id = tus.user_id","left");
        // 
        $builder->join(MASTER_DB.".tbl_member as tm","tm.member_id = tus.type_id","left");
        $builder->join(MASTER_DB.".tbl_users_groups as tug","tug.user_society_id = tus.user_society_id AND tug.user_id = tus.user_id","left");
        
        // $builder->join("tbl_user_society as tus","tus.id = tus.user_id","left");
        // $builder->join("tbl_users as tu","tu.id = tus.user_id","left");
        $builder->where("tus.is_delete",0);
        if(isset($filterData['user_id']) && !empty($filterData['user_id'])) {
            if (is_array($filterData['user_id'])) {
                $builder->whereIn('tus.user_id', $filterData['user_id']);
            } else {
                $builder->where('tus.user_id', $filterData['user_id']);
            }
        }

        if(isset($filterData['is_super_admin'])){
            $builder->where('tus.is_super_admin', $filterData['is_super_admin']);
        }


        if(isset($filterData['group_id']) && !empty($filterData['group_id'])) {
            if (is_array($filterData['group_id'])) {
                $builder->whereIn('tus.group_id', $filterData['group_id']);
            } else {
                $builder->where('tus.group_id', $filterData['group_id']);
            }
        }
        if(isset($filterData['phone']) && !empty($filterData['phone'])) {
            if (is_array($filterData['phone'])) {
                $builder->whereIn('tus.phone', $filterData['phone']);
            } else {
                $builder->where('tus.phone', $filterData['phone']);
            }
        }
        if(isset($filterData['is_active']) && !empty($filterData['is_active'])) {
            if (is_array($filterData['is_active'])) {
                $builder->whereIn('tus.is_active', $filterData['is_active']);
            } else {
                $builder->where('tus.is_active', $filterData['is_active']);
            }
        }

        // if(isset($filterData['is_member_login']) && !empty($filterData['is_member_login'])) {
        //     $builder->join(MASTER_DB.".society_ownership_flat_member_view as sofmv","sofmv.member_id = tus.type_id","left");
        //     $builder->where('sofmv.is_transferred', 0);
        //     $builder->where('sofmv.is_active', 1);
        // }
        if(isset($filterData['user_society_id']) && !empty($filterData['user_society_id'])) {
            if (is_array($filterData['user_society_id'])) {
                $builder->whereIn('tus.user_society_id', $filterData['user_society_id']);
            } else {
                $builder->where('tus.user_society_id', $filterData['user_society_id']);
            }
        }

        if(isset($filterData['user_society_id_not']) && !empty($filterData['user_society_id_not'])) {
            if (is_array($filterData['user_society_id_not'])) {
                $builder->whereNotIn('tus.user_society_id', $filterData['user_society_id_not']);
            } else {
                $builder->where('tus.user_society_id !=', $filterData['user_society_id_not']);
            }
        }

        
        if(isset($filterData['resource_type_id']) && !empty($filterData['resource_type_id'])) {
            if (is_array($filterData['resource_type_id'])) {
                $builder->whereIn('tus.resource_type_id', $filterData['resource_type_id']);
            } else {
                $builder->where('tus.resource_type_id', $filterData['resource_type_id']);
            }
        }
        

        // if (isset($filterData['is_member']) && !empty($filterData['is_member'])) {
        //     // $subQuery = "(SELECT resource_type_id FROM society_resource_type_view WHERE resource_type_name = '".RESOURCE_TYPE_MEMBER."')";
        //     // $builder->whereIn('tus.resource_type_id', $subQuery, false);
        //     $builder->select("tm.name");
        //     $this->db->query("CALL ".MASTER_DB.".GetSocietyResourceTypes(NULL, NULL, '".RESOURCE_TYPE_MEMBER."')");
        //     // $builder->where("tus.resource_type_id IN (SELECT resource_type_id FROM ".MASTER_DB.".society_resource_type_view WHERE resource_type_name = '".RESOURCE_TYPE_MEMBER."')");
        //     $builder->where("tus.resource_type_id IN (SELECT resource_type_id FROM temp_resource_types");
        // }

        if (isset($filterData['is_member']) && !empty($filterData['is_member'])) {
            // Call the procedure to populate temporary table
            $this->db->query("CALL ".MASTER_DB.".GetSocietyResourceTypes(NULL, NULL, '".RESOURCE_TYPE_MEMBER."')");
            
            // Use the temporary table in the WHERE clause
            $builder->where("tus.resource_type_id IN (SELECT resource_type_id FROM ".MASTER_DB.".temp_resource_types)");
        }

        if(isset($filterData['is_user_device_token_get']) && !empty($filterData['is_user_device_token_get'])) {
            $builder->select("COALESCE(tudi.user_device_info_id,'') as user_device_info_id,COALESCE(tudi.device_id,'') as device_id,COALESCE(tudi.device_type,'') as device_type,COALESCE(tudi.device_version) as device_version,COALESCE(tudi.one_signal_id,'') as one_signal_id,COALESCE(tudi.player_id,'') as player_id,COALESCE(tudi.device_token,'') as device_token");
            $builder->join("tbl_user_device_info as tudi","tudi.user_id = tus.user_id AND tudi.is_latest = 1","left");
            if(isset($filterData['type_id']) && !empty($filterData['type_id'])) {
                if (is_array($filterData['type_id'])) {
                    $builder->whereIn('tudi.user_type_id', $filterData['type_id']);
                } else {
                    $builder->where('tudi.user_type_id', $filterData['type_id']);
                }
            }
        }


        if(isset($filterData['is_management_committee']) && !empty($filterData['is_management_committee'])) {
            $builder->select("COALESCE(tmc.management_committee_id,'') as management_committee_id,COALESCE(tmc.flat_id,'') as flat_id");
            $builder->join("tbl_management_committee as tmc","tmc.member_id = tus.type_id AND tus.type = 'member'","left");
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tus.society_id', $filterData['society_id']);
            } else {
                $builder->where('tus.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['phone']) && !empty($filterData['phone'])) {
            if (is_array($filterData['phone'])) {
                $builder->whereIn('tus.phone', $filterData['phone']);
            } else {
                $builder->where('tus.phone', $filterData['phone']);
            }
        }

        if(isset($filterData['type_id']) && !empty($filterData['type_id'])) {
            if (is_array($filterData['type_id'])) {
                $builder->whereIn('tus.type_id', $filterData['type_id']);
            } else {
                $builder->where('tus.type_id', $filterData['type_id']);
            }
        }

        if(isset($filterData['user_id_not']) && !empty($filterData['user_id_not'])) {
            if (is_array($filterData['user_id_not'])) {
                $builder->whereNotIn('tus.user_id', $filterData['user_id_not']);
            } else {
                $builder->where('tus.user_id !=', $filterData['user_id_not']);
            }
        }

        if(isset($filterData['type_id_not']) && !empty($filterData['type_id_not'])) {
            if (is_array($filterData['type_id_not'])) {
                $builder->whereNotIn('tus.type_id', $filterData['type_id_not']);
            } else {
                $builder->where('tus.type_id !=', $filterData['type_id_not']);
            }
        }

        if((isset($filterData['resource_type_id_not']) && !empty($filterData['resource_type_id_not']))   && (isset($filterData['user_id_not']) && !empty($filterData['user_id_not']))  ) {
            // $builder->groupStart();
            // // $builder->where('tus.resource_type_id !=', $filterData['resource_type_id_not']);
            // // $builder->orWhere('tus.user_id !=', $filterData['user_id_not']);
            // if (in_array($filterData['resource_type_id_not'], $resourceTypeNot)) {
            //     $builder->where('tus.resource_type_id =', $filterData['resource_type_id_not']);
            // } else {
            //     $builder->where('tus.resource_type_id !=', $filterData['resource_type_id_not']);
            // }
            // if (in_array($filterData['user_id_not'], $userIdNot)) {
            //     $builder->orWhere('tus.user_id =', $filterData['user_id_not']);
            // } else {
            //     $builder->orWhere('tus.user_id !=', $filterData['user_id_not']);
            // }
            // $builder->groupEnd();

            $builder->groupStart();

            // Ensure $resourceTypeNot and $userIdNot are arrays before using in_array()
            $resourceTypeNot = is_array($resourceTypeNot) ? $resourceTypeNot : [$resourceTypeNot];
            $userIdNot = is_array($userIdNot) ? $userIdNot : [$userIdNot];

            if (in_array($filterData['resource_type_id_not'], $resourceTypeNot)) {
                $builder->where('tus.resource_type_id =', $filterData['resource_type_id_not']);
            } else {
                $builder->where('tus.resource_type_id !=', $filterData['resource_type_id_not']);
            }

            if (in_array($filterData['user_id_not'], $userIdNot)) {
                $builder->orWhere('tus.user_id =', $filterData['user_id_not']);
            } else {
                $builder->orWhere('tus.user_id !=', $filterData['user_id_not']);
            }

            $builder->groupEnd();
        }

        if(isset($filterData['type_id_not']) && !empty($filterData['type_id_not'])) {
            if (is_array($filterData['type_id_not'])) {
                $builder->whereNotIn('tus.type_id', $filterData['type_id_not']);
            } else {
                $builder->where('tus.type_id !=', $filterData['type_id_not']);
            }
        }

        // if(isset($filterData['user_id_not']) && !empty($filterData['user_id_not'])) {
        //     if (is_array($filterData['user_id_not'])) {
        //         $builder->whereNotIn('tus.user_id', $filterData['user_id_not']);
        //     } else {
        //         $builder->where('tus.user_id !=', $filterData['user_id_not']);
        //     }
        // }

        if(isset($filterData['is_society_id_group'])) {
            $builder->groupBy('tus.society_id');
        }
        if(isset($filterData['is_group_by_user_society_id'])) {
            $builder->groupBy('tus.user_society_id');
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        $builder->where('tus.is_delete !=', 1);
        $builder->groupBy('tus.user_society_id');
        
        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like("ts.society_name", $filterData['search'], 'both');
            $builder->groupEnd();
        }
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
       // lastQuery();
        return $queryData;
    }

    public function passwordCheck($filterData = array()){
//        if ($this->bcrypt->verify($filterData['password'],$filterData['db_password'])){
//            return TRUE;
//        }
        if(password_verify($filterData['password'], $filterData['db_password'])){
            return TRUE;
        }
        return FALSE;
    }

    // public function userDevice($userId, $deviceId,$type)
    // {
    //     $builder = $this->db->table('tbl_user_device_info as tudi');
    //     $builder->select('tudi.*');
    //     $builder->where('tudi.user_id', $userId);
    //     $builder->where('tudi.user_type', $type);
    //     $builder->where('tudi.device_id', $deviceId);
    //     return $builder->get()->getResultArray();
    // }

    public function userDevice($userSocietyId, $deviceId,$type,$userTypeId = '')
    {

       
        $builder = $this->db->table(MASTER_DB.'.tbl_user_device_info as tudi');
        $builder->select('tudi.*');
        if(isset($userSocietyId) && $userSocietyId != '') {
           $builder->where('tudi.user_society_id', $userSocietyId);
        }
        if(isset($type) && $type != '') {
            $builder->where('tudi.user_type', $type);
        }
        if(isset($deviceId) && $deviceId != '') {
            $builder->where('tudi.device_id', $deviceId);
        }
        if(isset($userTypeId) && $userTypeId != '') {
            $builder->where('tudi.user_type_id', $userTypeId);
        }
        $builder->where('tudi.is_deleted',0);
        return $builder->get()->getResultArray();
    }

    // function updateData($data, $tablename, $columnname, $columnid)
    // {
    //     $builder = $this->db->table($tableName);
    //     $builder->where($columnname, $columnid);
    //     if ($builder->update($data)) {
    //         return $columnid;
    //     } else {
    //         return false;
    //     }
    // }

    function updateData($data, $tablename, $columnname, $columnid)
    {
        // Get a reference to the database connection
        $db = \Config\Database::connect();

        // Start the update query
        $builder = $db->table($tablename);
        $builder->where($columnname, $columnid);

        // Perform the update operation
        if ($builder->update($data)) {
            return $columnid;
        } else {
            return false;
        }
    }

    function updateUserDeviceData($filterArray = array())
    {
        // Get a reference to the database connection
        $tableName = isset($filterArray['tbl_name']) ? $filterArray['tbl_name'] : '';
        $userId = isset($filterArray['user_id']) ? $filterArray['user_id'] : 0;
        $userTypeId = isset($filterArray['user_type_id']) ? $filterArray['user_type_id'] : 0;
        $userSocietyId = isset($filterArray['user_society_id']) ? $filterArray['user_society_id'] : 0;

        $db = \Config\Database::connect();
        
        $builder = $db->table($tableName);
        $dataUserDeviceInfo = [
            'is_latest' => 0,
        ];

        // $builder->where('user_id', $userId);
        $builder->where('user_type_id', $userTypeId);
        $builder->where('user_society_id', $userSocietyId);
        if ($builder->update($dataUserDeviceInfo)){
            return true;
        } else {
            return false;
        }


        
    }

    public function insertData($data,$tablename)
    {
        $db = \Config\Database::connect();
        $builder = $db->table($tablename);

        if ($builder->insert($data)) {
            return $db->insertID();
        } else {
            return false;
        }
    }


    public function getForumData($filterData = array())
    {
        $ownershipFlatMemberId = isset($filterData['ownership_flat_member_id']) ? $filterData['ownership_flat_member_id'] : 0;
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_forum as tf');
        $builder->select("tf.*");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->select("(SELECT count(*) FROM tbl_likes as tl WHERE tl.type = 'forum' AND tl.type_id = tf.forum_id AND tl.ownership_flat_member_id = '". $ownershipFlatMemberId ."') as is_likes");
        $builder->select("(SELECT count(*) FROM tbl_follow as tf WHERE tf.type = 'forum' AND tf.type_id = tf.forum_id AND tf.followed_id = '". $ownershipFlatMemberId ."') as is_following");
        $builder->select("(SELECT count(*) FROM tbl_likes as tl WHERE tl.type = 'forum' AND tl.type_id = tf.forum_id) as total_likes");
        $builder->select("(SELECT count(*) FROM tbl_comment as tc WHERE tc.type = 'forum' AND tc.type_id = tf.forum_id AND tc.is_deleted = 0) as total_comments");

        $builder->select("(CASE WHEN tf.type = 'manager' THEN concat(COALESCE(tu.first_name,''),' ',COALESCE(tu.last_name,'')) WHEN tf.type = 'member' THEN  COALESCE(tm.name, '') END) as ownership_flat_member_name,tf.type");

        $builder->select("(CASE WHEN tf.type = 'member' THEN  COALESCE(tm.member_image,'') END) as member_image");

        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tf.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tf.created_by","left");
        $builder->join("tbl_ownership_flat_member as tofw","tofw.ownership_flat_member_id = tf.type_id AND tf.type = 'member'","left");
        $builder->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofw.member_id","left");
        $builder->join("society_user_master_view as tu","tu.user_id = tf.type_id AND tf.type = 'manager'","left");
        $builder->where("is_deleted",0);

        if (isset($filterData['forum_id']) && !empty($filterData['forum_id'])) {
            if (is_array($filterData['forum_id'])) {
                $builder->whereIn('tf.forum_id', $filterData['forum_id']);
            } else {
                $builder->where('tf.forum_id', $filterData['forum_id']);
            }
        }


        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tf.society_id', $filterData['society_id']);
            } else {
                $builder->where('tf.society_id', $filterData['society_id']);
            }
        }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->like('tf.title', $filterData['search'], 'both');
            $builder->orLike('tf.description', $filterData['search'], 'both');
            $builder->groupEnd();
        }
        if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
            $builder->where('tf.is_active', $filterData['is_active']);
        }
        // if(isset($filterData['is_deleted']) && $filterData['is_deleted'] == 1){
        //     $builder->where('tf.is_deleted', $filterData['is_deleted']);
        // }
        $builder->orderBy("tf.forum_id",'desc');
        $builder->groupBy('tf.forum_id');
        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function deleteForumRecord($forumId,$userId)
    {
        $builder = $this->db->table('tbl_forum');
        $builder->whereIn('forum_id', $forumId);
        $data = [
            'is_deleted' => 1,
            'updated_at'  => date("Y-m-d H:i:s"),
            'updated_by'  => $userId,
        ];
        $builder->update($data);
        // $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        }
        $response['success'] = false;
        return $response;
    }

    public function deleteUserSocietyFlatRecord($userSocietyId,$userId)
    {
        
        $builder = $this->db->table(MASTER_DB.'.tbl_user_society');
        $builder->where('user_society_id', $userSocietyId);
        $data = [
            'is_delete' => 1,
            'updated_at'  => date("Y-m-d H:i:s"),
            'updated_by'  => $userId,
        ];
        $builder->update($data);
        // $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        }
        $response['success'] = false;
        return $response;
    }

    public function deleteCommentRecord($filterData  = array())
    {
        $commentId = isset($filterData['comment_id']) ? $filterData['comment_id'] : array();
        $userId = isset($filterData['user_id']) ? $filterData['user_id'] : 0;
        $builder = $this->db->table('tbl_comment');
        $data = [
            'is_deleted' => 1,
            'updated_at'  => date("Y-m-d H:i:s"),
            'updated_by'  => $userId,
        ];

        $builder->where('comment_id', $commentId);
        $builder->orWhere('parent_comment_id', $commentId);
        $builder->update($data);

        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        }
        $response['success'] = false;
        return $response;
    }

    public function deleteUserPermission($userPermissionId)
    {
        $builder = $this->db->table(MASTER_DB.'.tbl_user_permission');
        $userPermissionIdArray = is_array($userPermissionId) ? $userPermissionId : array($userPermissionId);
        $builder->whereIn('user_permission_id', $userPermissionIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($userPermissionId)){
                foreach($userPermissionId as $userPermission){
                    $deleteDataArray['module'] = 'User Permissions';
                    $deleteDataArray['activity'] = "User Permissions Deleted";
                    $deleteDataArray['module_id'] = $userPermission;
                    logActivity('User Permissions Deleted [UserPermissionId: ' . $userPermission . ']',$this->ionAuth->getUserId(),'User Permissions',$userPermission,json_encode($deleteDataArray),'','User Permissions',$userPermission);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteUserGroups($userSocietyId)
    {
        $builder = $this->db->table(MASTER_DB.'.tbl_users_groups');
        $userSocietyIdArray = is_array($userSocietyId) ? $userSocietyId : array($userSocietyId);
        $builder->whereIn('user_society_id', $userSocietyIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($userSocietyId)){
                foreach($userSocietyId as $userPermission){
                    $deleteDataArray['module'] = 'User Permissions';
                    $deleteDataArray['activity'] = "User Permissions Deleted";
                    $deleteDataArray['module_id'] = $userPermission;
                    logActivity('User Permissions Deleted [userSocietyId: ' . $userPermission . ']',$this->ionAuth->getUserId(),'User Permissions',$userPermission,json_encode($deleteDataArray),'','User Permissions',$userPermission);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteNotificationStoreRecord($userDeviceNotificationConfigId,$userId = 0,$societyId = 0)
    {   
        $userDeviceNotificationConfigIdArray = is_array($userDeviceNotificationConfigId) ? $userDeviceNotificationConfigId : array($userDeviceNotificationConfigId);
        
        $builder = $this->db->table(MASTER_DB.'.tbl_user_device_notification_config');
        $builder->whereIn('user_device_notification_config_id', $userDeviceNotificationConfigId);
        $ids = is_array($userDeviceNotificationConfigId) ? implode(',',$userDeviceNotificationConfigId) : $userDeviceNotificationConfigId;
        $builder->delete();

        if ($this->db->affectedRows()) {

            if(!empty($userDeviceNotificationConfigId)){
                foreach($userDeviceNotificationConfigId as $notification){
                    $deleteDataArray['module'] = 'Notification';
                    $deleteDataArray['activity'] = "Notification Deleted";
                    $deleteDataArray['module_id'] = $notification;
                    $userId = (empty($userId)) ? $this->ionAuth->getUserId() : $userId;
                    logActivity('Notification Deleted [NotificationID: ' . $notification . ']',$userId,'Notification',$notification,json_encode($deleteDataArray),'','Notification',$notification,$societyId);
                }
            }
            return true;
        }
        return false;
    }


    public function getLikesData($filterData = array())
    {

        $builder = $this->db->table('tbl_likes as tl');
        $builder->select("tl.*");


        if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
            if (is_array($filterData['ownership_flat_member_id'])) {
                $builder->whereIn('tl.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            } else {
                $builder->where('tl.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            }
        }


        if (isset($filterData['type']) && !empty($filterData['type'])) {
            if (is_array($filterData['type'])) {
                $builder->whereIn('tl.type', $filterData['type']);
            } else {
                $builder->where('tl.type', $filterData['type']);
            }
        }

        if (isset($filterData['type_id']) && !empty($filterData['type_id'])) {
            if (is_array($filterData['type_id'])) {
                $builder->whereIn('tl.type_id', $filterData['type_id']);
            } else {
                $builder->where('tl.type_id', $filterData['type_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tl.society_id', $filterData['society_id']);
            }
        }


        $builder->groupBy('tl.likes_id');
        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getUserGroupData($filterData = array())
    {

        $builder = $this->db->table(MASTER_DB.'.tbl_users_groups as tug');
        $builder->select("tug.*");


        if (isset($filterData['user_id']) && !empty($filterData['user_id'])) {
            if (is_array($filterData['user_id'])) {
                $builder->whereIn('tug.user_id', $filterData['user_id']);
            } else {
                $builder->where('tug.user_id', $filterData['user_id']);
            }
        }

        if (isset($filterData['user_society_id']) && !empty($filterData['user_society_id'])) {
            if (is_array($filterData['user_society_id'])) {
                $builder->whereIn('tug.user_society_id', $filterData['user_society_id']);
            } else {
                $builder->where('tug.user_society_id', $filterData['user_society_id']);
            }
        }


        if (isset($filterData['group_id']) && !empty($filterData['group_id'])) {
            if (is_array($filterData['group_id'])) {
                $builder->whereIn('tug.group_id', $filterData['group_id']);
            } else {
                $builder->where('tug.group_id', $filterData['group_id']);
            }
        }

        $builder->groupBy('tug.id');
        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getTotalLikesData($filterData = array())
    {

        $builder = $this->db->table('tbl_likes as tl');
        $builder->select("COUNT(tl.likes_id) AS total_likes");

        // if (isset($filterData['user_id']) && !empty($filterData['user_id'])) {
        //     if (is_array($filterData['user_id'])) {
        //         $builder->whereIn('tl.user_id', $filterData['user_id']);
        //     } else {
        //         $builder->where('tl.user_id', $filterData['user_id']);
        //     }
        // }
        if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
            if (is_array($filterData['ownership_flat_member_id'])) {
                $builder->whereIn('tl.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            } else {
                $builder->where('tl.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            }
        }


        if (isset($filterData['type']) && !empty($filterData['type'])) {
            if (is_array($filterData['type'])) {
                $builder->whereIn('tl.type', $filterData['type']);
            } else {
                $builder->where('tl.type', $filterData['type']);
            }
        }

        if (isset($filterData['type_id']) && !empty($filterData['type_id'])) {
            if (is_array($filterData['type_id'])) {
                $builder->whereIn('tl.type_id', $filterData['type_id']);
            } else {
                $builder->where('tl.type_id', $filterData['type_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tl.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }

        return $queryData;
    }

    public function deleteLikesRecord($likesId)
    {
        $likesIdArray = is_array($likesId) ? $likesId : array($likesId);
        $builder = $this->db->table('tbl_likes');
        $builder->whereIn('likes_id',$likesIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }

    }

    public function deleteForumImageRecord($documentImageId)
    {
        $documentImageIdArray = is_array($documentImageId) ? $documentImageId : array($documentImageId);
        $builder = $this->db->table('tbl_document_image');
        $builder->whereIn('document_image_id',$documentImageIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }


    public function getCommentData($filterData = array())
    {
        $ownershipFlatMemberId = isset($filterData['ownership_flat_member_id']) ? $filterData['ownership_flat_member_id'] : 0;
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_comment as tc');
        $builder->select("tc.*,tc.created_by as comment_created_by");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        // $builder->select("COALESCE(tc.comment_id,0) as parent_id,COALESCE(tc.message,'') as parent_comment");
        $builder->select("COALESCE(tm.name,'') as ownership_flat_member_name,COALESCE(tm.member_image,'') as member_image");

        $builder->select("(SELECT count(*) FROM tbl_likes as tl WHERE tl.type = 'comment' AND tl.type_id = tc.comment_id AND tl.ownership_flat_member_id = '". $ownershipFlatMemberId ."') as is_likes");
        $builder->select("(SELECT count(*) FROM tbl_likes as tl WHERE tl.type = 'comment' AND tl.type_id = tc.comment_id) as total_likes");
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tc.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tc.created_by","left");
        // $builder->join("tbl_comment as tcp","tcp.parent_comment_id = tc.comment_id","left");
        $builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tc.ownership_flat_member_id","left");
        $builder->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");


        if (isset($filterData['comment_id']) && !empty($filterData['comment_id'])) {
            if (is_array($filterData['comment_id'])) {
                $builder->whereIn('tc.comment_id', $filterData['comment_id']);
            } else {
                $builder->where('tc.comment_id', $filterData['comment_id']);
            }
        }

        if (isset($filterData['parent_comment_id']) && !empty($filterData['parent_comment_id'])) {
            if (is_array($filterData['parent_comment_id'])) {
                $builder->whereIn('tc.parent_comment_id', $filterData['parent_comment_id']);
            } else {
                $builder->where('tc.parent_comment_id', $filterData['parent_comment_id']);
            }
        }

        if (isset($filterData['type']) && !empty($filterData['type'])) {
            if (is_array($filterData['type'])) {
                $builder->whereIn('tc.type', $filterData['type']);
            } else {
                $builder->where('tc.type', $filterData['type']);
            }
        }

        if (isset($filterData['type_id']) && !empty($filterData['type_id'])) {
            if (is_array($filterData['type_id'])) {
                $builder->whereIn('tc.type_id', $filterData['type_id']);
            } else {
                $builder->where('tc.type_id', $filterData['type_id']);
            }
        }

        if (isset($filterData['is_deleted'])) {
            if (is_array($filterData['is_deleted'])) {
                $builder->whereIn('tc.is_deleted', $filterData['is_deleted']);
            } else {
                $builder->where('tc.is_deleted', $filterData['is_deleted']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tc.society_id', $filterData['society_id']);
            } else {
                $builder->where('tc.society_id', $filterData['society_id']);
            }
        }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->like('tc.message', $filterData['search'], 'both');
            $builder->groupEnd();
        }
        if(isset($filterData['is_delete']) && $filterData['is_delete'] == 1){
            $builder->where('tc.is_delete', $filterData['is_delete']);
        }
        $builder->orderBy("tc.comment_id",'desc');
        $builder->groupBy('tc.comment_id');
        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function getFollowData($filterData = array())
    {
        $builder = $this->db->table('tbl_follow as tf');
        $builder->select("tf.*,tm.member_id");
        $builder->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tf.followed_id","left");
        $builder->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofm.member_id","left");

        if (isset($filterData['followed_id']) && !empty($filterData['followed_id'])) {
            if (is_array($filterData['followed_id'])) {
                $builder->whereIn('tf.followed_id', $filterData['followed_id']);
            } else {
                $builder->where('tf.followed_id', $filterData['followed_id']);
            }
        }


        if (isset($filterData['type']) && !empty($filterData['type'])) {
            if (is_array($filterData['type'])) {
                $builder->whereIn('tf.type', $filterData['type']);
            } else {
                $builder->where('tf.type', $filterData['type']);
            }
        }

        if (isset($filterData['type_id']) && !empty($filterData['type_id'])) {
            if (is_array($filterData['type_id'])) {
                $builder->whereIn('tf.type_id', $filterData['type_id']);
            } else {
                $builder->where('tf.type_id', $filterData['type_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tf.society_id', $filterData['society_id']);
            } else {
                $builder->where('tf.society_id', $filterData['society_id']);
            }
        }


        $builder->groupBy('tf.follow_id');
        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function deleteFollowRecord($followId)
    {
        $followIdArray = is_array($followId) ? $followId : array($followId);
        $builder = $this->db->table('tbl_follow');
        $builder->whereIn('follow_id',$followIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }

    }

    public function getTotalBookmarkData($filterData = array())
    {

        $builder = $this->db->table('tbl_bookmark as tb');
        $builder->select("COUNT(tb.bookmark_id) AS total_bookmark");

        if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
            if (is_array($filterData['ownership_flat_member_id'])) {
                $builder->whereIn('tb.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            } else {
                $builder->where('tb.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            }
        }


        if (isset($filterData['type']) && !empty($filterData['type'])) {
            if (is_array($filterData['type'])) {
                $builder->whereIn('tb.type', $filterData['type']);
            } else {
                $builder->where('tb.type', $filterData['type']);
            }
        }

        if (isset($filterData['type_id']) && !empty($filterData['type_id'])) {
            if (is_array($filterData['type_id'])) {
                $builder->whereIn('tb.type_id', $filterData['type_id']);
            } else {
                $builder->where('tb.type_id', $filterData['type_id']);
            }
        }

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tb.society_id', $filterData['society_id']);
            } else {
                $builder->where('tb.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getTotalUnreadData($filterData = array())
    {

        $ownershipFlatMemberId = isset($filterData['ownership_flat_member_id']) ? $filterData['ownership_flat_member_id'] : 0;
        $builder = $this->db->table('tbl_notice as tn');
        $builder->select("COUNT(tn.notice_id) AS total_unread");

        $builder->where('tn.notice_id NOT IN(SELECT tdr.type_id  FROM tbl_document_read as tdr WHERE tdr.type_id != 0 AND tdr.type ="notice" AND tdr.ownership_flat_member_id="'.$ownershipFlatMemberId.'")',null,false);

        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tn.society_id', $filterData['society_id']);
            } else {
                $builder->where('tn.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getEmergencyData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_emergency_number as tem');
        $builder->select("tem.*");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");

        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tem.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tem.created_by","left");


        if (isset($filterData['emergency_number_id']) && !empty($filterData['emergency_number_id'])) {
            if (is_array($filterData['emergency_number_id'])) {
                $builder->whereIn('tem.emergency_number_id', $filterData['emergency_number_id']);
            } else {
                $builder->where('tem.emergency_number_id', $filterData['emergency_number_id']);
            }
        }

        if(isset($filterData['is_deleted'])){
            $builder->where('tem.is_deleted', $filterData['is_deleted']);
        }


        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tem.society_id', $filterData['society_id']);
            } else {
                $builder->where('tem.society_id', $filterData['society_id']);
            }
        }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if (isset($filterData['search']) && $filterData['search'] != '') {
            $builder->groupStart();
            $builder->like('tem.name', $filterData['search'], 'both');
            $builder->orLike('tem.description', $filterData['search'], 'both');
            $builder->groupEnd();
        }
        if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
            $builder->where('tem.is_active', $filterData['is_active']);
        }
        $builder->orderBy("tem.emergency_number_id",'desc');
        $builder->groupBy('tem.emergency_number_id');
        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getDocumentReadData($filterData = array())
    {
        $builder = $this->db->table('tbl_document_read as tdr');
        $builder->select("tdr.*");
        if (isset($filterData['ownership_flat_member_id']) && !empty($filterData['ownership_flat_member_id'])) {
            if (is_array($filterData['ownership_flat_member_id'])) {
                $builder->whereIn('tdr.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            } else {
                $builder->where('tdr.ownership_flat_member_id', $filterData['ownership_flat_member_id']);
            }
        }
        if (isset($filterData['type']) && !empty($filterData['type'])) {
            if (is_array($filterData['type'])) {
                $builder->whereIn('tdr.type', $filterData['type']);
            } else {
                $builder->where('tdr.type', $filterData['type']);
            }
        }
        if (isset($filterData['type_id']) && !empty($filterData['type_id'])) {
            if (is_array($filterData['type_id'])) {
                $builder->whereIn('tdr.type_id', $filterData['type_id']);
            } else {
                $builder->where('tdr.type_id', $filterData['type_id']);
            }
        }
        // $builder->groupBy('tdr.document_read_id');
        if (isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        } else {
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getUserPermissionData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table( MASTER_DB.'.tbl_user_permission as tup');
        $builder->select('tup.*');
        if(isset($filterData['user_id']) && !empty($filterData['user_id'])) {
            if (is_array($filterData['user_id'])) {
                $builder->whereIn('tup.user_id', $filterData['user_id']);
            } else {
                $builder->where('tup.user_id', $filterData['user_id']);
            }
        }

        if(isset($filterData['group_id']) && !empty($filterData['group_id'])) {
            if (is_array($filterData['group_id'])) {
                $builder->whereIn('tup.group_id', $filterData['group_id']);
            } else {
                $builder->where('tup.group_id', $filterData['group_id']);
            }
        }

        if(isset($filterData['user_society_id']) && !empty($filterData['user_society_id'])) {
            if (is_array($filterData['user_society_id'])) {
                $builder->whereIn('tup.user_society_id', $filterData['user_society_id']);
            } else {
                $builder->where('tup.user_society_id', $filterData['user_society_id']);
            }
        }
        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function deleteUserRelatedRecord($userId)
    {
        
        $userIdArray = is_array($userId) ? $userId : array($userId);

        $builder = $this->db->table( MASTER_DB.'.tbl_users_groups');
        $builder->whereIn('user_id', $userIdArray);
        $builder->delete();

        $builder = $this->db->table( MASTER_DB.'.tbl_user_society');
        $builder->whereIn('user_id', $userIdArray);
        $builder->delete();

        $builder = $this->db->table( MASTER_DB.'.tbl_user_permission');
        $builder->whereIn('user_id', $userIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteUserSocietyWiseRelatedRecord($userId,$societyId)
    {
        
        $userIdArray = is_array($userId) ? $userId : array($userId);
        $societyIdArray = is_array($societyId) ? $societyId : array($societyId);

        $builder = $this->db->table( MASTER_DB.'.tbl_users_groups');
        $builder->whereIn('user_id', $userIdArray);
        // $builder->orWhereIn('society_id', $societyIdArray);
        $builder->delete();

        $builder = $this->db->table( MASTER_DB.'.tbl_user_society');
        $builder->whereIn('user_id', $userIdArray);
        $builder->orWhereIn('society_id', $societyIdArray);
        $builder->delete();

        $builder = $this->db->table( MASTER_DB.'.tbl_user_permission');
        $builder->whereIn('user_id', $userIdArray);
        // $builder->orWhereIn('society_id', $societyIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteUserRecord($userId)
    {
        
        $userIdArray = is_array($userId) ? $userId : array($userId);

        $builder = $this->db->table( MASTER_DB.'.tbl_users');
        $builder->whereIn('id', $userIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteUserSocietyRecord($userSocietyId)
    {
        
        $userSocietyIdArray = is_array($userSocietyId) ? $userSocietyId : array($userSocietyId);

        $builder = $this->db->table( MASTER_DB.'.tbl_user_society');
        $builder->whereIn('user_society_id', $userSocietyIdArray);
        $builder->delete();

        $builder = $this->db->table(MASTER_DB.'.tbl_user_permission');
        $builder->whereIn('user_society_id', $userSocietyIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteUserGroupRecord($groupId)
    {
        
        $groupIdArray = is_array($groupId) ? $groupId : array($groupId);

        $builder = $this->db->table( MASTER_DB.'.tbl_users_groups');
        $builder->whereIn('group_id', $groupIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
    public function deletUserGroupRecord($userSocietyGroupId)
    {
        
        $userSocietyGroupIdArray = is_array($userSocietyGroupId) ? $userSocietyGroupId : array($userSocietyGroupId);

        $builder = $this->db->table( MASTER_DB.'.tbl_user_society');
        $builder->whereIn('user_society_id', $userSocietyGroupIdArray);
        $builder->delete();

        $builder = $this->db->table( MASTER_DB.'.tbl_users_groups');
        $builder->whereIn('user_society_id', $userSocietyGroupIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function deleteUserSocietyPermissionRecord($userSocietyId)
    {
        
        $userSocietyIdArray = is_array($userSocietyId) ? $userSocietyId : array($userSocietyId);
        // printArray($userSocietyIdArray,1);

        $builder = $this->db->table(MASTER_DB.'.tbl_user_permission');
        $builder->whereIn('user_society_id', $userSocietyIdArray);
        $builder->delete();
        // PRINTaRRAY($builder,1);
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function userSocietyStatusChange($userSocietyId,$userId,$status = 0)
    {
        $userSocietyIdArray = is_array($userSocietyId) ? $userSocietyId : array($userSocietyId);
        $builder = $this->db->table( MASTER_DB.'.tbl_user_society');
        $builder->whereIn('user_society_id', $userSocietyIdArray);
        $data = [
            'is_active' => $status,
            'updated_at'  => date("Y-m-d H:i:s"),
            'updated_by'  => $userId,
        ];
        $builder->update($data);
        // $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        }
        $response['success'] = false;
        return $response;
    }


}
