<?php
namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class CommonKeysModel extends BaseModel
{
	public function __construct()
	{
		parent::__construct();
		// Your own constructor code
	}
	public function getCommonKeysData($filterData = array())
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_common_keys as tck');
        $builder->select("tck.*,ts.society_name,GROUP_CONCAT(COALESCE(tcka.keys_name,'') SEPARATOR ', ') as keys_name,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
		$builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tck.society_id","left");
		$builder->join("tbl_common_keys_availability as tcka","tcka.common_keys_id = tck.common_keys_id","left");
		$builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tck.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tck.created_by","left");
		if (isset($filterData['common_keys_id']) && !empty($filterData['common_keys_id'])) {
			if (is_array($filterData['common_keys_id'])) {
				$builder->whereIn('tck.common_keys_id', $filterData['common_keys_id']);
			} else {
				$builder->where('tck.common_keys_id', $filterData['common_keys_id']);
			}
		}
		if (isset($filterData['start'])) {
			if ($filterData['start'] != '1') {
				$builder->limit($limit, $filterData['start'] * $limit);
			}
		}
		if (isset($filterData['search']) && $filterData['search'] != '') {
			$builder->groupStart();
			$builder->like('ts.society_name', $filterData['search'], 'both');
			$builder->groupEnd();
		}
		if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
			$builder->where('tck.is_active', $filterData['is_active']);
		}
		$builder->groupBy('tck.common_keys_id');
		accessFilter($builder, array("society" => "tck.society_id"));
		if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
		return $queryData;
	}

	public function getCommonKeysIssueData($filterData = array())
	{

		$builder = $this->db->table('tbl_common_keys_availability as tcka');
		$builder->select("tcka.*,COALESCE(tki.key_issue,'') as key_issue_name");
		$builder->join("(SELECT MAX(vtki.key_issue_id) as key_issue_id,common_keys_availability_id
             FROM tbl_key_issue as vtki
             GROUP BY vtki.common_keys_id,vtki.common_keys_availability_id    
              ) AS v_issue", "v_issue.common_keys_availability_id =  tcka.common_keys_availability_id", "left");
		$builder->join("tbl_key_issue as tki","tki.key_issue_id = v_issue.key_issue_id","left");

		if (isset($filterData['common_keys_id']) && !empty($filterData['common_keys_id'])) {
			if (is_array($filterData['common_keys_id'])) {
				$builder->whereIn('tcka.common_keys_id', $filterData['common_keys_id']);
			} else {
				$builder->where('tcka.common_keys_id', $filterData['common_keys_id']);
			}
		}
		accessFilter($builder, array("society" => "tki.society_id"));
		$builder->groupBy('tcka.common_keys_availability_id');
		if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
			$queryData = $builder->get()->getResultArray();
		}else{
			$queryData = $builder->get()->getRowArray();
		}
		return $queryData;
	}

	public function deleteRecord($commonKeysId)
	{
		$builder = $this->db->table('tbl_common_keys_availability');
        $builder->whereIn('common_keys_id', $commonKeysId);
        $builder->delete();

		$builder = $this->db->table('tbl_common_keys');
        $commonKeysIdArray = is_array($commonKeysId) ? $commonKeysId : array($commonKeysId);
        $builder->whereIn('common_keys_id', $commonKeysIdArray);
        $builder->delete();
		if ($this->db->affectedRows()) {
			if(!empty($commonKeysId)){
				foreach($commonKeysId as $commonKeys){
					$deleteDataArray['module'] = 'Common Keys';
            		$deleteDataArray['activity'] = "Common Keys Deleted";
					$deleteDataArray['module_id'] = $commonKeys;
					logActivity('Common Keys Deleted [CommonKeysID: ' . $commonKeys . ']',$this->ionAuth->getUserId(),'Common Keys',$commonKeys,json_encode($deleteDataArray),'','Common Keys',$commonKeys);
				}
			}
			return true;
		}
		return false;
	}

	public function getCommonKeysAvailabilityData($filterData)
	{
		$builder = $this->db->table('tbl_common_keys_availability as tcka');
		$builder->select("tcka.*");
		$builder->join("tbl_common_keys as tck","tcka.common_keys_id = tck.common_keys_id","left");
		

		if(isset($filterData['common_keys_id']) && !empty($filterData['common_keys_id'])) {
			if (is_array($filterData['common_keys_id'])) {
				$builder->whereIn('tcka.common_keys_id', $filterData['common_keys_id']);
			} else {
				$builder->where('tcka.common_keys_id', $filterData['common_keys_id']);
			}
		}

		if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
			if (is_array($filterData['society_id'])) {
				$builder->whereIn('tck.society_id', $filterData['society_id']);
			} else {
				$builder->where('tck.society_id', $filterData['society_id']);
			}
		}

		if(isset($filterData['common_keys_availability_id']) && !empty($filterData['common_keys_availability_id'])) {
			if (is_array($filterData['common_keys_availability_id'])) {
				$builder->whereIn('tcka.common_keys_availability_id', $filterData['common_keys_availability_id']);
			} else {
				$builder->where('tcka.common_keys_availability_id', $filterData['common_keys_availability_id']);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

	public function deleteCommonKeysAvailabilityRecord($CommonKeysAvailabilityId,$commonKeysId = '')
	{
		$builder = $this->db->table('tbl_common_keys_availability');
        $CommonKeysAvailabilityIdArray = is_array($CommonKeysAvailabilityId) ? $CommonKeysAvailabilityId : array($CommonKeysAvailabilityId);
        $builder->whereIn('common_keys_availability_id', $CommonKeysAvailabilityIdArray);
        $builder->delete();

		$ids = is_array($CommonKeysAvailabilityId) ? implode(',',$CommonKeysAvailabilityId) : $CommonKeysAvailabilityId;
		
		if ($this->db->affectedRows()) {

			if(!empty($CommonKeysAvailabilityId)){
				foreach($CommonKeysAvailabilityId as $keysElement){
					$deleteDataArray['module'] = 'Common Keys Availability';
					$deleteDataArray['activity'] = "Common Keys Availability Deleted";
					$deleteDataArray['module_id'] = $keysElement;
					logActivity('Common Keys Availability Deleted [CommonKeysID: ' . $keysElement . ']',$this->ionAuth->getUserId(),'Common Keys Availability',$keysElement,json_encode($deleteDataArray),'','Common Keys',$commonKeysId);
				}
			}
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}

	function getCommonKeys($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_common_keys as tck');
        //$builder->startCache();
        $builder->select("tck.common_keys_id as id,COALESCE(tck.description,'') as text,tck.society_id,ts.society_name");
        $builder->join(MASTER_DB.".tbl_society as ts","ts.society_id = tck.society_id","left");

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tck.society_id', $filterData['society_id']);
            } else {
                $builder->where('tck.society_id', $filterData['society_id']);
            }
        }

        if (isset($filterData['common_keys_id']) && !empty($filterData['common_keys_id'])) {
            if (is_array($filterData['common_keys_id'])) {
                $builder->whereIn('tck.common_keys_id', $filterData['common_keys_id']);
            } else {
                $builder->where('tck.common_keys_id', $filterData['common_keys_id']);
            }
        }
        accessFilter($builder, array("society" => "tck.society_id"));
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tck.description,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tck.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    function getCommonKeysAvailability($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_common_keys_availability as tcka');
        //$builder->startCache();
        $builder->select("tcka.common_keys_availability_id as id,COALESCE(tcka.keys_name,'') as text");
        $builder->join("tbl_common_keys as tck","tck.common_keys_id = tcka.common_keys_id","left");

        if (isset($filterData['common_keys_id']) && !empty($filterData['common_keys_id'])) {
            if (is_array($filterData['common_keys_id'])) {
                $builder->whereIn('tcka.common_keys_id', $filterData['common_keys_id']);
            } else {
                $builder->where('tcka.common_keys_id', $filterData['common_keys_id']);
            }
        }

        if (isset($filterData['common_keys_availability_id']) && !empty($filterData['common_keys_availability_id'])) {
            if (is_array($filterData['common_keys_availability_id'])) {
                $builder->whereIn('tcka.common_keys_availability_id', $filterData['common_keys_availability_id']);
            } else {
                $builder->where('tcka.common_keys_availability_id', $filterData['common_keys_availability_id']);
            }
        }
        
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tcka.keys_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}
?>
