<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class BudgetModel extends BaseModel
{

	public function getBudgetData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_budget as tb');
        $builder->select("tb.*,tsoc.society_name,tfy.financial_year_prefix");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tb.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tb.created_by","left");
        $builder->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = tb.society_id","left");
        $builder->join("tbl_financial_year as tfy","tfy.financial_year_id = tb.financial_year_id","left");

        if (isset($filterData['budget_id']) && !empty($filterData['budget_id'])) {
            if (is_array($filterData['budget_id'])) {
                $builder->whereIn('tb.budget_id', $filterData['budget_id']);
            } else {
                $builder->where('tb.budget_id', $filterData['budget_id']);
            }
        }
        if (isset($filterData['budget_id_not']) && !empty($filterData['budget_id_not'])) {
            if (is_array($filterData['budget_id_not'])) {
                $builder->whereNotIn('tb.budget_id', $filterData['budget_id_not']);
            } else {
                $builder->where('tb.budget_id !=', $filterData['budget_id_not']);
            }
        }
        if (isset($filterData['financial_year_id']) && !empty($filterData['financial_year_id'])) {
            if (is_array($filterData['financial_year_id'])) {
                $builder->whereIn('tb.financial_year_id', $filterData['financial_year_id']);
            } else {
                $builder->where('tb.financial_year_id', $filterData['financial_year_id']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tb.society_id', $filterData['society_id']);
            } else {
                $builder->where('tb.society_id', $filterData['society_id']);
            }
        }
    
        if (isset($filterData['start'])) {
            if ($filterData['start'] != '1') {
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        $builder->groupBy('tb.budget_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
	

	public function deleteRecord($budgetId)
    {
        $budgetIdArray = is_array($budgetId) ? $budgetId : array($budgetId);
        $builder = $this->db->table('tbl_budget');
        $builder->whereIn('budget_id', $budgetIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($budgetId)){
                foreach($budgetId as $documentElement){
                    $deleteDataArray['module'] = 'Budget';
                    $deleteDataArray['activity'] = "Budget Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Budget Deleted [BudgetID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Budget',$documentElement,json_encode($deleteDataArray),'','Budget',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	function getBudget($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_account as tl');
        //$builder->startCache();
        $builder->select("tl.account_id as id,COALESCE(tl.account_name,'')  as text");
        if(isset($filterData['account_id']) && !empty($filterData['account_id'])) {
            if (is_array($filterData['account_id'])) {
                $builder->whereIn('tl.account_id', $filterData['account_id']);
            } else {
                $builder->where('tl.account_id', $filterData['account_id']);
            }
        }
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tl.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tl.account_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tl.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function getBudgetSubBudgetData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_account_sub_account as tlsl');
        $builder->select("tlsl.account_sub_account_id,tlsl.sub_account_id");
        $builder->select("concat(COALESCE(tl.sub_account_code,''),'-',COALESCE(tl.sub_account_name,'')) as sub_account_code_name");
        $builder->join('tbl_sub_account tl', 'tl.sub_account_id = tlsl.sub_account_id', 'left');

        if(isset($filterData['account_id']) && !empty($filterData['account_id'])) {
            if (is_array($filterData['account_id'])) {
                $builder->whereIn('tlsl.account_id', $filterData['account_id']);
            } else {
                $builder->where('tlsl.account_id', $filterData['account_id']);
            }
        }

        // if (isset($filterData['account_image_id']) && $filterData['account_image_id'] != '') {
        //     $builder->where("tmi.account_image_id", $filterData['account_image_id']);
        // }

        $builder->orderBy("tlsl.account_id");

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }

        return $query;
    }

    public function deleteBudgetSubAccountRecord($budgetId){
        $builder = $this->db->table('tbl_budget_sub_account');
        $budgetIdArray = is_array($budgetId) ? $budgetId : array($budgetId);
        $builder->whereIn('budget_id', $budgetIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function getAccountSubAccountData($filterData  = array()){
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_account_sub_account as tlsl');
        $builder->select("tlsl.account_sub_account_id,tlsl.sub_account_id,tlsl.account_id");
        $builder->select("concat(COALESCE(tsl.sub_account_code,''),'-',COALESCE(tsl.sub_account_name,'')) as sub_account_code_name");
        $builder->select("concat(COALESCE(tl.account_code,''),'-',COALESCE(tl.account_name,'')) as account_code_name");
        $builder->join('tbl_sub_account tsl', 'tsl.sub_account_id = tlsl.sub_account_id', 'left');
        $builder->join('tbl_account tl', 'tl.account_id = tlsl.account_id', 'left');

        if(isset($filterData['account_type']) && !empty($filterData['account_type'])) {
            if (is_array($filterData['account_type'])) {
                $builder->whereIn('tl.account_type', $filterData['account_type']);
            } else {
                $builder->where('tl.account_type', $filterData['account_type']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tl.society_id', $filterData['society_id']);
                $builder->whereIn('tsl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tl.society_id', $filterData['society_id']);
                $builder->where('tsl.society_id', $filterData['society_id']);
            }
        }

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }

        return $query;
    }

    public function getBudgetAccountSubAccountData($filterData  = array()){
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_budget_sub_account as tbsl');

        $builder->select("tbsl.sub_account_id,tbsl.account_id,tbsl.amount");

        $builder->select("concat(COALESCE(tsl.sub_account_code,''),'-',COALESCE(tsl.sub_account_name,'')) as sub_account_code_name");
        $builder->select("concat(COALESCE(tl.account_code,''),'-',COALESCE(tl.account_name,'')) as account_code_name");

        $builder->join('tbl_sub_account tsl', 'tsl.sub_account_id = tbsl.sub_account_id', 'left');
        // $builder->join('tbl_account_sub_account tlsl', 'tlsl.sub_account_id = tbsl.sub_account_id', 'left');
        $builder->join('tbl_account tl', 'tl.account_id = tbsl.account_id', 'left');

        if(isset($filterData['account_type']) && !empty($filterData['account_type'])) {
            if (is_array($filterData['account_type'])) {
                $builder->whereIn('tl.account_type', $filterData['account_type']);
            } else {
                $builder->where('tl.account_type', $filterData['account_type']);
            }
        }

        if(isset($filterData['budget_id']) && !empty($filterData['budget_id'])) {
            if (is_array($filterData['budget_id'])) {
                $builder->whereIn('tbsl.budget_id', $filterData['budget_id']);
            } else {
                $builder->where('tbsl.budget_id', $filterData['budget_id']);
            }
        }

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }

        return $query;
    }

}
?>
