<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class BankModel extends BaseModel
{

    public function getBankData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_bank as tb');
        $builder->select("tb.*");
        if (isset($filterData['bank_id']) && !empty($filterData['bank_id'])) {
            if (is_array($filterData['bank_id'])) {
                $builder->whereIn('tb.bank_id', $filterData['bank_id']);
            } else {
                $builder->where('tb.bank_id', $filterData['bank_id']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('tb.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('bank_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tb.bank_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }


    public function deleteRecord($bankId)
    {
        $builder = $this->db->table('tbl_bank');
        $bankIdArray = is_array($bankId) ? $bankId : array($bankId);
        $builder->whereIn('bank_id', $bankIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {

            if(!empty($bankId)){
                foreach($bankId as $bank){
                    $deleteDataArray['module'] = 'Bank';
                    $deleteDataArray['activity'] = "Bank Deleted";
                    $deleteDataArray['module_id'] = $bank;
                    logActivity('Bank Deleted [BankID: ' . $bank . ']',$this->ionAuth->getUserId(),'Bank',$bank,json_encode($deleteDataArray),'','Bank',$bank);
                }
            }

            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getBank($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_bank as tb');
        //$builder->startCache();
        $builder->select("tb.bank_id as id,COALESCE(tb.bank_name,'') as text");
        

        if (isset($filterData['bank_id']) && !empty($filterData['bank_id'])) {
            if (is_array($filterData['bank_id'])) {
                $builder->whereIn('tb.bank_id', $filterData['bank_id']);
            } else {
                $builder->where('tb.bank_id', $filterData['bank_id']);
            }
        }
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tb.bank_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tb.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResults(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}