<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class AreaModel extends BaseModel
{

    public function getAreaData($filterData = array())
    {

        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_area as ta');
        $builder->select("ta.*,ta.area_name as area,ConvertToTitleCase(ta.vehicle_type) as display_vehicle_type");
        //$builder->select("(ta.slot - (select count(tpp.parking_place_id) from tbl_parking_place as tpp where ta.area_id = tpp.area_id AND tpp.flat_id != 0 AND tpp.parking_place_id IN(SELECT tv.parking_place_id FROM tbl_visitor as tv where tv.status ='entered')      )) as available_slots");
        //$builder->select("(ta.slot - ((select count(tpp.parking_place_id) from tbl_parking_place as tpp where ta.area_id = tpp.area_id AND tpp.flat_id != 0)  +  (select count(tpp.parking_place_id) from tbl_parking_place as tpp where ta.area_id = tpp.area_id  AND tpp.parking_place_id IN(SELECT tv.parking_place_id FROM tbl_visitor as tv where tv.status ='entered')))) as available_slots");
        $builder->select("((
            (
                SELECT COUNT(tpp.parking_place_id) 
                FROM tbl_parking_place AS tpp 
                WHERE tpp.area_id = ta.area_id 
                AND tpp.flat_id = 0 
                AND tpp.is_visitor_parking = 1
            ) - 
            (
                SELECT COUNT(tpp.parking_place_id) 
                FROM tbl_parking_place AS tpp 
                WHERE tpp.area_id = ta.area_id
                AND tpp.parking_place_id IN (
                    SELECT tv.parking_place_id 
                    FROM tbl_visitor AS tv 
                    WHERE tv.status = 'entered'
                )
            )
        )) AS available_slots");
        
        if(isset($filterData['area_id']) && !empty($filterData['area_id'])) {
            if (is_array($filterData['area_id'])) {
                $builder->whereIn('ta.area_id', $filterData['area_id']);
            } else {
                $builder->where('ta.area_id', $filterData['area_id']);
            }
        }


        if(isset($filterData['area_name']) && !empty($filterData['area_name'])) {
            if (is_array($filterData['area_name'])) {
                $builder->whereIn('ta.area_name', $filterData['area_name']);
            } else {
                $builder->where('ta.area_name', $filterData['area_name']);
            }
        }

        if(isset($filterData['area_id_not']) && !empty($filterData['area_id_not'])) {
            if (is_array($filterData['area_id_not'])) {
                $builder->whereNotIn('ta.area_id', $filterData['area_id_not']);
            } else {
                $builder->where('ta.area_id !=', $filterData['area_id_not']);
            }
        }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ta.society_id', $filterData['society_id']);
            } else {
                $builder->where('ta.society_id', $filterData['society_id']);
            }
        }


        if(isset($filterData['vehicle_type']) && !empty($filterData['vehicle_type'])) {
            if (is_array($filterData['vehicle_type'])) {
                $builder->whereIn('ta.vehicle_type', $filterData['vehicle_type']);
            } else {
                $builder->where('ta.vehicle_type', $filterData['vehicle_type']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('ta.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('area_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('ta.area_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        // lastQuery();
        return $queryData;
    }


    public function deleteRecord($areaId)
    {
        $builder = $this->db->table('tbl_area');
        $areaIdArray = is_array($areaId) ? $areaId : array($areaId);
        $builder->whereIn('area_id', $areaIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($areaId)){
                foreach($areaId as $area){
                    $deleteDataArray['module'] = 'Common Area';
                    $deleteDataArray['activity'] = "Common Area Deleted";
                    $deleteDataArray['module_id'] = $area;
                    logActivity('Common Area Deleted [SocietyID: ' . $area . ']',$this->ionAuth->getUserId(),'Common Area',$area,json_encode($deleteDataArray),'','Common Area',$area);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getArea($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_area as ta');
        //$builder->startCache();
        $builder->select("ta.area_id as id,concat(COALESCE(ta.area_name,''),'-',ConvertToTitleCase(ta.vehicle_type)) as text");
        

        if(isset($filterData['area_id']) && !empty($filterData['area_id'])) {
            if (is_array($filterData['area_id'])) {
                $builder->whereIn('ta.area_id', $filterData['area_id']);
            } else {
                $builder->where('ta.area_id', $filterData['area_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(ta.area_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('ta.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
//        $builder->countAllResulta(false);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['total_count'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }
}