<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class AmenitiesModel extends BaseModel
{

    public function getAmenitiesData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_amenities as ta');
        $builder->select("ta.*,GROUP_CONCAT(tcm.common_area_name SEPARATOR ',') as common_area_name");
        //$builder->select("GROUP_CONCAT(distinct(tambsd.day) SEPARATOR ',') as day");
        $builder->select("'Everyday' as day,COALESCE(tt.tax_name,'') as tax_name,COALESCE(tt.tax_rate,'') as tax_rate");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->select("concat(COALESCE(tapprove.first_name,''),' ',COALESCE(tapprove.last_name,'')) as approved_by");
        $builder->select("concat(COALESCE(treject.first_name,''),' ',COALESCE(treject.last_name,'')) as rejected_by");
        $builder->join("tbl_amenities_common_area as tacm","tacm.amenities_id = ta.amenities_id","left");
        $builder->join("tbl_common_area as tcm","tcm.common_area_id = tacm.common_area_id","left");
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = ta.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = ta.created_by","left");
        $builder->join("society_user_master_view as tapprove","tapprove.user_society_id = ta.approved_by","left");
        $builder->join("society_user_master_view as treject","treject.user_society_id = ta.rejected_by","left");
        $builder->join("tbl_tax as tt","tt.tax_id = ta.tax_id","left");
      //  $builder->join("tbl_amenities_booking_slot_day as tambsd","tambsd.amenities_id = ta.amenities_id","left");


        if(isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
            if (is_array($filterData['amenities_id'])) {
                $builder->whereIn('ta.amenities_id', $filterData['amenities_id']);
            } else {
                $builder->where('ta.amenities_id', $filterData['amenities_id']);
            }
        }

        if(isset($filterData['admin_approval_required']) && $filterData['admin_approval_required'] != 0) {
            if (is_array($filterData['admin_approval_required'])) {
                $builder->whereIn('ta.admin_approval_required', $filterData['admin_approval_required']);
            } else {
                $builder->where('ta.admin_approval_required', $filterData['admin_approval_required']);
            }
        }
        
        // if(isset($filterData['type']) && !empty($filterData['type'])) {
        //     if (is_array($filterData['type'])) {
        //         $builder->whereIn('ta.type', $filterData['type']);
        //     } else {
        //         $builder->where('ta.type', $filterData['type']);
        //     }
        // }

        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('ta.society_id', $filterData['society_id']);
            } else {
                $builder->where('ta.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['status']) && !empty($filterData['status'])) {
            if (is_array($filterData['status'])) {
                $builder->whereIn('ta.status', $filterData['status']);
            } else {
                $builder->where('ta.status', $filterData['status']);
            }
        }

        if(isset($filterData['start'])){
            if($filterData['start'] != '-1'){
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }
        if(isset($filterData['is_active'])){
            $builder->where('ta.is_active', $filterData['is_active']);
        }

        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('ta.amenities_name', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('ta.amenities_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }

    public function getAmenitiesUnitData($filterData)
	{
		$builder = $this->db->table('tbl_amenities_unit as tau');
		$builder->select("tau.*");

		if(isset($filterData['amenities_unit_id']) && !empty($filterData['amenities_unit_id'])) {
			if (is_array($filterData['amenities_unit_id'])) {
				$builder->whereIn('tau.amenities_unit_id', $filterData['amenities_unit_id']);
			} else {
				$builder->where('tau.amenities_unit_id', $filterData['amenities_unit_id']);
			}
		}

		if(isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
			if (is_array($filterData['amenities_id'])) {
				$builder->whereIn('tau.amenities_id', $filterData['amenities_id']);
			} else {
				$builder->where('tau.amenities_id', $filterData['amenities_id']);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

    public function getAmenitiesBookingSlotUnitPriceData($filterData)
    {
        $builder = $this->db->table('tbl_amenities_booking_slot_unit_price as tabsup');
        $builder->select("tabsup.*");

        if(isset($filterData['amenities_booking_slot_unit_price_id']) && !empty($filterData['amenities_booking_slot_unit_price_id'])) {
            if (is_array($filterData['amenities_booking_slot_unit_price_id'])) {
                $builder->whereIn('tabsup.amenities_booking_slot_unit_price_id', $filterData['amenities_booking_slot_unit_price_id']);
            } else {
                $builder->where('tabsup.amenities_booking_slot_unit_price_id', $filterData['amenities_booking_slot_unit_price_id']);
            }
        }

        if(isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
            if (is_array($filterData['amenities_id'])) {
                $builder->whereIn('tabsup.amenities_id', $filterData['amenities_id']);
            } else {
                $builder->where('tabsup.amenities_id', $filterData['amenities_id']);
            }
        }
        if(isset($filterData['unit_id']) && !empty($filterData['unit_id'])) {
            if (is_array($filterData['unit_id'])) {
                $builder->whereIn('tabsup.unit_id', $filterData['unit_id']);
            } else {
                $builder->where('tabsup.unit_id', $filterData['unit_id']);
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();

            $builder->groupEnd();
        }

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function deleteAmenitiesUnitRecord($amenitiesUnitId)
	{
		$builder = $this->db->table('tbl_amenities_unit');
		$amenitiesUnitay = is_array($amenitiesUnitId) ? $amenitiesUnitId : array($amenitiesUnitId);
		$builder->whereIn('amenities_unit_id',$amenitiesUnitay);
		$builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

    public function deleteAmenitiesUnit($amenitiesId)
	{
		$builder = $this->db->table('tbl_amenities_unit');
		$amenitiesIdArray = is_array($amenitiesId) ? $amenitiesId : array($amenitiesId);
		$builder->whereIn('amenities_id',$amenitiesIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

    public function deleteAmenitiesBookingSlotUnitPrice($amenitiesId,$userId)
    {
        $builder = $this->db->table('tbl_amenities_booking_slot_unit_price');
        $amenitiesIdArray = is_array($amenitiesId) ? $amenitiesId : array($amenitiesId);
        $updateData = [
            'is_deleted' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
            // 'updated_by' => $this->data['userId']
            'updated_by' => $userId
        ];
        $builder->whereIn('amenities_id',$amenitiesIdArray);
        $builder->update($updateData);
        // $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }
    
    public function getAmenitiesBookingSlotData($filterData)
	{
		$builder = $this->db->table('tbl_amenities_booking_slot as tabs');
		$builder->select("tabs.*");

		if(isset($filterData['amenities_unit_id']) && !empty($filterData['amenities_unit_id'])) {
			if (is_array($filterData['amenities_unit_id'])) {
				$builder->whereIn('tabs.amenities_unit_id', $filterData['amenities_unit_id']);
			} else {
				$builder->where('tabs.amenities_unit_id', $filterData['amenities_unit_id']);
			}
		}

		if(isset($filterData['amenities_booking_slot_id']) && !empty($filterData['amenities_booking_slot_id'])) {
			if (is_array($filterData['amenities_booking_slot_id'])) {
				$builder->whereIn('tabs.amenities_booking_slot_id', $filterData['amenities_booking_slot_id']);
			} else {
				$builder->where('tabs.amenities_booking_slot_id', $filterData['amenities_booking_slot_id']);
			}
		}

		if(isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
			if (is_array($filterData['amenities_id'])) {
				$builder->whereIn('tabs.amenities_id', $filterData['amenities_id']);
			} else {
				$builder->where('tabs.amenities_id', $filterData['amenities_id']);
			}
		}

		if(isset($filterData['search']) && $filterData['search'] != ''){
			$builder->groupStart();

			$builder->groupEnd();
		}

        if(isset($filterData['is_deleted'])){
            $builder->where('tabs.is_deleted', $filterData['is_deleted']);
        }

		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

    public function deleteAmenitiesBookingSlotRecord($amenitiesBookingSlotId,$userId)
	{
		$builder = $this->db->table('tbl_amenities_booking_slot');
		$amenitiesBookingSlotay = is_array($amenitiesBookingSlotId) ? $amenitiesBookingSlotId : array($amenitiesBookingSlotId);
        $updateData = [
            'is_deleted' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
            // 'updated_by' => $this->data['userId']
            'updated_by' => $userId
        ];
		$builder->whereIn('amenities_booking_slot_id',$amenitiesBookingSlotay);
        $builder->update($updateData);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}

    public function deleteAmenitiesBookingSlot($amenitiesId,$userId)
	{
		$builder = $this->db->table('tbl_amenities_booking_slot');
		$amenitiesIdArray = is_array($amenitiesId) ? $amenitiesId : array($amenitiesId);
        $updateData = [
            'is_deleted' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' => $userId
        ];
		$builder->whereIn('amenities_id',$amenitiesIdArray);
        $builder->update($updateData);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}
	}
    public function getAmenitiesSlotData($filterData)
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_amenities_time_slot as tats');
        $builder->select("tats.*");


        if(isset($filterData['amenities_time_slot_id']) && !empty($filterData['amenities_time_slot_id'])) {
            if (is_array($filterData['amenities_time_slot_id'])) {
                $builder->whereIn('tats.amenities_time_slot_id', $filterData['amenities_time_slot_id']);
            } else {
                $builder->where('tats.amenities_time_slot_id', $filterData['amenities_time_slot_id']);
            }
        }


        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }


    public function deleteRecord($amenitiesId)
    {
        $builder = $this->db->table('tbl_amenities');
        $amenitiesIdArray = is_array($amenitiesId) ? $amenitiesId : array($amenitiesId);
        $builder->whereIn('amenities_id', $amenitiesIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($amenitiesId)){
                foreach($amenitiesId as $amenities){
                    $deleteDataArray['module'] = 'Amenities';
                    $deleteDataArray['activity'] = "Amenities Deleted";
                    $deleteDataArray['module_id'] = $amenities;
                    logActivity('Amenities Deleted [AmenitiesID: ' . $amenities . ']',$this->ionAuth->getUserId(),'Amenities',$amenities,json_encode($deleteDataArray),'','Amenities',$amenities);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    function getAmenities($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        // $builder->start_cache();
        $builder = $this->db->table('tbl_amenities as ta');
        $builder->select("ta.amenities_id as id,ta.amenities_name as text");
        
        $builder->where("ta.is_active", 1);

        // if(isset($filterData['type']) && !empty($filterData['type'])) {
        //     if (is_array($filterData['type'])) {
        //         $builder->whereIn('ta.type', $filterData['type']);
        //     } else {
        //         $builder->where('ta.type', $filterData['type']);
        //     }
        // }
        
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("ta.amenities_name", $filterData['filter_param'], 'both');
            $builder->groupEnd();
        }
        accessFilter($builder, array("society" => "ta.society_id"));
        // $this->db->stop_cache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        // $this->db->flush_cache();
        return json_encode($result);
    }

    function getAmenitiesUnit($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        // $builder->start_cache();
        $builder = $this->db->table('tbl_amenities_unit as tau');
        $builder->select("tau.amenities_unit_id as id,tau.unit_name as text");
        
        if(isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
            if (is_array($filterData['amenities_id'])) {
                $builder->whereIn('tau.amenities_id', $filterData['amenities_id']);
            } else {
                $builder->where('tau.amenities_id', $filterData['amenities_id']);
            }
        } else {
            $builder->where('tau.amenities_id', '-1');
        }
        
        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("tau.unit_name", $filterData['filter_param'], 'both');
            $builder->groupEnd();
        }
        // accessFilter($builder, array("society" => "tts.society_id"));
        // $this->db->stop_cache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);
        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        // $this->db->flush_cache();
        return json_encode($result);
    }

    public function getAmenitiesCommonAreaData($filterData)
    {
        $builder = $this->db->table('tbl_amenities_common_area as tacm');
        $builder->select("tacm.*");
        $builder->select("GROUP_CONCAT(tcm.common_area_name SEPARATOR ',') as common_area_name");
        $builder->join("tbl_common_area as tcm","tcm.common_area_id = tacm.common_area_id","left");

        
        if(isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
            if (is_array($filterData['amenities_id'])) {
                $builder->whereIn('tacm.amenities_id', $filterData['amenities_id']);
            } else {
                $builder->where('tacm.amenities_id', $filterData['amenities_id']);
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();

            $builder->groupEnd();
        }

        $builder->groupBy("tacm.amenities_common_area_id");
        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }
        return $query;
    }

    public function deleteCommonAreaRecord($amenitiesId){

        $builder = $this->db->table('tbl_amenities_common_area');
        $amenitiesIdArray = is_array($amenitiesId) ? $amenitiesId : array($amenitiesId);
        $builder->whereIn('amenities_id', $amenitiesIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

    public function getAmenitiesBookingSlotDayData($filterData)
	{
		$limit = DATA_LIMIT;
		$builder = $this->db->table('tbl_amenities_booking_slot_day as trwd');
		$builder->select("trwd.*,trwd.amenities_booking_slot_day_id,trwd.amenities_id,trwd.amenities_booking_slot_id");
		$builder->join('tbl_amenities tr', 'tr.amenities_id = trwd.amenities_id', 'left');

		if(isset($filterData['amenities_id']) && !empty($filterData['amenities_id'])) {
            if (is_array($filterData['amenities_id'])) {
                $builder->whereIn('trwd.amenities_id', $filterData['amenities_id']);
            } else {
                $builder->where('trwd.amenities_id', $filterData['amenities_id']);
            }
        }
		if(isset($filterData['amenities_flat_id']) && !empty($filterData['amenities_flat_id'])) {
            if (is_array($filterData['amenities_flat_id'])) {
                $builder->whereIn('trwd.amenities_flat_id', $filterData['amenities_flat_id']);
            } else {
                $builder->where('trwd.amenities_flat_id', $filterData['amenities_flat_id']);
            }
        }
		if (isset($filterData['amenities_booking_slot_day_id']) && $filterData['amenities_booking_slot_day_id'] != '') {
			$builder->where("trwd.amenities_booking_slot_day_id", $filterData['amenities_booking_slot_day_id']);
		}

        // if(isset($filterData['is_deleted'])){
        //     $builder->where('trwd.is_deleted', $filterData['is_deleted']);
        // }

		$builder->orderBy("trwd.amenities_id");
		if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
			$query = $builder->get()->getResultArray();
		} else {
			$query = $builder->get()->getRowArray();
		}
		return $query;
	}

    public function deleteAmenitiesBookingSlotDay($amenitiesId)
	{
		$amenitiesIdArray = is_array($amenitiesId) ? $amenitiesId : array($amenitiesId);
		$builder = $this->db->table('tbl_amenities_booking_slot_day');
		$builder->whereIn('amenities_id', $amenitiesIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			return true;
		}
		return false;
	}

    public function deleteAmenitiesBookingSlotDayRecord($amenitiesBookingSlotId)
	{
		$builder = $this->db->table('tbl_amenities_booking_slot_day');
		$amenitiesBookingSlotIdArray = is_array($amenitiesBookingSlotId) ? $amenitiesBookingSlotId : array($amenitiesBookingSlotId);	
		$builder->whereIn('amenities_booking_slot_id',$amenitiesBookingSlotIdArray);
		$builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}
    public function deleteAmenitiesBookingSlotUnitPriceRecord($amenitiesBookingSlotId,$userId)
	{
		$builder = $this->db->table('tbl_amenities_booking_slot_unit_price');
		$amenitiesBookingSlotIdArray = is_array($amenitiesBookingSlotId) ? $amenitiesBookingSlotId : array($amenitiesBookingSlotId);
        $updateData = [
            'is_deleted' => 1,
            'updated_at' => date('Y-m-d H:i:s'),
            // 'updated_by' => $this->data['userId']
            'updated_by' => $userId
        ];
        $builder->whereIn('amenities_booking_slot_id',$amenitiesBookingSlotIdArray);
        $builder->update($updateData);
		// $builder->delete();
		if ($this->db->affectedRows()) {
			$response['success'] = true;
			return $response;
		} else {
			$response['success'] = false;
			return $response;
		}

	}
}