<?php

namespace App\Models;
use CodeIgniter\Model;
use CodeIgniter\Database\RawSql;
class AccountModel extends BaseModel
{

	public function getAccountData($filterData = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_account as tl');
        $builder->select("tl.*,tloc.society_name");
        $builder->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $builder->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by");
        $builder->join("society_user_master_view as tupdate","tupdate.user_society_id = tl.updated_by","left");
        $builder->join("society_user_master_view as tcreate","tcreate.user_society_id = tl.created_by","left");
        $builder->join(MASTER_DB.".tbl_society as tloc","tloc.society_id = tl.society_id","left");
        // $builder->join("tbl_account_guard as tlg","tlg.account_id = tl.account_id","left");

        if (isset($filterData['account_id']) && !empty($filterData['account_id'])) {
            if (is_array($filterData['account_id'])) {
                $builder->whereIn('tl.account_id', $filterData['account_id']);
            } else {
                $builder->where('tl.account_id', $filterData['account_id']);
            }
        }
        if (isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tl.society_id', $filterData['society_id']);
            }
        }
        if (isset($filterData['account_code']) && !empty($filterData['account_code'])) {
            if (is_array($filterData['account_code'])) {
                $builder->whereIn('tl.account_code', $filterData['account_code']);
            } else {
                $builder->where('tl.account_code', $filterData['account_code']);
            }
        }
        if (isset($filterData['account_name']) && !empty($filterData['account_name'])) {
            if (is_array($filterData['account_name'])) {
                $builder->whereIn('tl.account_name', $filterData['account_name']);
            } else {
                $builder->where('tl.account_name', $filterData['account_name']);
            }
        }

        if (isset($filterData['start'])) {
            if ($filterData['start'] != '1') {
                $builder->limit($limit, $filterData['start'] * $limit);
            }
        }

        if(isset($filterData['is_active']) && $filterData['is_active'] == 1){
            $builder->where('tl.is_active', $filterData['is_active']);
        }


        if (isset($filterData['sort_by']) && !empty($filterData['sort_by'])) {
            if (is_array($filterData['sort_by'])) {
                foreach ($filterData['sort_by'] as $key => $value) {
                    foreach ($value as $orderKey => $orderValue) {
                        $builder->orderBy($orderKey,$orderValue);
                    }
                }
            }
        }

        if(isset($filterData['search']) && $filterData['search'] != ''){
            $builder->groupStart();
            $builder->like('tl.account_code', $filterData['search'], 'both');
            $builder->groupEnd();
        }

        $builder->groupBy('tl.account_id');
        if(isset($filterData['is_multiple']) && !empty($filterData['is_multiple'])) {
            $queryData = $builder->get()->getResultArray();
        }else{
            $queryData = $builder->get()->getRowArray();
        }
        return $queryData;
    }
	

	public function deleteRecord($accountId)
    {
        $accountIdArray = is_array($accountId) ? $accountId : array($accountId);
        $builder = $this->db->table('tbl_account');
        $builder->whereIn('account_id', $accountIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            if(!empty($accountId)){
                foreach($accountId as $documentElement){
                    $deleteDataArray['module'] = 'Account';
                    $deleteDataArray['activity'] = "Account Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Account Deleted [AccountID: ' . $documentElement . ']',$this->ionAuth->getUserId(),'Account',$documentElement,json_encode($deleteDataArray),'','Account',$documentElement);
                }
            }
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

	function getAccount($filterData = array())
    {
        if(isset($filterData['page']) && $filterData['page'] != 1) {
            $filterData['start'] = ($filterData['page'] * $filterData['limit']) - $filterData['limit'];
        }

        $builder = $this->db->table('tbl_account as tl');
        //$builder->startCache();
        $builder->select("tl.account_id as id,concat(COALESCE(tl.account_code,''),'-',COALESCE(tl.account_name,''))  as text");
        if(isset($filterData['account_id']) && !empty($filterData['account_id'])) {
            if (is_array($filterData['account_id'])) {
                $builder->whereIn('tl.account_id', $filterData['account_id']);
            } else {
                $builder->where('tl.account_id', $filterData['account_id']);
            }
        }
        if(isset($filterData['society_id']) && !empty($filterData['society_id'])) {
            if (is_array($filterData['society_id'])) {
                $builder->whereIn('tl.society_id', $filterData['society_id']);
            } else {
                $builder->where('tl.society_id', $filterData['society_id']);
            }
        }

        if(isset($filterData['filter_param']) && $filterData['filter_param'] != 1) {
            $builder->groupStart();
            $builder->like("COALESCE(tl.account_name,'')", $filterData['filter_param']);
            $builder->groupEnd();
        }
        if(isset($filterData['is_active'])){
            $builder->where('tl.is_active', $filterData['is_active']);
        }

        //$builder->stopCache();
        $totalRows = $builder->countAllResults(false);
        $builder->limit($filterData['limit'], $filterData['start']);

        $query = $builder->get();
        $result['result'] = $query->getResultArray();
        $result['totalRows'] = $totalRows;
        $result['page'] = $filterData['page'];
        //$builder->flushCache();
        return json_encode($result);
    }

    public function getAccountSubAccountData($filterData  = array())
    {
        $limit = DATA_LIMIT;
        $builder = $this->db->table('tbl_account_sub_account as tlsl');
        $builder->select("tlsl.account_sub_account_id,tlsl.sub_account_id");
        $builder->select("concat(COALESCE(tl.sub_account_code,''),'-',COALESCE(tl.sub_account_name,'')) as sub_account_code_name");
        $builder->join('tbl_sub_account tl', 'tl.sub_account_id = tlsl.sub_account_id', 'left');

        if(isset($filterData['account_id']) && !empty($filterData['account_id'])) {
            if (is_array($filterData['account_id'])) {
                $builder->whereIn('tlsl.account_id', $filterData['account_id']);
            } else {
                $builder->where('tlsl.account_id', $filterData['account_id']);
            }
        }

        // if (isset($filterData['account_image_id']) && $filterData['account_image_id'] != '') {
        //     $builder->where("tmi.account_image_id", $filterData['account_image_id']);
        // }

        $builder->orderBy("tlsl.account_id");

        if((isset($filterData['is_multiple']) && $filterData['is_multiple'] == 1)){
            $query = $builder->get()->getResultArray();
        } else {
            $query = $builder->get()->getRowArray();
        }

        return $query;
    }

    public function deleteSubAccountRecord($accountId){
        $builder = $this->db->table('tbl_account_sub_account');
        $accountIdArray = is_array($accountId) ? $accountId : array($accountId);
        $builder->whereIn('account_id', $accountIdArray);
        $builder->delete();
        if ($this->db->affectedRows()) {
            $response['success'] = true;
            return $response;
        } else {
            $response['success'] = false;
            return $response;
        }
    }

}
?>
