<?php
namespace App\Libraries;
class Dt_ci_template
{
    function load($tpl_view, $body_view = null, $data = null)
    {
        $data['assets'] = base_url() . 'assets/';
        $this->ionAuth    = new \App\Libraries\IonAuth();
        $societyModel =  new \App\Models\SocietyModel();
        $data['logged_in'] = $this->ionAuth->loggedIn();
        $session       = \Config\Services::session();
        $societyId = $session->get("society_id");
        $isSuperAdmin = $session->get("is_super_admin");

        // printArray($session->get('user_id'),1);
        // 
        $userSocietyData = array();
        if(!empty($societyId)){
            $societyData = $societyModel->getSocietyData(array(
                'society_id' => $societyId,
            ));

            $userSocietyData = $this->ionAuth->userSociety(array(
                "user_id" => $session->get('user_id'),
                // 'is_manager' => 1,
                "is_multiple" => 1
            ));
        }
        // printArray($userSocietyData,1);
        if($data['logged_in']){
            $userDetails = $this->ionAuth->user()->row();
            // $data['user_display_name'] = @$userDetails->first_name." ".@$userDetails->last_name;
            $data['user_display_name'] = $session->get('user_name');
            $data['society_id_name'] = (isset($societyData) && !empty($societyData)) ? $societyData['society_name'] : "";
            $data['user_society_data'] = $userSocietyData;
        }


        $data['is_super_admin'] = $isSuperAdmin;

        if (!is_null($body_view)) {
            if (file_exists(APPPATH . 'Views/' . $tpl_view . '/' . $body_view)) {
                $body_view_path = $tpl_view . '/' . $body_view;
            } else if (file_exists(APPPATH . 'Views/' . $tpl_view . '/' . $body_view . '.php')) {
                $body_view_path = $tpl_view . '/' . $body_view . '.php';
            } else if (file_exists(APPPATH . 'Views/' . $body_view)) {
                $body_view_path = $body_view;
            } else if (file_exists(APPPATH . 'Views/' . $body_view . '.php')) {
                $body_view_path = $body_view . '.php';
            } else {
                echo ('Unable to load the requested file: ' . $tpl_view . '/' . $body_view . '.php');
            }

            //$body = $this->ci->load->view($body_view_path, $data, TRUE);
           $body = view($body_view_path, $data);

            if (isset($data['supporting_views'])) {
                foreach ($data['supporting_views'] as $supporting_view) {
                    //$body.=$this->ci->load->view('supporting_views/'.$supporting_view, $data, TRUE);
                    $body .= view('supporting_views/' . $supporting_view, $data);
                }
            }

            if (is_null($data)) {
                $data = array('body' => $body);
            } else if (is_array($data)) {
                $data['body'] = $body;
            } else if (is_object($data)) {
                $data->body = $body;
            }
        }
        //$this->ci->load->view('templates/'.$tpl_view, $data);
        echo view('Templates/' . $tpl_view, $data);
    }
}
