<?php /*
namespace App\Libraries;
class Dt_ci_phpcsv
{
    public function getFileData($filePath){
        $arr_data = array();
        $header = array();

        $row = 1;
        $file = fopen($filePath,"r");

        while(! feof($file))
        {
            $data = fgetcsv($file);
            if(empty($data)){
                break;
            }
            $num = count($data);

            if($row == 1){
                for ($c=0; $c < $num; $c++) {
                    $header[$row][$this->getNameFromNumber($c)] = $data[$c];
                }
            }else{
                for ($c=0; $c < $num; $c++) {
                    $arr_data[$row][$this->getNameFromNumber($c)] = $data[$c];
                }
            }
            $row++;
        }

        fclose($file);

        //send the data in an array format
        $data['header'] = $header;

        foreach($arr_data as $dataKey => $dataVal){
            $nonEmpty = false;
            foreach($dataVal as $key => $value){
                if(trim($value) != ""){
                    $nonEmpty = true;
                    break;
                }
            }

            if($nonEmpty){
                $data['values'][$dataKey] = $dataVal;
            }
        }

        return $data;
    }

    private function getNameFromNumber($num) {
        $numeric = $num % 26;
        $letter = chr(65 + $numeric);
        $num2 = intval($num / 26);
        if ($num2 > 0) {
            return $this->getNameFromNumber($num2 - 1) . $letter;
        } else {
            return $letter;
        }
    }
}
*/?>
<?php
namespace App\Libraries;

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Shared\Date;

class Dt_ci_phpcsv
{
    public function getFileData($filePath){
        $extension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
        
        switch($extension) {
            case 'csv':
                return $this->readCSV($filePath);
            case 'xlsx':
            case 'xls':
                return $this->readExcel($filePath);
            default:
                throw new \Exception("Unsupported file format: .$extension. Supported formats: .csv, .xlsx, .xls");
        }
    }

    private function readCSV($filePath){
        $arr_data = array();
        $header = array();

        $row = 1;
        $file = fopen($filePath, "r");

        while(!feof($file)) {
            $data = fgetcsv($file);
            if(empty($data)){
                break;
            }
            $num = count($data);

            if($row == 1){
                for ($c=0; $c < $num; $c++) {
                    $header[$row][$this->getNameFromNumber($c)] = $data[$c];
                }
            } else {
                for ($c=0; $c < $num; $c++) {
                    $arr_data[$row][$this->getNameFromNumber($c)] = $data[$c];
                }
            }
            $row++;
        }

        fclose($file);
        return $this->formatData($header, $arr_data);
    }

    private function readExcel($filePath){
        $arr_data = array();
        $header = array();

        try {
            // Load the Excel file
            $spreadsheet = IOFactory::load($filePath);
            $worksheet = $spreadsheet->getActiveSheet();
            
            // Get the highest row and column
            $highestRow = $worksheet->getHighestRow();
            $highestColumn = $worksheet->getHighestColumn();
            $highestColumnIndex = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($highestColumn);

            $row = 1;
            foreach ($worksheet->getRowIterator() as $rowObj) {
                if ($row > $highestRow) break;

                $cellIterator = $rowObj->getCellIterator();
                $cellIterator->setIterateOnlyExistingCells(false);
                
                $rowData = [];
                $columnIndex = 0;
                
                foreach ($cellIterator as $cell) {
                    if ($columnIndex >= $highestColumnIndex) break;
                    
                    $value = $cell->getCalculatedValue();
                    
                    // Convert Excel dates to PHP dates
                    if (Date::isDateTime($cell)) {
                        $value = Date::excelToDateTimeObject($value)->format('Y-m-d H:i:s');
                    }
                    
                    // Handle empty cells
                    if ($value === null) {
                        $value = '';
                    }
                    
                    $rowData[$this->getNameFromNumber($columnIndex)] = $value;
                    $columnIndex++;
                }

                if($row == 1){
                    $header[$row] = $rowData;
                } else {
                    $arr_data[$row] = $rowData;
                }
                $row++;
            }

            return $this->formatData($header, $arr_data);

        } catch (\Exception $e) {
            throw new \Exception("Error reading Excel file: " . $e->getMessage());
        }
    }

    private function formatData($header, $arr_data){
        // Send the data in an array format
        $data['header'] = $header;

        foreach($arr_data as $dataKey => $dataVal){
            $nonEmpty = false;
            foreach($dataVal as $key => $value){
                if(trim($value) != ""){
                    $nonEmpty = true;
                    break;
                }
            }

            if($nonEmpty){
                $data['values'][$dataKey] = $dataVal;
            }
        }

        return $data;
    }

    private function getNameFromNumber($num) {
        $numeric = $num % 26;
        $letter = chr(65 + $numeric);
        $num2 = intval($num / 26);
        if ($num2 > 0) {
            return $this->getNameFromNumber($num2 - 1) . $letter;
        } else {
            return $letter;
        }
    }

    /**
     * Get file extension and validate supported types
     */
    public function validateFileType($filePath) {
        $allowedExtensions = ['csv', 'xlsx', 'xls'];
        $extension = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
        
        if (!in_array($extension, $allowedExtensions)) {
            throw new \Exception("Invalid file type. Allowed types: " . implode(', ', $allowedExtensions));
        }
        
        return $extension;
    }

    /**
     * Get sample data structure for validation
     */
    public function getSampleStructure() {
        return [
            'header' => [
                1 => [
                    'A' => 'Column1',
                    'B' => 'Column2',
                    'C' => 'Column3'
                ]
            ],
            'values' => [
                2 => [
                    'A' => 'Value1',
                    'B' => 'Value2', 
                    'C' => 'Value3'
                ]
            ]
        ];
    }
}