<?php
namespace App\Libraries;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
class Dt_ci_email
{

    var $from = FROM_EMAIL;
    var $fromName = FROM_NAME;

    public function sendEmail($mailType, $to, $paymentDetails = array())
    {
        $subject = "";
        $body = "";
        $status = false;

        $amount = isset($paymentDetails['amount']) ? $paymentDetails['amount'] : "";
        $payID = isset($paymentDetails['payment_id_ut2']) ? $paymentDetails['payment_id_ut2'] : "";
        $clid = isset($paymentDetails['clid']) ? $paymentDetails['clid'] : "";
        $paymentStatus = isset($paymentDetails['status']) ? $paymentDetails['status'] : "";
        $paymentStatus = $paymentStatus == "1" ? "Success" : "Failed";

        $didQty = isset($paymentDetails['didQty']) ? $paymentDetails['didQty'] : "";
        $didNumber = isset($paymentDetails['number']) ? $paymentDetails['number'] : "";
        $didAreaCode = isset($paymentDetails['area_code']) ? $paymentDetails['area_code'] : "";
        $didAreaCodeDesc = isset($paymentDetails['area_description']) ? $paymentDetails['area_description'] : "";

        $ut2_did_details = isset($paymentDetails['ut2_did_details']) ? $paymentDetails['ut2_did_details'] : "";

        switch ($mailType) {
            case 1:
                $subject = "Subject type 1";
                $body = "";

                if (isset($paymentDetails['more_details'])) {

                    $moreDetails = $paymentDetails['more_details'];

                    $body .= "<h2>Package name: " . $moreDetails['package_name'] . "</h2>";
                    $body .= "<h2>Tokens: " . $moreDetails['tokens'] . "</h2>";
                    $body .= "<h2>Days: " . $moreDetails['term'] . "</h2>";
                    $body .= "<h2>Amount: " . $amount . "$</h2>";
                    $body .= "<h2>Payment Status: " . $paymentStatus . "</h2>";

                }

                break;
            case 2:
                $subject = "You Got A Payment!";
                $body = "<p>ID: " . $payID . " - You got a payment of: $" . $amount . ", From Phone Number: $clid</p> <br>Thank You<br>EZ TelePay";
                break;
            case 3:
                $subject = "Subject type 3";
                $body = "<h2>Amount: " . $amount . "</h2>";
                break;
            case 4:
                $subject = "Subject type 4";
                $body = "<h2>Congratulations you have been assigned DID number: " . $didNumber . "</h2>";
                break;
            case 5:
                $subject = "Subject - You have successfully raised a DID request";
                $body = "<h2>Congratulations you have successfully raised a DID request ( {$didQty} Nos.) for area code: {$didAreaCode} - {$didAreaCodeDesc}</h2>";
                break;
            case 6:
                $subject = "Subject - DID request received";
                $body = "<h2>DID request ( {$didQty} Nos.) received for area code: {$didAreaCode} - {$didAreaCodeDesc}</h2>";
                $body .= "<h2>User Id: {$ut2_did_details->id} </h2>";
                $body .= "<h2>Name: {$ut2_did_details->first_name} {$ut2_did_details->last_name} </h2>";
                $body .= "<h2>Email: {$ut2_did_details->email} </h2>";
                break;
            default:
                $subject = "";
                $body = "";
                break;
        }

        if ($subject != "" && $body != "") {
            $status = $this->sendMail($this->from, $this->fromName, $to, $subject, $body);
        }

        return $status;
    }

    public function sendPasswordMail($to, $subject, $body)
    {
        $status = $this->sendMail($this->from, $this->fromName, $to, $subject, $body);
        return $status;
    }

    public function sendMail($from, $fromName, $to, $subject, $body, $reply_to = '', $bcc = '', $cc = '', $attachments = [])
    {
        $mail = new PHPMailer(true);

        try {
            $mail->isSMTP();
            $mail->Host         = EMAIL_HOST; //smtp.google.com
            $mail->SMTPAuth     = true;
            $mail->Username     = EMAIL_USERNAME;
            $mail->Password     = EMAIL_PASSWORD;
            $mail->SMTPSecure   = EMAIL_SMTP_SECURE;
            $mail->Port         = 587;
            $mail->Subject      = $subject;
            $mail->Body         = $body;
            $mail->setFrom($from, $from);


            if(isset($to)){
                if(is_array($to)){
                    foreach($to as $toEmail){
                        $mail->AddAddress($toEmail);
                    }
                } else {
                    $mail->AddAddress($to);
                }
            }

            $mail->isHTML(true);

            if (count($attachments) > 0) {
                foreach ($attachments as $attachment) {
                    if (isset($attachment['path']) && file_exists($attachment['path'])) {
                        $mail->AddAttachment($attachment['path'], $attachment['name'], 'base64', $attachment['type']);
                    } else {
                        if (file_exists($attachment)) {
                            $mail->AddAttachment($attachment);
                        }
                    }
                }
            }

            if ($reply_to != '') {
                $mail->AddReplyTo($reply_to);
            }
            if ($bcc != '') {
                $mail->AddBCC($bcc);
            }
            if ($cc != '') {
                if(is_array($cc)){
                    foreach($cc as $ccEmail){
                        $mail->AddCC($ccEmail);
                    }
                } else {
                    $mail->AddCC($cc);
                }
            }

            if(!$mail->send()) {
                //echo "Something went wrong. Please try again.";
                $sendStatus = 0;
                $response =  $mail->ErrorInfo;
            }
            else {
                //echo "Email sent successfully.";
                $sendStatus = 1;
                $response = 'Email sent successfully.';
            }

            $requestTime = date('Y-m-d H:i:s');
            $responseTime = date('Y-m-d H:i:s');

            $logEmailData = array(
                "response" => $response,
                "request_time" => $requestTime,
                "response_time" => $responseTime,
                "status" => $sendStatus,
                "recipient" => (is_array($to)) ? implode(",",$to) : $to,
                "email_type" => 0,
                "email_content" => $body,
                "contact_type" => 'email',
            );

            $db = \Config\Database::connect();
            $builder = $db->table('tbl_log_email');
            $builder->insert($logEmailData);

            if ($sendStatus) {
                return true;
            } else {
                return false;
            }
        } catch (Exception $e) {
            echo "Something went wrong. Please try again.";
        }


    }

}
