<?php
namespace App\Libraries;
use \DateTime;
class Dt_ci_common
{
    public function uploadMasterFile($files, $path, $file = array())
    {
        $request = \Config\Services::request();
        $this->ionAuth    = new \App\Libraries\IonAuth();
        $response = array();
        $directFile = false;
        $fileUploadSuccess = false;

        if (!is_array($file)) {
            $directPathInfo = pathinfo($file);
            $directFileName = $directPathInfo['basename'];
            $directFile = true;
            $user_id = SCHEDULER_USER_ID;
        } else {
            $user_id = $this->ionAuth->getUserId();
        }


        if (isset($_FILES['file']['name'])) {
            $original_name_array = explode(".", $_FILES['file']['name']);
        } else {
            $original_name_array = explode(".", $directFileName);
        }

        $dateTimeObj = new DateTime();
        $fileDateSuffix = $dateTimeObj->format('mdY_His');
        $fileDateSuffix .= substr((string)microtime(), 2, 8);

        $response = array();

        $fileRealName = reset($original_name_array);
        $ext = end($original_name_array);

        $file_name = $user_id . '_' . $fileDateSuffix . '.' . $ext;
        $zip_file_name = $user_id . '_' . $fileDateSuffix . '.zip';

        if ($directFile) {
            copy($file, $path . $file_name);
            // $response['unset_data']['upload_data']['file_name'] = $file_name;
            $response['unset_data']['upload_data']['file_name'] = $zip_file_name;
            $fileUploadSuccess = true;
        } else {
            $fieldname = 'file';
            $_FILES['userFile']['name'] = $_FILES[$fieldname]['name'];
            $_FILES['userFile']['type'] = $_FILES[$fieldname]['type'];
            $_FILES['userFile']['tmp_name'] = $_FILES[$fieldname]['tmp_name'];
            $_FILES['userFile']['error'] = $_FILES[$fieldname]['error'];
            $_FILES['userFile']['size'] = $_FILES[$fieldname]['size'];

            $file_extension = strtolower(pathinfo($_FILES['userFile']['name'], PATHINFO_EXTENSION));

            if (!in_array($file_extension, array('csv'))) {

                $error = array('error' => 'Please upload valid file');
                $response['result'] = 'error';
                $response['error_desc'] = $error;
                $response['more_data'] = $files;
                $fileUploadSuccess = false;
            } else {
                if ($img = $request->getFiles()) {
                    if ($img[$fieldname]->isValid() && !$img[$fieldname]->hasMoved()) {
                        $randomImgName = $img[$fieldname]->getRandomName();
                        //                    $img[$fieldname]->move($path, $randomImgName);
                        $img[$fieldname]->move($path, $file_name);
                        $response['unset_data']['upload_data'] = $img[$fieldname];
                        $response['unset_data']['file_name'] = $zip_file_name;
                        $fileUploadSuccess = true;
                    } else {
                        $error = array('error' => $img->getErrorString() . '(' . $img->getError() . ')');
                        $response['result'] = 'error';
                        $response['error_desc'] = $error;
                        $response['more_data'] = $files;
                        $fileUploadSuccess = false;
                    }

                }
            }
        }


        if ($fileUploadSuccess) {
            $response['result'] = 'ok';
            $filePath = $path . $file_name;

            $Dt_ci_phpexcel = new \App\Libraries\Dt_ci_phpcsv();
            //read file from path
            $response['unset_data']['data_excel'] = $Dt_ci_phpexcel->getFileData($filePath);
            $response['unset_data']['file_prefix'] = $user_id . '_' . $fileDateSuffix;

            // printArray($fileDateSuffix,1);

            // Create zip
            // $zip = new \ZipArchive();
            // $zipFileName = $user_id . '_' . $fileDateSuffix . '.zip';
            // $zipFilePath = $path . $zipFileName;

            // if ($zip->open($zipFilePath, \ZipArchive::CREATE) === true) {
            //     $zip->addFile($filePath, $file_name);
            //     $zip->close();

            //     // Optional: delete original CSV
            //     // unlink($filePath);

            //     $response['unset_data']['zipped_file'] = $zipFileName;
            //     // $filePath = $zipFilePath; // Update filePath to zip
            // } else {
            //     $response['result'] = 'error';
            //     $response['error_desc'] = ['error' => 'Unable to create zip file'];
            //     return $response;
            // }
        }

        return $response;
    }


    public function validateSku($sku_code, $skus = array()){
        if(empty($skus)) {
            $skuModel = new \App\Models\SkuModel();
            $skus = $skuModel->getSkusBulkUpload();
        }
        $skuId = 0;
        if($sku_code == ""){
            return $skuId;
        }
        foreach($skus as $sku){
            if($sku['sku_code'] == $sku_code){
                $skuId = $sku['sku_id'];
                break;
            }
        }
        return $skuId;
    }

    public function checkDuplicateSkuWip($sku_id, $skus = array()){
        $skuId = 0;
        foreach($skus as $sku){
            if($sku['sku_id'] == $sku_id){
                $skuId = $sku['sku_id'];
                break;
            }
        }
        return $skuId;
    }

    public function getParentSkufgId($skuId,$skuWipData = array()){

        $parentSkuFgId = 0;
        
        foreach($skuWipData as $sku){
            if($sku['sku_id'] == $skuId){
                $parentSkuFgId = $sku['parent_fg_sku_id'];
                break;
            }
        }
        return $parentSkuFgId;
    }

    public function validateIndentType($indent_type, $indentTypes = array()){

        if(empty($indentTypes)) {
            $indentModel = new \App\Models\IndentTypeModel();
            $indentTypes = $indentModel->getIndentTypeBulkUpload();
        }

        $indentTypeId = 0;

        if($indent_type == ""){
            return $indentTypeId;
        }

        foreach($indentTypes as $indentType){
            if($indentType['indent_type_name'] == $indent_type){
                $indentTypeId = $indentType['id'];
                break;
            }
        }

        return $indentTypeId;
    }

    public function validateRegion($region_code, $regions = array()){

        if(empty($regions)){
            $regionModel = new \App\Models\RegionModel();
            $regions = $regionModel->getRegionsBulkUpload();
        }

        $regionId = 0;

        if($region_code == ""){
            return $regionId;
        }

        foreach($regions as $region){
            if($region['region_code'] == $region_code){
                $regionId = $region['region_id'];
                break;
            }
        }

        return $regionId;
    }

    public function validateCat($cat_code, $cats = array(),$returnID = true){

        if(empty($cats)){
            $catModel = new \App\Models\CategoryModel();
            $cats = $catModel->getCategorysBulkUpload();
        }

        if($returnID){
            $catId = 0;
        } else {
            $catId = array();
        }

        if($cat_code == ""){
            return $catId;
        }

        foreach($cats as $cat){
            if($cat['cat_code'] == $cat_code){
                $catId = $returnID ? $cat['cat_id'] : $cat;
                break;
            }
        }

        return $catId;
    }

    public function validateUnit($unit_symbol, $units = array()){

        if(empty($units)){
            $unitModel = new \App\Models\UnitModel();
            $units = $unitModel->getUnits();
        }

        $unitId = 0;

        if($unit_symbol == ""){
            return $unitId;
        }

        foreach($units as $unit){
            if($unit['unit_symbol'] == $unit_symbol){
                $unitId = $unit['unit_id'];
                break;
            }
        }

        return $unitId;
    }

    public function checkDateFormat($date){
        return date('Y',strtotime($date))=='1970' && date('m',strtotime($date))=='01' && date('d',strtotime($date))=='01';
    }

    public function validateSkuSpecial($sku_code, $skus = array()){
        if(empty($skus)) {
            $skuModel = new \App\Models\SkuModel();
            $skus = $skuModel->getSkusBulkUpload();
        }

        $skuDetails = false;
        if($sku_code != ""){
            foreach($skus as $sku){
                if($sku['sku_code'] == $sku_code){
                    $skuDetails = $sku;
                    break;
                }
            }
        }

        return $skuDetails;
    }
    
    public function validateSkuSpecialNew($sku_code, $skus = array()){
        if(empty($skus)) {
            $skuModel = new \App\Models\SkuModel();
            $skus = $skuModel->getSkusBulkUpload();
        }

        $skuDetails = false;
        if($sku_code != ""){
            if(isset($skus[$sku_code])){
                $skuDetails = $skus[$sku_code];
            }
        }

        return $skuDetails;
    }

    public function validateNodeSpecial($node_code, $nodes = array()){
        if(empty($nodes)) {
            $nodeModel = new \App\Models\NodeModel();
            $nodes = $nodeModel->getNodesBulkUpload();
        }

        $nodeDetails = false;
        if($node_code != ""){
            foreach($nodes as $node){
                if($node['node_code'] == $node_code){
                    $nodeDetails = $node;
                    break;
                }
            }
        }

        return $nodeDetails;
    }

    public function validateNodeSpecialNew($node_code, $nodes = array()){
        if(empty($nodes)) {
            $nodeModel = new \App\Models\NodeModel();
            $nodes = $nodeModel->getNodesBulkUpload();
        }

        $nodeDetails = false;
        if($node_code != ""){
            if(isset($nodes[$node_code])){
                $nodeDetails = $nodes[$node_code];
            }
        }

        return $nodeDetails;
    }

    public function checkDuplicateSkuCode($skuId = 0, $skuCode = '', $skus = array())
    {
        if (empty($skus)) {
            $skuModel = new \App\Models\SkuModel();
            $skus = $skuModel->getSkusBulkUpload(0, 0, '', false);
        }
    
        foreach ($skus as $sku) {
            if ($sku['sku_code'] == $skuCode && $sku['is_delete'] == 0) {
                if ($skuId == 0 || $sku['sku_id'] != $skuId) {
                    // return true; // Duplicate found
                    return $sku['sku_id'];
                }
            }
        }
        return false; // No duplicate found
    }

    public function checkDuplicateRegionCode($regionId = 0, $regionCode = '', $regions = array())
    {
        if (empty($regions)) {
            $regionModel = new \App\Models\RegionModel();
            $regions = $regionModel->getRegionsBulkUpload(0, 0, '', false);
        }
    
        foreach ($regions as $region) {
            if ($region['region_code'] == $regionCode && $region['is_delete'] == 0) {
                if ($regionId == 0 || $region['region_id'] != $regionId) {
                    return true; // Duplicate found
                }
            }
        }
        return false; // No duplicate found
    }

    public function checkDuplicateCatCode($catId = 0, $catCode = '', $cats = array())
    {
        if (empty($cats)) {
            $catModel = new \App\Models\CategoryModel();
            $cats = $catModel->getCategorysBulkUpload(0, 0, '', false);
        }
    
        foreach ($cats as $cat) {
            if ($cat['cat_code'] == $catCode && $cat['is_delete'] == 0) {
                if ($catId == 0 || $cat['cat_id'] != $catId) {
                    return true; // Duplicate found
                }
            }
        }
        return false; // No duplicate found
    }

    public function validateNode($node_code, $nodes = array(), $returnArr = false){

        if(empty($nodes)) {
            $nodeModel = new \App\Models\NodeModel();
            $nodes = $nodeModel->getNodesBulkUpload(0,0,'', false);
        }

        if($returnArr){
            $nodeId = [];
        }else{
            $nodeId = 0;
        }

        if($node_code == ""){
            return $nodeId;
        }

        foreach($nodes as $node){
            if($node['node_code'] == $node_code){
                if($returnArr){
                    $nodeId = $node;
                }else{
                    $nodeId = $node['node_id'];
                }
                break;
            }
        }

        return $nodeId;
    }

    public function validateMaterialType($material_type_code, $materialTypes = array(), $returnArr = false){

        if(empty($materialTypes)) {
            $materialTypeModel = new \App\Models\MaterialTypeModel();
            $materialTypes = $materialTypeModel->getMaterialTypesBulkUpload(0,0,'', false);
        }

        if($returnArr){
            $materialTypeId = [];
        }else{
            $materialTypeId = 0;
        }

        if($material_type_code == ""){
            return $materialTypeId;
        }

        foreach($materialTypes as $materialType){
            if($materialType['material_type_code'] == $material_type_code){
                if($returnArr){
                    $materialTypeId = $materialType;
                }else{
                    $materialTypeId = $materialType['material_type_id'];
                }
                break;
            }
        }

        return $materialTypeId;
    }

    public function validateNodeAndStorageLocationCode($node_code, $nodes = array(), $returnArr = false){

        if(empty($nodes)) {
            $nodeModel = new \App\Models\NodeModel();
            $nodes = $nodeModel->getNodesBulkUpload(0,0,'', false);
        }

        if($returnArr){
            $nodeId = [];
        }else{
            $nodeId = 0;
        }

        if($node_code == ""){
            return $nodeId;
        }

        foreach($nodes as $node){
            if($node['node_code_storage_location_code'] == $node_code){
                if($returnArr){
                    $nodeId = $node;
                }else{
                    $nodeId = $node['node_id'];
                }
                break;
            }
        }

        return $nodeId;
    }

    public function validateNodeType($node_type, $nodeTypes = array()){

        if(empty($nodeTypes)) {
            $nodeModel = new \App\Models\NodeModel();
            $nodeTypes = $nodeModel->getNodeTypes();
        }

        $nodeTypeId = 0;

        if($node_type == ""){
            return $nodeTypeId;
        }

        foreach($nodeTypes as $nodeType){
//            $this->printArray($node);
            if($nodeType['node_type_name'] == $node_type){
                $nodeTypeId = $nodeType['id'];
                break;
            }
        }

        return $nodeTypeId;
    }


    public function validateNodeStorageLocation($node_code, $nodes = array(), $returnArr = false){

        if(empty($nodes)) {
            $nodeModel = new \App\Models\NodeModel();
            $nodes = $nodeModel->getNodesBulkUpload(0,0,'', false);
        }

        if($returnArr){
            $nodeId = [];
        }else{
            $nodeId = 0;
        }

        if($node_code == ""){
            return $nodeId;
        }

        foreach($nodes as $node){
            if($node['clubbedNodeCode'] == $node_code){
                if($returnArr){
                    $nodeId = $node;
                }else{
                    $nodeId = $node['node_id'];
                }
                break;
            }
        }

        return $nodeId;
    }

    public function validateNodeStorageLocationNew($node_code, $nodes = array(), $returnArr = false){

        if(empty($nodes)) {
            $nodeModel = new \App\Models\NodeModel();
            $nodes = $nodeModel->getNodesBulkUpload(0,0,'', false);
        }

        if($returnArr){
            $nodeId = [];
        }else{
            $nodeId = 0;
        }

        if($node_code == ""){
            return $nodeId;
        }

        // foreach($nodes as $node){
        //     if($node['clubbedNodeCode'] == $node_code){
        //         if($returnArr){
        //             $nodeId = $node;
        //         }else{
        //             $nodeId = $node['node_id'];
        //         }
        //         break;
        //     }
        // }

        if(isset($nodes[$node_code])){
            if($returnArr){
                $nodeId = $nodes[$node_code];
            }else{
                $nodeId = $nodes[$node_code]['node_id'];
            }
        }

        return $nodeId;
    }


    public function checkError($errorRowArr){
        foreach($errorRowArr as $key => $value){
            if(count($value) > 0){
                return false;
            }
        }
        return true;
    }


    public function printResponseCsv($path, $data, $hasHeaderAsRow = false){
        if(empty($data)){
            $this->printCsv($path, array(0=> array("Result" => "Success!")));
        }else{
            $this->printCsv($path, $data, $hasHeaderAsRow);
        }
    }

    public function printCsv($path, $data, $hasHeaderAsRow = false){

        $out = fopen($path, 'w');

        // printArray($path,1);

        $headerArr = array();

        foreach($data as $row){
            foreach ($row as $rowKey => $rowValue){
                $headerArr[] = $rowKey;
            }
            break;
        }

        fwrite($out, "\xEF\xBB\xBF");

        if(!$hasHeaderAsRow){
            fputcsv($out, $headerArr);
        }

        foreach ($data as $row){
            fputcsv($out, $row);

        }

        fclose($out);

        // // === Zip the CSV file ===
        // $zip = new \ZipArchive();
        // $csvFilename = basename($path); // e.g., myfile.csv
        // $zipPath = str_replace('.csv', '.zip', $path); // e.g., myfile.zip

        // if ($zip->open($zipPath, \ZipArchive::CREATE | \ZipArchive::OVERWRITE)) {
        //     $zip->addFile($path, $csvFilename); // Add the CSV to the zip
        //     $zip->close();

        //     // Delete the original CSV file after successful zipping
        //     unlink($path);
        // }
    }


    public function getSymbols($type, $returnType = 'symbol', $showInactive = true){

        $dataArr = array();
        $symbolArr = array();
        $symbolName = '';

        if($type == 'unit'){
            $unitModel = new \App\Models\UnitModel();
            $dataArr = $unitModel->getUnits(0,0,$showInactive);
            $symbolName = 'unit_symbol';
        }
        else if($type == 'category'){

            $categoryModel = new \App\Models\CategoryModel();
            $dataArr = $categoryModel->getCategorysBulkUpload(0,0,'', $showInactive);
            $symbolName = 'cat_code';
        }
        else if($type == 'node'){
            $nodeModel = new \App\Models\NodeModel();
            $dataArr = $nodeModel->getNodesBulkUpload(0,0,'', $showInactive);
            $symbolName = "clubbedNodeCode";
        }
        else if($type == 'node_storage_location_code'){
            $nodeModel = new \App\Models\NodeModel();
            $dataArr = $nodeModel->getNodesBulkUpload(0,0,'', $showInactive);
            $symbolName = "clubbedNodeCode";
        }

        else if($type == 'region'){
            $regionModel = new \App\Models\RegionModel();
            $dataArr = $regionModel->getRegionsBulkUpload(0,0,'', $showInactive);
            $symbolName = 'region_code';
        }
        else if($type == 'sku'){
            $skuModel = new \App\Models\SkuModel();
            $dataArr = $skuModel->getSkusBulkUpload(0,0,'', $showInactive);
            $symbolName = 'sku_code';
        }
        else if($type == 'vehicleType'){
            $this->CI->load->model('mdl_vehicleType');
            $dataArr = $this->CI->mdl_vehicleType->getVehicleType(0,0,'', $showInactive);
            $symbolName = 'vehicle_type_code';
        }

        foreach ($dataArr as $indData){
            array_push($symbolArr, $indData[$symbolName]);
        }

        $returnArr = array(
            'data' => $dataArr,
            'symbols' => $symbolArr
        );

        if($returnType == 'symbol'){
            return $symbolArr;
        }
        else if($returnType == 'data'){
            return $dataArr;
        }
        else if($returnType == 'both'){
            return $returnArr;
        }
    }


    public function array_sort($array, $on, $maintainIndex = true, $order=SORT_ASC){

        $new_array = array();
        $sortable_array = array();

        if (count($array) > 0) {
            foreach ($array as $k => $v) {
                if (is_array($v)) {
                    foreach ($v as $k2 => $v2) {
                        if ($k2 == $on) {
                            $sortable_array[$k] = $v2;
                        }
                    }
                } else {
                    $sortable_array[$k] = $v;
                }
            }

            switch ($order) {
                case SORT_ASC:
                    if($maintainIndex){
                        asort($sortable_array);
                    }else{
                        sort($sortable_array);
                    }
                    break;
                case SORT_DESC:
                    if($maintainIndex){
                        arsort($sortable_array);
                    }else{
                        rsort($sortable_array);
                    }
                    break;
            }

            foreach ($sortable_array as $k => $v) {
                $new_array[$k]
                    = $array[$k];
            }
        }

        return $new_array;
    }

    public function getSettingsArray($code)
    {

        $this->settingsModel = new \App\Models\SettingsModel();
        $settingsArray = array();
        $settings = $this->settingsModel->getSettings($code);

        foreach ($settings as $setting) {
            if ($setting['serialized'] == 1) {
                $settingsArray[$setting['key']] = json_decode($setting['value'], true);
            } else {
                $settingsArray[$setting['key']] = $setting['value'];
            }
        }

        return $settingsArray;
    }

    public function getColorZone($settingsArray, $percentage)
    {
        $color = '';

        foreach ($settingsArray as $settings) {
            if ($settings['onOff'] == 1) {
                $percentage = (double)$percentage;
                $settings['from'] = (double)$settings['from'];
                $settings['to'] = (double)$settings['to'];
                if (
                    $percentage >= $settings['from'] &&
                    $percentage <= $settings['to']
                ) {
                    $color = $settings['color']['color'];
                    break;
                }
            }
        }

        return $color;
    }

    public function getColorSettings($settingsArray, $color)
    {
        $returnValue = 1;

        foreach ($settingsArray as $settings) {
            if ($settings['onOff'] == 1 && $settings['color']['color'] == $color) {

                if ($settings['type'] == 1) {
                    $returnValue = (double)$settings['to'];
                } else if ($settings['type'] == 2) {
                    $returnValue = (double)$settings['from'];
                } else if ($settings['type'] == 3) {
                    $returnValue = (double)$settings['from'];
                } else if ($settings['type'] == 4) {
                    $returnValue = (double)$settings['to'];
                }
            }
        }

        return $returnValue;
    }
}
