<?php

namespace App\Libraries;

use Datatables;

class CustomDatatables
{
    protected $tenantDB;
    protected $centralDB;
    protected $centralTables = ['tbl_users'];

    public function __construct()
    {
        helper("tenant");
        $this->tenantDB = getTenantDb();
        $this->centralDB = \Config\Database::connect();
    }

    public function join($builder, $table, $cond, $type = '', $escape = null)
    {
        if ($this->isCentralTable($table)) {
            $builder->db = $this->centralDB;
        } else {
            $builder->db = $this->tenantDB;
        }

        return $builder->join($table, $cond, $type, $escape);
    }

    private function isCentralTable($table)
    {
        foreach ($this->centralTables as $centralTable) {
            if (strpos($table, $centralTable) !== false) {
                return true;
            }
        }
        return false;
    }
}


