<?php namespace App\Libraries\Bulkuploads;

helper('text');
class Tower_uploads
{
    function __construct()
    {
        $this->fileUploadModel = new \App\Models\FileUploadsModel();
        $this->dt_ci_common = new \App\Libraries\Dt_ci_common();
        $this->towerModel = new \App\Models\TowerModel();
        $this->session       = \Config\Services::session();
    }

    public function uploadTower($userId, $return = false, $file = array())
    {
        $transactionDate = "";
        $firstRecord = true;
        $startTime = date('Y-m-d H:i:s');
        checkAndCreatePath(TOWER_DATA_ABS_PATH);

        $dirAbsPath = TOWER_DATA_ABS_PATH;
        $dirRelPath = TOWER_DATA_RELATIVE_PATH;

        $masterType = "tower-flat data master";

        $towerData = $this->towerModel->getTowerData(array(
            'is_multiple' => 1,
            // 'society_id' => 1
        ));
        
        // $towerUnitData = $this->towerModel->getTowerUnitData(array(
        //     'is_multiple' => 1,
        //     // 'society_id' => 1
        // ));

        $towerArr = array();
        if(!empty($towerData) || !empty($towerUnitData)){
            foreach ($towerData as $tKey => $tElement) {
                $towerArr[$tElement['tower_name']] = $tElement;
            }

            // foreach ($towerUnitData as $tUKey => $tUnitElement) {
            //     $towerArr[$tUnitElement['tower_name']]['tower_unit_data'][$tUnitElement['unit_group']][] = $tUnitElement;
            // }
        }

        // printArray($towerArr,1);

        // $skuDetails = $this->dt_ci_common->getSymbols('sku', 'both', false);
        // $skuData = $skuDetails['data'];
        // $skuSymbols = $skuDetails['symbols'];

        $numberTypeData = numberType();
        // printArray($numberTypeData,1);

        $customErrors = array(
            "101" => "Tower Name required",
            "102" => "Tower Name is already there",
            "201" => "Unit Required",
            "202" => "Unit should be numeric", 
            "203" => "Unit should be not be less than 0", 
            "301" => "Unit Group Required",
            "302" => "Unit Group Name Should be unique",
            "401" => "Number Type Required",
            "402" => "Number Type Invalid",
            "501" => "Range label Required",
            "601" => "Range start from Required",
            "701" => "BHK Required",
            "801" => "Sqr ft. Required",
            "901" => "Carpet area Required",
        );
        $response = $this->dt_ci_common->uploadMasterFile($_FILES, $dirAbsPath, $file);
        // printArray($response,1);

        if ($response['result'] == 'ok') {
            $dataExcel = $response['unset_data']['data_excel'];
            $uploadData = $response['unset_data']['upload_data'];
            $filePrefix = $response['unset_data']['file_prefix'];
            unset($response['unset_data']);

            $successEntries = 0;
            $failedEntries = 0;

            $errorRowArr = array();
            $dataSaveBatch = array();
            $dataResponse = array();
            $towerInsertArr = array();
            $towerUnitInsertArr = array();
            $towerFlatInsertArr = array();

            foreach ($customErrors as $cErrKey => $cErrMessage) {
                $errorRowArr[$cErrKey] = array();
            }
            foreach ($dataExcel['values'] as $rowNumber => $row) {

                $dataSave = array();
                $rowErrorArr = array();

                $columnMap = array(
                    'A'  => 'tower_name',
                    'B'  => 'unit',
                    'C'  => 'unit_group',
                    'D'  => 'number_type',
                    'E'  => 'range_label',
                    'F'  => 'range_start_from',
                    'G'  => 'bhk',
                    'H'  => 'sqr_ft',
                    'I'  => 'carpet_area',
                );

                //load dataSave with data in db columns
                foreach ($columnMap as $excelCol => $colMKey) {
                    $dataSave[$colMKey] = isset($row[$excelCol]) ? $row[$excelCol] : "";
                }
                $dataRowResponse = $dataSave;
                $dataSave = array_map('trim', $dataSave);

                if (empty($rowErrorArr)) {
                    if($dataSave['tower_name'] != "" && $dataSave['tower_name'] != NULL){
                        if(isset($towerArr[$dataSave['tower_name']])){
                            $dataSave['tower_id'] = $towerArr[$dataSave['tower_name']]['tower_id'];
                            $dataSave['tower_slug'] = $towerArr[$dataSave['tower_name']]['tower_slug'];
                        } else {
                            $dataSave['tower_id'] = '';
                            if(isset($towerInsertArr[$dataSave['tower_name']])){
                                $towerSlug = $towerInsertArr[$dataSave['tower_name']]['tower_slug'];
                            } else {
                                $towerSlug = random_string();
                            }
                            $dataSave['tower_slug'] = $towerSlug;
                            $towerInsertArr[$dataSave['tower_name']] = array(
                                'tower_id' => $dataSave['tower_id'],
                                'tower_slug' => $towerSlug,
                                'tower_name' => $dataSave['tower_name'],
                                'society_id' => $this->session->get('society_id'),
                                'is_active' => 1,
                                'created_by' => $userId,
                                'updated_by' => $userId,
                                'created_at' => date("Y-m-d H:i:s"),
                                'updated_at' => date("Y-m-d H:i:s"),
                            );
                        }
                    } else {
                        array_push($errorRowArr[101], $rowNumber);
                        array_push($rowErrorArr, 101);
                    }

                    if ($dataSave['unit'] != "" && $dataSave['unit'] != NULL) {
                        if (is_numeric($dataSave['unit'])) {
                            if($dataSave['unit'] < 0){
                                array_push($errorRowArr[203], $rowNumber);
                                array_push($rowErrorArr, 203);
                            } 
                        } else {
                            array_push($errorRowArr[202], $rowNumber);
                            array_push($rowErrorArr, 202);
                        }
                    } else {
                        array_push($errorRowArr[201], $rowNumber);
                        array_push($rowErrorArr, 201);
                    }

                    if($dataSave['unit_group'] == "" && $dataSave['unit_group'] == NULL){
                        array_push($errorRowArr[301], $rowNumber);
                        array_push($rowErrorArr, 301);
                    }

                    if ($dataSave['number_type'] != "" && $dataSave['number_type'] != NULL) {
                        if(!isset($numberTypeData[strtolower($dataSave['number_type'])])){
                            array_push($errorRowArr[402], $rowNumber);
                            array_push($rowErrorArr, 402);
                        }else{
                            $dataSave['number_type'] = strtolower($dataSave['number_type']);
                        }
                    } else {
                        array_push($errorRowArr[401], $rowNumber);
                        array_push($rowErrorArr, 401);
                    }

                    if(strtolower($dataSave['number_type']) == 'range'){
                        if($dataSave['range_label'] == "" && $dataSave['range_label'] == NULL){
                            array_push($errorRowArr[501], $rowNumber);
                            array_push($rowErrorArr, 501);
                        }

                        if($dataSave['range_start_from'] == "" && $dataSave['range_start_from'] == NULL){
                            array_push($errorRowArr[601], $rowNumber);
                            array_push($rowErrorArr, 601);
                        }
                    }

                    if($dataSave['bhk'] == "" && $dataSave['bhk'] == NULL){
                        array_push($errorRowArr[701], $rowNumber);
                        array_push($rowErrorArr, 701);
                    }

                    if($dataSave['sqr_ft'] == "" && $dataSave['sqr_ft'] == NULL){
                        array_push($errorRowArr[801], $rowNumber);
                        array_push($rowErrorArr, 801);
                    }

                    if($dataSave['carpet_area'] == "" && $dataSave['carpet_area'] == NULL){
                        array_push($errorRowArr[901], $rowNumber);
                        array_push($rowErrorArr, 901);
                    }

                    $dataSave['tower_unit_slug'] = random_string();
                }

                if(empty($rowErrorArr)){
                    $successEntries++;
                    // $this->maxWipModel->saveCsv($dataSave, $userId);
                    $dataSaveBatch[] = $dataSave;
                }else{

                    $errorPrintExcel = array();
                    foreach ($rowErrorArr as $eachError){
                        $errorPrintExcel[] = $customErrors[$eachError];
                    }
                    $errorPrintExcel = implode("\n\n", $errorPrintExcel);
                    $dataRowResponse['remarks'] = $errorPrintExcel;
                    $dataResponse[] = $dataRowResponse;
                    $failedEntries++;
                }

            }
            // printArray($dataSaveBatch,1);

            $reponsePath = $dirAbsPath . $filePrefix . '_RESPONSE.csv';
            $reponseRelativePath = $dirRelPath . $filePrefix . '_RESPONSE.csv';

            $csvFileName = $dirAbsPath . $filePrefix . '.csv'; 
            $zipFileName = $dirRelPath . $filePrefix . '.zip'; 
            $csvResponseFileName = $dirAbsPath . $filePrefix . '_RESPONSE.csv'; 
            $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
            
            if(MAKE_ZIP){
                $zipFileName = $dirRelPath . $filePrefix . '.zip';
                $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.zip';
            } else {
                $zipFileName = $dirRelPath . $filePrefix . '.csv';
                $zipResponseFileName = $dirRelPath . $filePrefix . '_RESPONSE.csv';
            }

            $errorMessageDb = '';
            if (!$this->dt_ci_common->checkError($errorRowArr)) {
                $response['result'] = "data_error";
                $errorMessage = "<a class='alert-link' href='javascript:void(0)'>There was an error while uploading file!</a><a href='" . base_url($zipResponseFileName) . "' class='pull-xs-right btn btn-danger' style='color: white;' target='_blank'>Download Response File</a><br></b>";

                foreach ($errorRowArr as $key => $value) {
                    if (count($value) > 0) {
                        if (SHOW_UPLOAD_ERROR) {
                            $errorMessage .= '<a href="javascript:void(0)">' . $customErrors[$key] . '</a> in <a class="alert-link" href="javascript:void(0)">ROW# ' . implode(", ", $value) . "</a><br><br>";
                        }
                    }
                }
                $response['errorMessage'] = $errorMessage;
            } else {
                $response['result'] = $errorMessageDb = "ok";
            }

            if (!empty($dataSaveBatch)) {
                foreach ($dataSaveBatch as $dataSaveElement) {
                    
                    $towerUnitInsertArr[] = array(
                        'tower_unit_id' => '',
                        'tower_slug' => $dataSaveElement['tower_slug'],
                        'tower_unit_slug' => $dataSaveElement['tower_unit_slug'],
                        'unit' => $dataSaveElement['unit'],
                        'unit_group' => $dataSaveElement['unit_group'],
                        'number_type' => $dataSaveElement['number_type'],
                        'range_label' => $dataSaveElement['range_label'],
                        'range_start_from' => $dataSaveElement['range_start_from'],
                        'sqr_ft' => $dataSaveElement['sqr_ft'],
                        'bhk' => $dataSaveElement['bhk'],
                        'carpet_area' => $dataSaveElement['carpet_area'],
                        // 'society_id' => $this->session->get('society_id'),
                        'created_by' => $userId,
                        'updated_by' => $userId,
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );

                    if($dataSaveElement['number_type'] == 'range'){
                        $endRangeForm = $dataSaveElement['range_start_from'] + $dataSaveElement['unit'];
                        for($i = $dataSaveElement['range_start_from']; $i<$endRangeForm; $i++) {
                            $flatArray = array(
                                'flat_id' => '',
                                'tower_slug' => $dataSaveElement['tower_slug'],
                                'tower_unit_slug' => $dataSaveElement['tower_unit_slug'],
                                'flat_no' => $dataSaveElement['range_label']."-".$i,
                                'sqr_ft' => roundNumber($dataSaveElement['sqr_ft']),
                                'bhk' => roundNumber($dataSaveElement['bhk']),
                                'carpet_area' =>$dataSaveElement['carpet_area'],
                                'society_id' => $this->session->get('society_id'),
                                'is_active' => 1,
                            );
                            $towerFlatInsertArr[] = $flatArray;
                            // $flatData = $this->tower_model->insertUpdateRecord($flatArray,'flat_id','tbl_flat', 1,'',array(),array(),array());
                        }
                    } else {
                        // if($dataSave['number_type'] == 'manual'){
                            for($i = 1; $i<=$dataSaveElement['unit']; $i++) {
                                $flatArray = array(
                                    'flat_id' => '',
                                    'tower_slug' => $dataSaveElement['tower_slug'],
                                    'tower_unit_slug' => $dataSaveElement['tower_unit_slug'],
                                    'flat_no' => $i,
                                    'sqr_ft' => roundNumber($dataSaveElement['sqr_ft']),
                                    'bhk' => roundNumber($dataSaveElement['bhk']),
                                    'carpet_area' =>$dataSaveElement['carpet_area'],
                                    'society_id' => $this->session->get('society_id'),
                                    'is_active' => 1,
                                );
                                $towerFlatInsertArr[] = $flatArray;
                            }
                        // }
                    }
                }
            }

            if (isset($towerInsertArr) && !empty($towerInsertArr)) {
                $this->towerModel->insertBulkUpload($towerInsertArr,'tbl_tower');
            }
            if (isset($towerUnitInsertArr) && !empty($towerUnitInsertArr)) {
                $this->towerModel->insertBulkUpload($towerUnitInsertArr,'tbl_tower_unit');
            }
            if (isset($towerFlatInsertArr) && !empty($towerFlatInsertArr)) {
                $this->towerModel->insertBulkUpload($towerFlatInsertArr,'tbl_flat');
            }

            $this->towerModel->updateTowerId();
            $this->towerModel->updateTowerUnitId();

            $this->dt_ci_common->printResponseCsv($reponsePath, $dataResponse);

            $fileArray = array(
                'file' => $dirAbsPath . $filePrefix . '.csv',
                'response_file' => $reponsePath,
            );

            createZipFromFile($fileArray);

            $fileDbResponse = array(
                "text" => $errorMessageDb,
                "success" => $successEntries,
                "failed" => $failedEntries,
                "duplicates" => 0,
            );

            $fileUploadData = array(
                "file_type" => $masterType,
                // "filepath" => $dirRelPath . $uploadData->getName(),
                "filepath" => $zipFileName,
                "user_id" => $userId,
                "start_time" => $startTime,
                "end_time" => date('Y-m-d H:i:s'),
                "response_path" => $zipResponseFileName,
                "response" => json_encode($fileDbResponse),
                'society_id' => $this->session->get('society_id'),
                "auto_upload" => !is_array($file) && $file != "" ? 1 : 0,
            );

            $this->fileUploadModel->saveData($fileUploadData);
        }

        if (!$return) {
            echo json_encode($response);
        } else {
            if (isset($fileUploadData)) $response['file_upload_data'] = $fileUploadData;
            return $response;
        }
    }
}